/*
 	@(#)bootinfo.h	1.8 88/03/19 

	This structure is filled in by the Altos secondary boot, and it's
	physical location in memory is passed to the startup code in
	oemsup.s.  It is currently used to initialize the sio and
	multidrop boards correctly.
	Note that the offsets into the array correspond to how the
	boards are strapped to appear, not which backplane slot they
	are in.  Thus the 'master comm' board would appear with offset
	'0'.

	This scheme probably needs some more work (I initially thought
	that board 'id' was determined by the slot it was in, not by
	how a jumper/switch was configured.

	Dave Olson, 2/86.
*/
#define NSLOTS 8

/* different board types */
#define IS_EMPTY 0
#define IS_CPU 1
#define IS_MEM 2
#define IS_SIO 3
#define IS_MDROP	4
#define IS_FPROC	5
#define IS_ACPA	6
#define IS_COM 7
#define IS_MONO 8
#define IS_EFPROC 9
#define IS_UNKNOWN	127

struct boot_info {
	unsigned char what[NSLOTS];
	unsigned short version[NSLOTS];
};

struct tune_info {
/* 0 */	int nbuf;		/* BOOT TIME TUNEABLE PARAMETERS */
/* 1 */	int ninode;
/* 2 */	int ns5inode;
/* 3 */	int nfile;
/* 4 */	int nproc;
/* 5 */	int nclist;
/* 6 */	int nregion;
/* 7 */	int nofiles;		/* max number of files opened per process */
	short tuned;		/* this field is 1 if the values of the above */
				/* parameters are valid. 0 if they are not    */
};

#define NUMTUNES   8		/* number of tuneable parameters in the     */
				/* tune_info structure */

#define TUNEWARN	   02   /* the tuned value is wrong  		*/
#define	TUNED		   01	/* parameter was tuned 			*/

#ifdef INKERNEL
/* set to either IS_SIO or IS_MDROP or IS_COM(series 500) by initboards */
extern short contype;
#endif /* INKERNEL */
