/*
 *  @(#)at_ansi.h	1.1 88/03/19 
 *
 * definitions for PC AT x3.64 terminal emulator
 */

/*
 * Copyrighted as an unpublished work.
 * (c) Copyright 1986 INTERACTIVE Systems Corporation
 * All rights reserved.
 *
 * RESTRICTED RIGHTS
 *
 * These programs are supplied under a license.  They may be used,
 * disclosed, and/or copied only as permitted under such license
 * agreement.  Any copy must contain the above copyright notice and
 * this restricted rights notice.  Use, copying, and/or disclosure
 * of the programs is strictly prohibited unless otherwise provided
 * in the license agreement.
 */


#define ANSI_MAXPARAMS	5	/* maximum number of ANSI paramters */
#define ANSI_MAXTAB	40	/* maximum number of tab stops */

#define	ANSI_MOVEBASE	0x0001	/* if set move base when scrolling */

/*
 * directions for moving bytes in screen memory.
 * UP means toward higher addresses.
 * DOWN means toward lower addresses.
 */
#define UP 	0
#define DOWN 	1

struct attrmask {
	unchar attr;		/* new attribute to turn on */
	unchar mask;		/* old attributes to leave on */
};

struct ansistate {	/* state for ansi x3.64 emulator */
	ushort	*scraddr;	/* pointer to char/attribute buffer */
	short	ansiid;		/* unique id for this x3.64 terminal */
	ushort	flags;		/* flags for this x3.64 terminal */
	ushort	width;		/* number of characters horizontally */
	ushort	height;		/* number of characters vertically */
	ushort	scrsize;	/* number of characters on screen */
	struct	attrmask	*attrmask; /* attribute masks/values ptr */
	char	nattrmsks;	/* size of attrmask array */
	unchar	normattr;	/* "normal" attribute */
	unchar	undattr;	/* attribute to use when underlining */
	int 	(*bell)();	/* ptr to bell function */
	int 	(*clrdisplay)(); /* ptr to clrdisplay function */
	int 	(*moveit)();	/* ptr to moveit function */
	int 	(*setcursor)();	/* ptr to setcursor function */
	int 	(*setbase)();	/* ptr to setbase function */
	int 	(*storeword)();	/* ptr to storeword function */
	ushort	curbase;	/* upper left hand corner of screen in buffer */
	short	line;		/* current line number */
	short	column;		/* current column number */
	ushort	cursor;		/* current address of cursor, 0-based */
	unchar	state;		/* state in output esc seq processing */
	unchar	undstate;	/* underline processing state */
	unchar	attribute;	/* current attribute for characters */
	unchar	gotparam;	/* does output esc seq have a param */
	ushort	curparam;	/* current param # of output esc seq */
	ushort	paramval;	/* value of current param */
	short	params[ANSI_MAXPARAMS];	/* parameters of output esc seq */
	unchar	ntabs;		/* number of tab stops set */
	unchar	tabs[ANSI_MAXTAB];	/* list of tab stops */
};


