/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*  @(#)alttbl.h	1.2 88/03/19   */

/* This file defines the alternate sector table for the hard disk driver */


#define MAX_ALTENTS     62      /* Maximum number of alternate tracks */
				/* This lets entire table fit in 512 bytes */
struct  alt_ent {
	daddr_t badsec;         /* bad absolute sector number (0 == unused) */
	daddr_t goodsec;        /* alternate sector to use */
};


struct  alt_table {
	long    sanity;         /* to validate correctness */
	ushort  version;
	ushort  alts_used;      /* number of alternates assigned */
	ushort  alts_present;   /* total number of alternates available */
	ushort  alts_pad;       /* pad for 16-bit machine alignment */
	struct alt_ent alts[MAX_ALTENTS];       /* actual alternates */
	char    padding[4];     /* pad it out to 512 bytes */
};

#define ALT_SANITY      0xdeadbeef      /* magic # to validate alt table */

