/*
 *	@(#)align2.h	1.1 88/03/19 
 *
 *	Copyright (C) Microsoft Corporation, 1986
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

#pragma	pack(2)

/*
 *	struct msqid_ds {
 *		struct ipc_perm	msg_perm;
 *		struct msg near *msg_first;
 *		struct msg near *msg_last;
 *		ushort		msg_cbytes;
 *		ushort		msg_qnum;
 *		ushort		msg_qbytes;
 *		ushort		msg_lspid;
 *		ushort		msg_lrpid;
 *		time_t		msg_stime;
 *		time_t		msg_rtime;
 *		time_t		msg_ctime;
 *	};
 */
struct msqid_286 {
	struct ipc_perm	msg_perm;
	char		msg_first[2];
	char		msg_last[2];
	ushort		msg_cbytes;
	ushort		msg_qnum;
	ushort		msg_qbytes;
	ushort		msg_lspid;
	ushort		msg_lrpid;
	time_t		msg_stime;
	time_t		msg_rtime;
	time_t		msg_ctime;
};

struct msqid_386 {	/* for altos 386 v5.2 binaries */
	struct ipc_perm	msg_perm;
	struct msg	*msg_first;	/* ptr to first message on q */
	struct msg	*msg_last;	/* ptr to last message on q */
	ushort		msg_cbytes;
	ushort		msg_qnum;
	ushort		msg_qbytes;
	ushort		msg_lspid;
	ushort		msg_lrpid;
	time_t		msg_stime;
	time_t		msg_rtime;
	time_t		msg_ctime;
};

/*
 *	struct semid_ds {
 *		struct ipc_perm	sem_perm;
 *		struct sem near *sem_base;
 *		ushort		sem_nsems;
 *		time_t		sem_otime;
 *		time_t		sem_ctime;
 *	};
 */
struct semid_286 {
	struct ipc_perm	sem_perm;
	char		sem_base[2];
	ushort		sem_nsems;
	time_t		sem_otime;
	time_t		sem_ctime;
};

struct semid_386 {	/* for altos 386 v5.2 binaries */
	struct ipc_perm	sem_perm;
	struct sem	*sem_base;
	ushort		sem_nsems;
	time_t		sem_otime;
	time_t		sem_ctime;
};

/*
 *	struct	shmid_ds {
 *		struct	ipc_perm shm_perm;
 *		int	shm_segsz;
 *		ushort	shm_ptbl;
 *		ushort	shm_lpid;
 *		ushort	shm_cpid;
 *		ushort	shm_nattch;
 *		ushort	shm_cnattch;
 *		time_t	shm_atime;
 *		time_t	shm_dtime;
 *		time_t	shm_ctime;
 *	};		
 */
struct	 shmid_286 {
	struct ipc_perm	shm_perm;
	ushort		shm_segsz;
	ushort		shm_ptbl;
	ushort		shm_lpid;
	ushort		shm_cpid;
	ushort		shm_nattch;
	ushort		shm_cnattch;
	time_t		shm_atime;
	time_t		shm_dtime;
	time_t		shm_ctime;
};

struct shmid_386 { /* for altos 386 v5.2 binaries */
	struct ipc_perm	shm_perm;	/* operation permission struct */
	int		shm_segsz;	/* size of segment in bytes */
	struct region	*shm_reg;	/* ptr to region structure */
	char		pad[4];		/* for swap compatibility */
	ushort		shm_lpid;	/* pid of last shmop */
	ushort		shm_cpid;	/* pid of creator */
	ushort		shm_nattch;	/* used only for shminfo */
	ushort		shm_cnattch;	/* used only for shminfo */
	time_t		shm_atime;	/* last shmat time */
	time_t		shm_dtime;	/* last shmdt time */
	time_t		shm_ctime;	/* last change time */
};

#pragma	pack()
