/*
 *	@(#)align1.h	1.5 88/03/19 
 *
 *	Copyright (C) Microsoft Corporation, 1986
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

#pragma	pack(2)

/*
 *	struct saddr {			
 *		unsigned short	sa_seg;
 *		long		sa_off;
 *	};
 */
struct saddr_286 {			
	unsigned short	sa_seg;
	long		sa_off;
};


/*
 *	struct stat {
 *		dev_t	st_dev;
 *		ino_t	st_ino;
 *		ushort	st_mode;
 *		short	st_nlink;
 *		ushort	st_uid;
 *		ushort	st_gid;
 *		dev_t	st_rdev;
 *		off_t	st_size;
 *		time_t	st_atime;
 *		time_t	st_mtime;
 *		time_t	st_ctime;
 *	};
 */
struct stat_286 {
	dev_t	st_dev;
	ino_t	st_ino;
	ushort	st_mode;
	short	st_nlink;
	ushort	st_uid;
	ushort	st_gid;
	dev_t	st_rdev;
	off_t	st_size;
	time_t	st_atime;
	time_t	st_mtime;
	time_t	st_ctime;
};


/*
 *	struct  ustat {
 *		daddr_t	f_tfree;
 *		ino_t	f_tinode;
 *		char	f_fname[6];
 *		char	f_fpack[6];
 *	};
 */
struct  ustat_286 {
	daddr_t	f_tfree;	/* total free */
	ino_t	f_tinode;	/* total inodes free */
	char	f_fname[6];	/* filsys name */
	char	f_fpack[6];	/* filsys pack name */
};


/*
 *	struct utsname {
 *		char	sysname[9];
 *		char	nodename[9];
 *		char	release[9];
 *		char	version[9];
 *		char	machine[9];
 *		unsigned short	sysorigin;
 *		unsigned short	sysoem;	
 *		long		sysserial;
 *	};
 */

struct utsname_286_v3 {		/* for Altos v3.x and SCO 286 v3.x binaries */
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	unsigned short	sysorigin;	/* original supplier of Xenix system */
	unsigned short	sysoem;		/* OEM for this system */
	long		sysserial;	/* serial number for this system */
};

struct utsname_286_v5 {		/* for SCO 286 v5.x binaries */
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	char	machine[9];
	char	reserved[15];
	unsigned short	sysorigin;	/* original supplier of Xenix system */
	unsigned short	sysoem;		/* OEM for this system */
	long		sysserial;	/* serial number for this system */
};

struct utsname_386_altos {	/* for altos 386 v5.2 binaries */
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	char	machine[9];
	unsigned short	sysorigin;	/* original supplier of Xenix system */
	unsigned short	sysoem;		/* OEM for this system */
	long		sysserial;	/* serial number for this system */
};

#pragma	pack()
struct utsname_coff {		/* for coff 386 binaries */
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	char	machine[9];
};

struct utsname_386_sco {	/* for SCO 386 v5.x binaries */
	char	sysname[9];
	char	nodename[9];
	char	release[9];
	char	version[9];
	char	machine[9];
	char	reserved[15];
	unsigned short	sysorigin;	/* original supplier of Xenix system */
	unsigned short	sysoem;		/* OEM for this system */
	long		sysserial;	/* serial number for this system */
};
