

	.text
	.globl	_bios
| int bios(num,regs)
| struct { int ax, bx, cx, dx; } regs

_bios:	push	bp
	mov	bp,sp
	push	di
	push	si
	mov	si,6(bp)	| get the registers from arg1
	mov	ax,(si)
	mov	bx,2(si)
	mov	cx,4(si)
	mov	dx,6(si)

	push	ds
	xor	di,di
	mov	ds,di		| es now points to page zero vectors

	mov	di,4(bp)	| get the interrupt number from arg0
	shl	di,*1
	shl	di,*1		| as a double word offset

	pushf			| simulate an interrupt
|	calli	@ds:(di)

	.byte	/ff		| CALL
	.byte	/1d		| no offset except DI

	pop	ds
	mov	(si),ax		| return the registers
	mov	2(si),bx
	mov	4(si),cx
	mov	6(si),dx

	pushf			| get & return the flags
	pop	ax
	cwd

	jmp	cret

	.globl	_inp, _inpw, _out, _outw

| int inp(portno), inpw(portno)
|     out(portno,byte), outw(portno, word);
|
| int portno; int word; char byte;

_inp:	push	bp
	mov	bp,sp
	push	di
	push	si

	mov	dx,4(bp)	| port number
|	in	al,dx
	.byte	/ec

	xor	ah,ah
	cwd
	jmp	cret

_inpw:	push	bp
	mov	bp,sp
	push	di
	push	si

	mov	dx,4(bp)
|	inw	ax,dx
	.byte	/ed

	cwd
	jmp	cret

_out:	push	bp
	mov	bp,sp
	push	di
	push	si

	mov	dx,4(bp)
	mov	ax,6(bp)
|	out	dx,al
	.byte	/ee

	jmp	cret

_outw:	push	bp
	mov	bp,sp
	push	di
	push	si

	mov	dx,4(bp)
	mov	ax,6(bp)
|	outw	dx,ax
	.byte	/ef

	jmp	cret

