/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */

#define TRUE  1
#define FALSE 0

main(argc, argv)
int argc;
char *argv[];
{
   int fd1, fd2, eof1, eof2, diff, i;
   int blk = 0;
   char buf1[512], buf2[512];

   if (argc != 3)
      error("Usage: icmp file1 file2");

   if ((fd1 = open(*++argv, 0)) < 0) {
      printf("icmp: can't open %s\n", *argv);
      exit(-1);
   }

   if ((fd2 = open(*++argv, 0)) < 0) {
      printf("icmp: can't open %s\n", *argv);
      exit(-1);
   }

   eof1 = getblk(fd1, buf1, 512);
   eof2 = getblk(fd2, buf2, 512);

   while (eof1 == FALSE && eof2 == FALSE) {
      diff = FALSE;
      for (i = 0; i < 512; i++)
	 if (buf1[i] != buf2[i]) {
	    diff = TRUE;
	    break;
	 }
      if (diff == TRUE)
	 printf("differences in block %d (%x hex bytes)\n", blk, blk*512);
      blk++;
      eof1 = getblk(fd1, buf1, 512);
      eof2 = getblk(fd2, buf2, 512);
   }

   if (eof1 != eof2)
      printf("+++   files have different lengths   +++\n");

} /* end-main */

getblk(fd, buf, buflen)
int	fd;
char	buf[];
int	buflen;
{
   int	n;

   if ((n = read(fd, buf, buflen)) == buflen)
      return(FALSE);

   if (n == 0)
      return(TRUE);

   error("icmp: file not a multiple of 512");
} /* end-getblk */

char hexdigit(x)
int x;
{
   return( ((x&15) <= 9) ? ((x & 15) + '0') : (((x & 15) - 10) + 'A') );
} /* end-hexdigit */

itohex(outstr, inpval, prec)
char outstr[];
int inpval, prec;
{
   int i;
   outstr[prec] = '\0';
   for (i = prec - 1; i >= 0; inpval >>= 4, i--)
      outstr[i] = hexdigit(inpval);
} /* end-itohex */

error(msg)
char *msg;
{
   printf("%s\n", msg);
   exit(-1);
} /* end-error */
