#include "stdio.h"
#define MAXBIN 54

char conv[] = 
   "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz+-";
char rconv[256];
long bchksum;
int bmode;

main(argc,argv)
int argc;
char *argv[];
{
   char line[133];
   int chan, e;

   bsetup();
   binit();
   if (strcmp(argv[1],"-w") == 0) {
      chan = creat(argv[2],0777);
      while (gets(line) != NULL)
	 if ((e = bwrline(chan,line)) < 0) break;
      if (e == -2) printf("Local file write error.\n");
      else if (e == -3) printf("Checksum does not match.\n");
      else if (e == -4) printf("Invalid character in host data.\n");
   } else {
      chan = open(argv[2],0);
      while ((e = brdline(chan,line)) >= 0)
	 printf("%s\n",line);
      if (e == -2) printf("Local file read error.\n");
   }
}

bsetup()
{
   int i;

/* Initialize rconv to all invalid characters to start with */
   for (i = 0; i < 256; i++)
      rconv[i] = 0101;
/* Then setup the reverse of conv for translation */
   for (i = 0; i < 64; i++)
      rconv[conv[i]] = i; 
/* The end-of-line character */
   rconv[0] = 0100;
}

binit()
{
   bchksum = 0;
   bmode = 0;
}

brdline(fd,line)
int fd;
char *line;
{
   char buf[MAXBIN], *s;
   int count, linelen, c1, c2, c3;

   count = read(fd,s = buf,MAXBIN);
   if (count > 0) {
      bmode = 0;
      linelen = (count/3*4) + count%3;
   } else if (count <0) {
      return (-2);
   } else {
      if (bmode == 0) {
	 *line++ = '.';
	 buf[0] = bchksum & 0377;
	 buf[1] = (bchksum>>8) & 0377;
	 buf[2] = (bchksum>>16) & 0377;
	 count = 3;
	 bmode = 1;
	 linelen = 1 + 4;
      } else {
	 return (-1);
      }
   }
   while (count-- > 0) {
      c1 = *s++ & 0377;
      bchksum += c1;
      *line++ = conv[c1 >> 2];
      c2 = *s++ & 0377;
      if (count-- <= 0) {
	 *line++ = conv[(c1 << 4) & 060];
	 break;
      } else {
	 *line++ = conv[((c1 << 4) & 060) | ((c2 >> 4) & 017)];
	 bchksum += c2;
      }
      c3 = *s++ & 0377;
      if (count-- <= 0) {
	 *line++ = conv[(c2 << 2) & 074];
	 break;
      } else {
	 *line++ = conv[((c2 << 2) & 074) | ((c3 >> 6) & 003)];
	 bchksum += c3;
      }
      *line++ = conv[c3 & 077];
   }
   *line++ = '\0';
   return (linelen);
}

bwrline(fd,line)
int fd;
char *line;
{
   char buf[MAXBIN], *d;
   int count, c, c1, c2, c3, c4;

   if (*line != '.') {
      bmode = 0;
   } else {
      bmode = 1;
      line++;
   }
   d = buf;
   count = 0;
   while (1) {
      if ((c1 = rconv[*line++]) == 0100) break;
      else if (c1 == 0101) return (-4);
      if ((c2 = rconv[*line++]) == 0100) break;
      else if (c2 == 0101) return (-4);
      *d++ = c = (c1 << 2) | (c2 >> 4);
      count++; if (bmode == 0) bchksum += c & 0377;
      if ((c3 = rconv[*line++]) == 0100) break;
      else if (c3 == 0101) return (-4);
      *d++ = c = (c2 << 4) | (c3 >> 2);
      count++; if (bmode == 0) bchksum += c & 0377;
      if ((c4 = rconv[*line++]) == 0100) break;
      else if (c4 == 0101) return (-4);
      *d++ = c = (c3 << 6) | c4;
      count++; if (bmode == 0) bchksum += c & 0377;
   }
   if (bmode == 0) {
      if (write(fd,buf,count) != count) return (-2);
      return (count);
   } else {
      if (((bchksum & 0377) != (buf[0] & 0377))
	    || (((bchksum >> 8) & 0377) != (buf[1] & 0377))
	    || (((bchksum >> 16) & 0377) != (buf[2] & 0377))) return (-3);
      return (-1);
   }
}
