#include "stdio.h"
FILE *inchan, *outchan;
long lwadr=0, hwadr=0;

main(argc,argv)
int argc;
char *argv[];
{
   int i;

   if (argc < 3) {
      puts("Too few arguments\n");
      return;
   }
   inchan = fopen(argv[1],"r");
   outchan = fopen(argv[2],"w");
   if (inchan == NULL || outchan == NULL) {
      puts("Files could not be openned\n");
      return;
   }
   while ((i=doline()) == 0);
   if (i != -1) {
      fprintf(stderr,"Bad .AO file\r\n");
      return;
   }
   fclose(inchan); fclose(outchan);
   fprintf(stderr,"\r\nDone\r\n");
}

int doline()
{
   char rec[133], *p;
   int cksum, n;
   long adr;

   if (getrec(rec,132) <= 0) return -1;
   adr = ((rec[1]&0xFF) + ((rec[0]&0xFF)<<8)) & 0xFFFFL;
   if (adr != lwadr) {
      if (adr > hwadr) {
	 fseek(outchan,hwadr,0);
	 for (;hwadr < adr; hwadr++)
	    fputc(0,outchan);
      }
      fseek(outchan,adr,0);
   }
   lwadr = adr;
   fprintf(stderr,"%4x\r",(unsigned) adr);
   for (cksum=0,p = &rec[3],n = rec[2]; n > 0; n--) {
      cksum += *p; 
      fputc(*p++,outchan);
      lwadr++;
   }
   if (hwadr < lwadr) hwadr = lwadr;
   if (((cksum + *p)&0xFF) != 0) return -2;
   return 0;
}

int getrec(p,n)
char *p;
int n;
{
   int l=0, v1, v2;

   while (n-- > 0) {
      if ((v1 = gc()) < 0) return l;
      if ((v2 = gc()) < 0) return l;
      *p++ = (v1<<4) + v2;
      l++;
   }
}

int gc()
{
   int data;
   do {
      if ((data = fgetc(inchan)) == EOF) return -1;
   } while (data == 1 || data == '\r');
   if (data >= '0' && data <= '9') return data-'0';
   if (data >= 'A' && data <= 'F') return data-'A'+10;
   if (data >= 'a' && data <= 'f') return data-'f'+10;
   return -2;
}
