/*************************************************************************
*
*
*	Name:  sfint.h
*
*	Description:  Sform internal routines include file.
*
*
*	History:
*	Date		By		Comments
*
*	04/16/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  This file should be included in all sform modules.
	  It defines internal parameters & values.

*/

#include	"/sform/src/sform.h"


#if	SF_PC						/* Define PC terminal driver */
#define		ANSI		0		/* ANSI.SYS driver installed */
								/* (default = TIP driver) */
#endif
#if	SF_PC
#include	<stdio.h>		/* Xenix implicitly includes stdio.h (?) */
#endif



/*************************
**		Constants		**
*************************/


/* Values returned by the 'extended read' function. */
/* Ranges */
#define		SF_CHIC		255		/* Highest char value */
#define		SF_CHIFK	511		/* Highest fn key value */
/* Other return values */
#define		SF_CUNP		512		/* Unpend input */
#define		SF_CDEL		513		/* Erase */
#define		SF_CKILL	514		/* Kill */
#define		SF_CBAD		515		/* Bad input value */
#define		SF_CBFN		516		/* Bad (undefined) function key */


/* Error flags returned by internal formated scan & print fn's */
#define		SF_FFMT		-1		/* Format str parse error */
#define		SF_FSTR		-2		/* Input str scan error */
#define		SF_FCOVF	-3		/* Input str char overflow - too many chars */
#define		SF_FNOVF	-4		/* Numeric overflow - input number too big */
#define		SF_FERR		-9		/* Generic error */


/* define ranges of input chars & codes */
#define		CHARLO		32		/* lower bound */
#define		CHARHI		127		/* upper bound */
#define		FNKEYHI		TI_SF11	/* Highest fn key presently allowed	*/

/******************************/
/*    Global variables        */
/******************************/


/* This variables are defined and commented in sfdata.c */
extern	struct SF_FIELD	sf_nullfld ;
extern	struct SF_WINDOW *sf_curwin ;
extern	int		sf_nchars ;
extern	char	sf_delchar ;
extern	char	sf_killchar ;
extern	unsigned sf_datr ;
extern	int		sf_curfld ;
extern	int		sf_hifld ;
extern	int		sf_errflg ;
extern	char	*sf_spchr ;
extern	int		(*sf_usrerr)() ;
extern	int		sfcurcol ;
extern	int		sfcurrow ;
extern	int		(*sf_fntable)[][2] ;
extern	int		sf_fldmod ;

/* Other externs */
extern	int		tp_ascii ;		/* ascii val of last char input via TIP */
