/*************************************************************************
*
*
*	Name:  prat.c
*
*	Description:  System dependent terminal control.
*
*					sfprat()	- BB 'print @' functionality.
*
*
*	History:
*	Date		By		Comments
*
*	03/14/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  Terminal control is currently implemented via the 'sfprat()' function.
	This fn mimics the BB 'PRINT @' functionality. This is currently
	workable, but may need to be changed in the future.

*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"



sfprat ( arg1, arg2 )

int		arg1, arg2 ;

/* Implements BB's 'print @(code)' functionality.
   The arg1 & arg2 values are exactly the same as BB's.
*/

{


	if ( arg1 >= 0 ) {

		/* cursor positioning */
		sfposcur(arg1, arg2) ;
		return ;
	}

	else {

		/* Control code */
		cntrlcod(arg1, arg2) ;
	}
}



static	badcode ()

/* Bad control code */

{

	sfpanic("prat: Illegal control code.") ;
}

/* Control codes for TIP.
   Note - Display attributes are not fully implemented.
   ** NOTE ** - * integer * values.
   Note that each entry is one integer value. */
int		sfcntrl[] = {
	TO_MCH,		/* -20 home cursor */
	-1,			/* -21 cursor right */
	-1,			/* -22 cursor down */
	TO_MCL,		/* -23 cursor left */
	-1,			/* -24 cursor up */
	7,			/* -25 bell */
	9,			/* -26 tab */
	13,			/* -27 return (no line-feed) */
	10,			/* -28 new-line */
	-1,			/* -29 back tab */
	TO_CS,		/* -30 clear all to spaces */
	-1,			/* -31 clear unprotected to spaces */
	TO_ERL,		/* -32 clear to end of line */
	-1,			/* -33 clear to end of page */
	-1,			/* -34 keyboard lock */
	-1,			/* -35 keyboard unlock */
	-1,			/* -36 insert line */
	-1,			/* -37 delete line */
	TO_SDIM,	/* -38 start protect (low intensity) */
	TO_EDIM,	/* -39 start unprotect (high intensity) */
	TO_SBLNK,	/* -40 start blink */
	TO_EBLNK,	/* -41 end blink */
	-1,			/* -42 set format mode */
	-1,			/* -43 end format mode */
	-1,			/* -44 set program mode */
	-1,			/* -45 end program mode */
	-1,			/* -46 set block mode */
	-1,			/* -47 set conversation mode */
	-1,			/* -48 set flag 1 */
	-1,			/* -49 clear flag 1 */
	-1,			/* -50 send line (field) unprotected */
	-1,			/* -51 send line (field) all */
	TO_SUNDL,	/* -52 start underscore */
	TO_EUNDL,	/* -53 end under score */
	-1,			/* -54 start field (bright & underscore ) */
	TO_VNORM,	/* -55 end field (dim & normal ) */
	TO_VNORM,	/* -56 return to normal */
} 
;

#define	MAXCNTRL	56		/* largest entry in cntrl array */

static	cntrlcod ( arg1, arg2 )

int		arg1, arg2 ;

/* Process control code.
*/

{
	register int	code ;



	arg1 = -arg1 ;		/* make code positive */
	if ( arg1 > MAXCNTRL ) {
		badcode() ;		/* too big */

	}
	if ( arg1 >= 20 ) {

		/* Use cntrl string */
		code = sfcntrl[arg1 - 20] ;		/* control code */
		if ( code != -1 )
			stputc(code) ;
	}

	else {

		/* Do control */
		switch ( arg1 ) {

			case 18 :
				if ( arg2 == 3 ) {
					/* Disable scroll */
					stputc(TO_ESCRL) ;
				}
				else if ( arg2 == -3 ) {
					/* Enable scroll */
					stputc(TO_SSCRL) ;
				}
				else
					badcode() ;
				break ;

			default :
				badcode ;
		}
	}
}
