/*************************************************************************
*
*
*	Name:  labio.c
*
*	Description:  Label field i/o.
*
*
*	History:
*	Date		By		Comments
*
*	03/20/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  Note that labels fields can only be output.
*/

#include	"/sform/src/sfint.h"



sflabio ( fld_desc, mode, data_ptr )

struct SF_FIELD *fld_desc ;
int		mode ;
char	*data_ptr ;

/*
  Synopsis -
	Label field i/o.

  Description -
	Note that labels can only be displayed. The mode is checked before 
	calling genio() to save processing time.

  Return -
	return val	= SF_NXTFLD

  Notes -
*/

{
	register int	fc ;
	int	sflabinp(), sflabdisp() ;


	if ( mode == SF_DISPLAY )
		/* Display the field */
		fc = sfgenio(fld_desc, SF_DISPLAY, data_ptr, fld_desc->sf_width,
		sflabinp, sflabdisp) ;

	return(SF_NXTFLD) ;
}

sflabdisp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
char	*data_ptr ;

/*
  Synopsis -
	Display a label field.

  Description -
	The generic field display routine is used.

  Return -
	return val	= Completion code.

  Notes -
*/

{
	register int	fc ;


	fc = sfflddisp(fld_desc, data_ptr, 's') ;

	return(fc) ;
}

static	sflabinp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
char	*data_ptr ;

/* This is a dummy fn, as labels are never input. */

{
}
