/*************************************************************************
*
*
*	Name:  fnkeys.c
*
*	Description:  Define char values of the 'standard' SForm 'function keys'.
*
*
*	History:
*	Date		By		Comments
*
*	04/25/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"


/* Define SForm 'Fn Key' char values.
   Certain 'standard' functions are supported by the sform routines.
   The characters below are used to invoke these functions.
   Note that sform 'fn keys' may be defined to be the actual 'function
   keys' on the keyboard, or any other character or control code.
   If a keyboard 'function key' is hit, and it is not defined to be
   an sform 'fn key', the code for that keyboard function key is returned
   to the user (it is assumed that the user knows what to do with it).
*/

int		sf_stdftbl[][2]	= {
	/*	Char		Function	*/
	TI_F1,		SF_NXTFLD,
	TI_SF1,		SF_PRVFLD,
	TI_F2,		SF_NXTGRP,
	TI_SF2,		SF_PRVGRP,
	TI_F3,		SF_NXTWIN,
	TI_SF3,		SF_PRVWIN,
	TI_F4,		SF_NXTENUM,
	TI_SF4,		SF_PRVENUM,
	TI_F5,		SF_FLDFMT,
	TI_SF5,		SF_CLRFLD,

	TI_F7,		SF_HELP,
	TI_SF7,		SF_CLRERR,
	TI_F8,		SF_FINISH,
	TI_SF8,		SF_ABORT,


	/* Duplicates */
	TI_FTAB,	SF_NXTFLD,
	TI_BTAB,	SF_PRVFLD,

	/* end of list */
	0,			0
} 
;
