/*************************************************************************
*
*
*	Name:  curses.c
*
*	Description:  Cursor control, display characteristics control,
*				  & misc crt functions.
*
*					sfposcur()	- Position cursor.
*					sfsetdatr()	- Set display attributes.
*					sfceln()	- Clear to end of line.
*					sfcls()		- Clear screen.
*
*
*	History:
*	Date		By		Comments
*
*	04/16/84	waf
*	04/25/84	waf		Converted to TIP interface.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"



sfposcur ( row, col )

int		row, col ;		/* 0 based, absolute row & column numbers */

/*
  Synopsis -
	Position cursor to a point in the window or to the error line.

  Description -
	If row >= 0,  position cursor on the screen, using row & col.
	If row < 0,  position cursor to a predetermined position -
					-1 = error message line.

  Return -
	return val	= <undefined>

  Notes -
	**> If the row and/or col values are bad, cursor position is undefined.
	> If row < 0, the col value is currently ignored, and col '0' is used.
	This could be modified so that the column number is relevant.
*/

{


	if ( row < 0 ) {

		/* Defined position */
		row = -row ;
		switch ( row ) {

			case 1 :
				row = SF_ERRROW ;
				col = 0 ;
				break ;

			default :
				/** ignore **/
				break ;
		}
	}


	/* Position cursor to (row,col) */
	stputc(TO_MC, row, col) ;

}

sfsetdatr ( disp_atr )

unsigned disp_atr ;		/* display attribute 'word' */

/*
  Synopsis -
	Set up output display characteristics.

  Description -
	The 'disp_atr' parameter defines the display attributes desired.
	The necessary control chars are output to set up the display character-
	istics desired.
	This fn saves the input datr in the sf_datr global var, so that the system
	will ('sort of') know the current display attributes (see err.c).

  Return -
	return val	= <undefined>
  
  Notes -
  *> The 'display attribute word' is currently (temporarily) defined using
  bit flags defined in sform.h.
  > Note - the order in which the attr's are set is important in some
  environments.
  > Multiple characteristic flags are allowed.
*/

{
	register unsigned	datr ;
	register int		i ;


	datr = disp_atr ;		/* put it in reg var */

	/* 'Normal' display chars */
	if ( datr & SF_ATNORM )
		stputc(TO_VNORM) ;

	/* Reverse video */
	if ( datr & SF_ATREV )
		i = TO_SREV ;
	else
		i = TO_EREV ;
	stputc(i) ;

	/* Underline */
	if ( datr & SF_ATUNDLN )
		i = TO_SUNDL ;
	else
		i = TO_EUNDL ;
	stputc(i) ;

	/* Blinking */
	if ( datr & SF_ATBLNK )
		i = TO_SBLNK ;
	else
		i = TO_EBLNK ;
	stputc(i) ;

	/* Dim / Normal Intensity */
	if ( datr & SF_ATDIM )
		i = TO_SDIM ;
	else
		i = TO_EDIM ;
	stputc(i) ;


	/** Save the most recent datr word **/
	sf_datr = datr ;

}

sfceoln ()

/* Clear to end of line.
*/

{


	stputc(TO_ERL) ;
}



sfcls ()

/* Clear screen */

{


	stputc(TO_CS) ;
}
