/*************************************************************************
*
*
*	Name:  group.c
*
*	Description:  Field group list traversal functions -
*					sfnxtgrp() - find first field in next group.
*					sfprvgrp() - find first field in previous group.
*
*
*	History:
*	Date		By		Comments
*
*	03/15/84	waf
*	06/11/84	waf		**  Rev. 2.0  **
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

  The functions below implement 'grouping'. 
  These functions assume that the input field number is IN RANGE.
  Note that the 'grouping' of fields is TOTALLY DEFINED by the values in
the 'group link list'. The functions below select groups by BLINDLY following
the links.
  Note that 'label' fields are never the 'current fields'. Thus, the link
entries for labels are never used. Also note that label fields are always
skipped, so it may be best for links to point to only data fields.
  Note that '-1' (actually, any negative number) must be used to flag the end
of the linked list.

*/

#include	"/sform/src/sfint.h"

#define		NXT		1
#define		PRV		0



sfnxtgrp ( window, fldnum )
struct SF_WINDOW *window ;
int		fldnum ;
/*
  Synopsis -
	Given the current field # in 'fldnum', return the field # of
	the first field in the next group.

  Return -
	return val	= field # of first field in next group
					OR
				  current fld# if grouping no defined.
*/
{

	return( findgrp(window, fldnum, NXT) );
}



sfprvgrp ( window, fldnum )
struct SF_WINDOW *window ;
int		fldnum ;
/*
  Synopsis -
	Given the current field # in 'fldnum', return the field # of
	the first field in the previous group.

  Return -
	return val	= field # of first field in previous group
					OR
				  current fld# if grouping no defined.
*/
{

	return( findgrp(window, fldnum, PRV) );
}

static	findgrp ( window, fld, nxt )
struct SF_WINDOW *window ;
int		fld ;
int		nxt ;		/* next/previous flag */
/*
  This fn is called by sfnxtgrp() and sfprvgrp() to find the next (nxt=NXT)
  or previous (nxt=PRV) group.
  A field number is returned, as defined in the fn's above.
  If grouping is not defined, an error message is displayed.
  If no next/prev group exists, a 'beep' is output and the same fld # is
  returned.

  NOTE - A fld # of '-1' flags no next/prev group.
*/
{
	struct SF_GRPLINK	*link ;
	int		newfld ;

	/* See if grouping info exits */
	if (window->sf_grplist == (struct SF_GRPLINK (*)[]) SF_NULL) {

		/* no grouping info.
				   Show error msg & return fld. */
		sf_errmsg("Field grouping not defined for this window.") ;
		return(fld) ;
	}


	else {

		/* Get link */
		link = *(window->sf_grplist) + fld ;	/* ptr to link entry for fld */
		if (nxt)
			newfld = link->sf_nxtgrp ;	/* fld # of next group */
		else
			newfld = link->sf_prvgrp ;	/* fld # of prev group */
		if (newfld < 0) {
			/* end of list.
						   Beep & return same fld. */
			sfbeep() ;
			newfld = fld ;
		}
	}

	return(newfld) ;
}
