/*************************************************************************
*
*
*	Name:  getfld.c
*
*	Description:  Get a field (low level fld i/o).
*					stgetf()	- Get input fld.
*					sfgetc()	- Char input w/ filter.
*
*
*	History:
*	Date		By		Comments
*
*	06/11/84	waf		Rev. 2.0
*	06/26/84	waf		Edit 'justified' flds.
*	07/02/84	waf		M000 - NOECHO support.
*
*
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*  This document contains confidential/proprietary information.
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

  6/26/84
  The input fld is 'filled out' with spaces or zeroes to make a 'justified'
  field. The fld is returned with fill chars if the entire fld is not filled.
  Note that fill chars can be on the right, the left, or both sides.
  Input fld data is guaranteed null termed and 'full' (size = fld width).

*/

#include	"/sform/src/sfint.h"

/* Define 'fld modified' flag storage.
   This flag is set if the fld is modified by the user.
   NOTE that this flag can only be SET by this code.
   The CALLING code should reset the flag before invoking this code.
   This allows multiple calls to this routine (in case of SF_FLDFMT, etc.). */
int		st_mdt ;

static int	cos ;			/* Cursor offset from start of fld */



stgetf ( row, col, wid, attr, fld_data, mode, flags )
int		row, col ;			/* starting fld position */
int		wid ;				/* fld width */
unsigned attr ;				/* display attr */
char	*fld_data ;			/* display string & input buffer */
int		mode ;				/* i/o mode */
int		flags ;				/* fld bit flags */
/*
  Synopsis -
	Get a field.

  Description -
	The current fld data is displayed with the input display attribute,
	then, if mode is EDIT, new fld data is input.
	Editing is supported while inputting new data.
	Note that the cursor is not allowed to leave the field. If auto-unpend
	is set, then the this fn will return SF_NXTFLD when the cursor leaves
	the field on either side. If auto-unpend is reset, then the cursor will
	'stick' to the left or right margin.
	The entire fld is not redisplayed after every char/edit key. Only the
	'right side' (from the cursor) is redisplayed.
	Note that 'insert mode' is toggled every time the INS key is hit.
	Note that the input data is 'justified', e.g. filled with spaces on
	the left and/or right side. NOTE that left side fill chars are NOT
	supported (they are treated like significant chars).
	The global var 'st_mdt' is set if the fld is modified in any way.
	The global vars sf_nrmcur & sf_inscur are used to define the normal
	and insert cursor 'type's.

  Return -
	return val	=  SForm completion code.

  Notes -
	> The input string is a 'justified' fld; e.g. the input string is null
	term'ed & strlen = fld width.
	Note that the len is always the fld width. Even if chars are 'deleted',
	the str returned is the size of the fld.
	> Note that any unimplemented edit/cursor control codes are returned
	to the usr pgm.
	> The dspflg var is used to skip re-display of the fld when the fld
	data was not changed (i.e. after cursor control).
	> Input is not displayed if SF_NOECHO is set.
*/
{
	register int	c ;				/* input chars/codes */
	int				inattr ;		/* input attribute */
	int				fwid ;			/* fld width */
	int				insflg ;		/* insert mode flag */
	int				dspflg ;		/* if set, fld is redisplayed */
	int				aunpflg ;		/* 'auto unpend' flag */
	int				echoflg ;		/* 'echo input' flag */
	int				ovflg ;			/* overflow flag */
	int				endix ;			/* ix of last char pos in fld */
	int				sfc ;
	int				tattr ;
	int				n ;
	extern	sf_nrmcur, sf_inscur ;	/* cursor types */


	/* Initialize */
	cos = 0 ;
	inattr = attr + sf_inatros ;	/* input display attr */
	insflg = 0 ;					/* disable insert mode */
	fwid = wid ;					/* fld width */
	if (fwid == 0)
		fwid = strlen(fld_data) ;
	endix = fwid - 1 ;				/* ix of last char pos */

	/* Get bit flags relevent to this level */
	aunpflg = flags & SF_AUTOUNP ;
	echoflg = !(flags & SF_NOECHO) ;	/* M000 */

	/* Display the fld */
	tattr = (mode == SF_DISPLAY)? attr : inattr ;
	if (echoflg)
		stputf(row, col, fwid, tattr, fld_data) ;	/* show fld data */
	else
		stputf(row, col, fwid, tattr, " ") ;		/* show blanks */
	if (mode == SF_DISPLAY)
		return(SF_NXTFLD) ;			/* display only */
	dspflg = 0 ;					/* don't redisplay the fld 1st time */


again:
	/** (Re)display the fld & get next char/fn **/
	/* Chk cos */
	ovflg = 0 ;						/* reset overflow flag */
	if ((cos < 0) || (cos > endix)) {
		/* Curser is out of bounds */
		if (aunpflg) {
			sfc = SF_NXTFLD ;
			goto xit ;				/* auto unpend */
		}
		/* Bring cursor back in fld */
		if (cos < 0)
			cos = 0 ;				/* left side */
		else {
			cos = endix ;			/* right side */
			ovflg = -1 ;			/* flag overflow on next char */
		}
	}

	/* Show the fld, from (current pos - 1) to the end of the fld */
	if (dspflg && echoflg) {
		n = cos - 1 ;				/* char preceeding cursor */
		if (n < 0)
			n = 0 ;
		stputf(row, (col + n), (fwid - n), inattr, (fld_data + n)) ;
	}
	dspflg = 1 ;					/* default = redisplay the fld */

	/* Show the cursor */
	stscp(row, (col + cos)) ;


	/** Get next char or edit key **/
	c = sfgetc() ;
	if ((c < 0) || (c > 255))
		if ((c < SF_EDLOW) || (c > SF_EDHI)) {
			/* Non-Edit fn key -
			   End of edit. */
			sfc = c ;
			goto xit ;
		}
	if (c == SF_INSERT) {
		/* Toggle insert mode */
		if (insflg) {
			insflg = 0 ;
			stsct(sf_nrmcur) ;
		} else {
			insflg = -1 ;
			stsct(sf_inscur) ;
		}
		goto again ;
	}

	/* Set mdt flag */
	st_mdt = 1 ;

	if (c < 256) {

		/* Insert/Overwrite char */
		if (insflg) {
			/* Insert */
			if (strshr(fld_data, cos, fwid) < 0) {
				sfbeep() ;					/* fld overflow */
			} else {
				fld_data[cos] = c ;			/* insert char */
				cos++ ;
			}
		} else {
			/* Overwrite */
			if (ovflg)
				sfbeep() ;					/* flag fld overflow */
			fld_data[cos] = (char) c ;		/* overwrite char */
			cos++ ;
		}
	goto again ;
	}

	/* Process Edit key */
	switch (c) {

		case  SF_CLEFT :
			/* Cursor left */
			cos-- ;
			dspflg = 0 ;
			break ;
		
		case  SF_CRIGHT :
			/* Cursor right */
			cos++ ;
			dspflg = 0 ;
			break ;
		
		case  SF_DELCHR :
			/* Delete char at cursor */
			strshl(fld_data, cos, fwid) ;
			break ;
		
		case  SF_RUBOUT :
			/* Delete char to left of cursor */
			if (cos == 0)
				sfbeep() ;				/* there is no char to left */
			else {
				strshl(fld_data, cos-1, fwid) ;
				cos-- ;
				}
			break ;
		
		case  SF_ERSEOF :
		case  SF_ERSNXT :
			/* Erase to end of fld */
			spapnd(fld_data, cos, fwid) ;
			if (c == SF_ENTER) {
				/* Unpend */
				sfc = SF_NXTFLD ;
				goto xit ;
			}
			break ;
		
		default :
			/* Edit fn not implemented */
			return(c) ;
	}

	/* Loop */
	goto again ;


xit:
	/* Reset cursor type to 'normal' */
	stsct(sf_nrmcur) ;

	/* Return comp code */
	return(sfc) ;
}

static	strshr ( str, ix, fwid )
char	*str ;
int		ix ;
int		fwid ;
/*
  Shift substr from ix to end of fld to the right 1 place.
  Last char in str must be a ' '.
  The input arg ix is assumed < fwid.
  The string is null term'ed.

  Return val =	<0 if can't shift, else 0.
*/
{
	register char	*src, *dst ;
	register int	n ;

	fwid-- ;					/* make it reletive */
	dst = str + fwid ;			/* -> last char */
	if (*dst != ' ')
		return(-1) ;			/* can't shift */
	src = dst - 1 ;
	n = fwid - ix ;				/* # chars to shift */
	while (n--)
		*dst-- = *src-- ;
	return(0) ;
}



static	strshl ( str, ix, fwid )
char	*str ;
int		ix ;
int		fwid ;
/*
  Shift substring from (ix+1) to end of fld to the left 1 place.
  The arg ix is assumed < fwid.
  The string is null term'ed.
  A ' ' is placed at the end of the fld.
*/
{
	register char	*src, *dst ;
	register int	n ;

	fwid-- ;					/* make it reletive */
	n = fwid - ix ;				/* # chars to shift */
	dst = str + ix ;
	src = dst + 1 ;
	while (n--)
		*dst++ = *src++ ;
	*(str + fwid) = ' ' ;		/* put a ' ' at last char */
}



static	spapnd ( str, ix, fwid )
char	*str ;
int		ix ;
int		fwid ;
/*
  Append spaces to string, from ix to fwid.
*/
{
	register char	*cp ;
	register int	n ;

	n = fwid - ix ;				/* # of spaces */
	cp = str + ix ;				/* starting ix */
	if (n >= 0)
		while (n--)
			*cp++ = ' ' ;
}

sfgetc ()
/*
  Get next char (via stgetc()).
  Note - low level input filtering is done here.

  Returns input char/code.
  The static var cos is reset if the cursor is reset (by Help or Error).
*/
{
	register int	c ;
	register int	flg ;


	flg = 1 ;
	while (flg) {
		flg = 0 ;
		c = stgetc() ;

		/* Trap some input */
		switch (c) {
			case  SF_INVALID :
				sfbeep() ;
				flg = 1 ;			/* get another char */
				break ;
			case  SF_HELP :
				(*sf_usrhelp)() ;
				cos = 0 ;			/* reset cursor offset for stgetf() */
				flg =1 ;			/* get another char */
				break ;
		}

	}	/* loop */

	return(c) ;
}
