/*                                                              */
/*         Copyright 1984 Digital Communications Assoc.         */
/*                                                              */
/*								*/
/*	 Module: DEFINES.H					*/
/*								*/
/*	Purpose: common definition support			*/
/*								*/


/* macros for mode bit testing */

#define on(FLAG_BIT) ((mode&FLAG_BIT) == FLAG_BIT)
#define off(FLAG_BIT) ((mode&FLAG_BIT) != FLAG_BIT)


/*
	The host_def structure describes the basic transfer parameters
	as far as the host system is concerned. These can be altered
	and re-saved through the menu panel(s) of the entry program.
	The fields in the structure are used as follows:

	command		host command to invoke the mainframe component.
	prefix		user-id prefix to be pre-pended to data set
			names which are not fully qualified ('ds_name').
	disposition	access mode for ALLOCATE, can be SHR for shared
			access or OLD for exclusive access.


	The following items are control variables and serve to define
	various flags and timeout counts (see the actual data
	declaration in DATA.C for the initial settings):

	trig_time	number of seconds to allow before declaring
			the host system to be inactive when waiting
			for a trigger in the protocol layer.
	x_count		the number of loop iterations the "X-clock"
			symbol must remain blank before it is "safe"
			to assume the controller is finished.
	overlap		flag to determine whether or not to overlap
			screen i/o during the actual data transfer.
	force_waitx	flag to determine whether or not force a
			wait_x() test following the trigger in the
			protocol layer.


	The following items constitute the file-type array with one
	entry for each transfer type:

	file_type	"file" type for PC lookup to set transfer defaults.
	vol_ser		volume-serial for host file allocation.
	code_name	name of code file to be used, an extension of
			.COD is assumed if the name does not match the
			current internal code table name.
	pri_quan	host primary allocation quantity.
	sec_quan	host secondary allocation quantity.
	dir_blks	number of directory blocks for a PDS, 0 is used
			for a physical-sequential organization if no
			member name is specified.
	rec_size	record length for host data set.
	blk_size	physical block size for host data set.
	num_pos		starting position of line number field in host
			record, can be 0 for un-numbered (NONUM).
	num_len		length of line number field in host record, can
			be zero for un-numbered (NONUM).
	xfer_mode	type of data to be transferred as follows:
				0 - TEXT transfer.
				1 - BINARY transfer.
	exp_tabs expand ASCII HT tab character (09 hex) to spaces to
			provide tab stops each 8 columns as follows:
				0 - no.
				1 - yes.
	trunc_spaces	truncate trailing spaces as follows:
				0 - no.
				1 - yes.
	space_units	host allocation unit as follows:
				0 - TRKS.
				1 - BLKS.
				2 - CYLS.
				3 - unused.
	ul_case		lower-to-upper case translation as follows:
				0 - ASIS, no translation.
				1 - CAPS, translate lower case to upper case.
	rec_fmt		host record format as follows:
				0 - F
				1 - FB
				2 - V
				3 - VB
				4 - unused
				5 - unused
				6 - unused
				7 - unused

*/

struct host_def {
	char	command[64];
	char	prefix[64];
	char	disposition[4];
	struct {
		int	 trig_time;
		unsigned x_count;
		int	 overlap;
		int	 force_waitx;
	} controls;
	struct  {
		char	 file_type[9];
		char	 vol_ser[7];
		char	 code_name[9];
		int	 pri_quan;
		int	 sec_quan;
		int	 dir_blks;
	        int	 rec_size;
	        int	 blk_size;
	        int	 num_pos;
	        int	 num_len;
		struct {
			 unsigned	xfer_mode:2;
			 unsigned	exp_tabs:1;
			 unsigned	trunc_spaces:1;
			 unsigned	space_units:2;
			 unsigned	ul_case:1;
			 unsigned	rec_fmt:3;
		} sub_parm;
	} host_type[32];
};


/*
	The xfer_table structure defines the "extended" character set
	used for the actual data transmission through the 3270 network.
	It is used to define both the local (PC) and remote (host) sets
	of encode/decode tables. A copy is uplinked to the host at run
	time. The fields are used as follows:

		pc_dups		TRUE if there is overlap in the table
				as the PC uses it, FALSE otherwise.
		mf_dups		as above for the host.
		lead_in		array of lead-in class codes, three are
				currently in use.
		extend		array of extended control characters
				which use values < 0, currently seven
				are in use.
		bin_rep		array of repeat and binary conversion
				characters.
		xlat		the ASCII <=> buffer-code <=> EBCDIC
				translation table. This table is not
				necessarily complete, nor does it have
				to be a one-to-one mapping as the flags
				above indicate. There is a row for each
				character to be passed and the value UNDEF
				in all unused positions.

	The columns (second subscript) of xlat are defined as follows:

		0		ASCII character code (00 - FF).
		1		EBCDIC character code (00 - FF).
		2		Buffer-code of lead-in code for this
				character (00 - FF) or UNDEF if no lead-in
				is required.
		3		Buffer-code for the character.

*/

struct	xfer_table {
	int	pc_dups;
	int	mf_dups;
	char	lead_in[7];
	char	extend[12];
	char	bin_rep[65];
	int	xlat[256][4];
};


/* structure for DOS & BIOS system call interfaces */

struct regs {
	int	ax, bx, cx, dx, si, di;
};


/* non-int function definitions, some supplied with "C" */

long	transfer(), val(), get_count();
char	*stpchr(), *stpblk(), *stptok();


#define PRODUCT "OPUS"
#define VERSION "0.10T(F-PR)"


/* system constant definitions */

#define FALSE		0
#define TRUE		!FALSE
#define Y		1
#define N		0
#define ACTIVE		1
#define IDLE		0
#define FILE_FOUND	-2
#define BIN_MAX		300
#define	TRIG_SECS	300		/* wait_trigger() timeout */
#define NO_X_COUNT	100
#define XPOSN		8
#define X_CLOCK		0xF6		/* "X-clock" buffer code */
#define BELL		7
#define NO_CURSOR	0x0E00		/* BIOS/6845 mask for no cursor */

#define SCREENMAX	4096		/* size of screen i/o buffer(s) */
#define FILEMAX		4096		/* size of file i/o buffer */

#define RECV   		0x0001		/* operation modes */
#define SEND   		0x0002
#define VERIFY 		0x0004
#define CONFIRM 	0x0008
#define OVERRIDE	0x0010
#define BINARY  	0x0020
#define TAB_EXPAND	0x0040
#define OVERLAP 	0x0080		/* permit overlapped i/o */
#define FORCE_WAITX	0x0100
#define MENU_MODE	0x0200		/* allows abend() to exit or longjmp */
#define DEBUG   	0x8000

#define DOS_EOF		0x1A		/* DOS/ASCII "EOF" marker */
#define ESCAPE		0x1B		/* keyboard abort characters on PC */
#define CTRL_BREAK	0x00		/*    are ESCape & CTRL-Break      */

#define E_O_F		-1		/* "extended" characters for control */
#define S_O_H		-2		/*    purposes, replaced by graphics */
#define S_T_X		-3		/*    w/ ESC_3 for transmission      */
#define E_T_X		-4
#define E_O_T		-5
#define E_O_R		-6
#define E_R_R		-7
#define FLUSH		-21		/* this has no graphic mate */
#define UNDEF		-22		/*   "   "   "    "      "  */

#define	ESC_1		-1		/* position of ESC's in lead_in[] */
#define	ESC_2		-2		/*    and column id in decode[][] */
#define ESC_3		-3

#define MDT_BIT		1		/* Modified_Data_Tag bit on an attribute */


/* IRMA hardware definitions */

#define REG0		0x0220		/* communication registers */
#define REG1		0x0221
#define REG2		0x0222
#define REG3		0x0223
#define SET_CMND	0x0226
#define CLR_ATTN	0x0227
#define READ_FLAGS	0x0227

#define READ_DATA	0		/* commands */
#define WRITE_DATA	1
#define READ_ASTAT	2
#define CLR_MSTAT	3
#define SEND_KEY	4
#define TRIG_DATA	7
#define TRIG_ADDR	8
#define ATTN_MASK	9
#define TERM_TYPE	12
#define IRMA_REV	14

#define DELTA_AUX 	0x80		/* main status masks */
#define TRIGGERED 	0x40
#define KBUF_EMPTY 	0x20
#define MUNUSED	 	0x10
#define UNIT_RESET 	0x08
#define INT_REQ	 	0x04
#define BUF_MOD	 	0x02
#define CURS_SET	0x01

#define AUNUSED	 	0x80		/* aux. status masks */
#define UNIT_POLLED 	0x40
#define ALARM	 	0x20
#define DISP_INH 	0x10
#define CURS_INH 	0x08
#define REV_CURS 	0x04
#define BLINK_CURSOR 	0x02
#define KYBD_CLICK 	0x01

#define ATTN_FLAG	0x80		/* handshake masks */
#define CMND_FLAG	0x40


/*		        end of DEFINES.H  			*/


#define	CLR		1
#define	NO_CLR	0
