#include "scrninc.h"
#include <stdio.h>
#include "tip.h"
#include "defunc.h"
#include "sfminc.h" 
struct SA_WINDOW *wptr, *stwptr;
struct SA_FIELD *dfptr;
struct SA_IODATA *ioptr;
FILE *fopen(), *fp, *wfp;
char s[41], fn[41], *fndstr(), *index(), *rindex();
int currow=0, curcol=0, winnum, fndflg=0;

main() /* scrnbld - maintain screen structure file - 04/20/84 mhr */
{
    tinit();
    tputc(TO_ESCRL);
    tputc(TO_CS);
    tputc(TO_MC,23,0);
    printf("Enter file name: ");
    stwptr=NULL;
    sbgets(fn);
    if (strlen(fn))
    {
        fp = fopen(fn, "r");
        if (fp != NULL)
        {
            bldtab();
        }
        if (procfl())
        {
            updfil();
        }
        fclose(fp);
    }
    tputc(TO_SSCRL);
    tterm();
    exit();
}

bldtab()
{
    int e, defflg=1;
    char buf[133], typtab[256];
    struct SA_WINDOW *pwptr;
    while (fgets(buf, 133, fp))
    {
        if (strlen(buf)>1 && strncmp(buf, "extern", 6) && buf[0]!='#')
        {
            if (!strncmp(buf, "/*", 2))
            {
                if (index(buf, ':'))
                {
                    setwin(buf);
                    defflg=1;
                }
                else
                if (fndstr(buf, "externals"))
                {
                    defflg=0;
                }
            }
            else
            if (defflg)
            {
                inpdef(buf, typtab);
            }
            else
            if (!strncmp(buf, "struct", 6))
            {
                if (fndstr(buf, "_io") && fndstr(buf, " = {"))
                {
                    inpiod(buf);
                }
                if (fndstr(buf, "SF_FIELD"))
                {
                    inpfld(buf, typtab);
                }
                if (fndstr(buf, "SF_WINDOW"))
                {
                    inpwin(buf);
                }
            }
            else
            {
                msgout("Bad input file");
                tputc(TO_SSCRL);
                tterm();
                exit();
            }
        }
    }
}

procfl()
{

    int testsw=0;
    char cmd, retflg=0;
    while (((cmd=getcmd(testsw)) != 'Q') && cmd !='E')
    {
        if (cmd == 'A')
        {
            addwin();
        }
        if (cmd == 'C')
        {
            chgwin();
        }
        if (cmd == 'D')
        {
            delwin();
        }
        if (cmd == 'F')
        {
            fndwin();
        }
        if (cmd == 'S')
        {
            diswin();
        }
        if (cmd == 'R')
        {
            redwin();
        }
        if (cmd == 'P')
        {
            prtwin();
        }
    }
    if (cmd == 'E')
    {
        retflg=1;
    }
    return(retflg);
}

updfil()
{
    char buf[133];
    strcpy(s, "scrnwrk");
    wfp=fopen(s, "w");
    outban();
    outinc();
    wptr=stwptr;
    while (wptr)
    {
        winnum++;
        strcpy(buf, "/* begin definition and declarations for window: ");
        strcat(buf, wptr->sa_wname);
        strcat(buf, " */\n\n");
        fwrite(buf, strlen(buf), 1, wfp);
        outdat();
        outext();
        outiod();
        outfld();
        outgrp();
        outwin();
        wptr=wptr->sa_wnext;
    }
    delold();
    renwrk();
}

setwin(buf)
char buf[];

{
    wptr=getmem(128);
    *(index(buf+2,'*')-1)=NULL;
    strcpy(wptr->sa_wname, index(buf, ':')+2);
    wptr->sa_wprev=NULL;
    wptr->sa_wnext=NULL;
    wptr->sa_ffld=NULL;
    wptr->sa_fiod=NULL;
}

inpdef(buf, typtab)
char buf[], typtab[];

{
    char *bfldno;
    bfldno=fndstr(buf, "_f")+2;
    *(index(buf, '['))=NULL;
    if (bfldno>0)
    {
        typtab[atoi(bfldno)]=buf[0];
    }
}

inpiod(buf)
char buf[];

{
    struct SA_IODATA *ioptr, *pioptr;
    int endflg=0;
    pioptr=0;
    while (endflg==0)
    {
        ioptr=getmem(128);
        if (!wptr->sa_fiod)
        {
            wptr->sa_fiod=ioptr;
        }
        else
        {
            pioptr->sa_ionext=ioptr;
        }
        ioptr->sa_ionext=NULL;
        ioptr->sa_code = *(index(buf, '\075')-2);
        *(index(buf+7, ' '))=NULL;
        strcpy(ioptr->sa_ioname, buf+7);
        if (!fgets(buf, 133, fp))
            unxend();
        *(index(buf, ','))=NULL;
        strcpy(ioptr->sa_iofunc, buf+4);
        if (!fgets(buf, 133, fp))
            unxend();
        *(index(buf, ',')) = NULL;
        strcpy(ioptr->sa_ioattr, buf+4);
        if (!fgets(buf, 133, fp))
            unxend();
        strcpy(ioptr->sa_ioflgs, buf+4);
        ioptr->sa_ioflgs[strlen(ioptr->sa_ioflgs)-1]=NULL;
        if (!fgets(buf, 133, fp))
            unxend();
        ioptr->sa_iolabl='n';
        pioptr=ioptr;
        if (!fgets(buf, 133, fp))
            unxend;
        if (!fgets(buf, 133, fp))
            unxend();
        if (strlen(buf)<=1)
            endflg=1;
    }
}

inpfld(buf,typtab)
char buf[], typtab[];

{
    int endflg=0, i;
    struct SA_FIELD *fptr, *pfptr;
    fptr=getmem(128);
    dumfld(fptr);
    wptr->sa_ffld=fptr;
    while (!endflg)
    {
        while (strncmp(buf, "    {", 5) && strncmp(buf, "    SF_ENDFLD", 13))
        {
            if (!fgets(buf, 133, fp))
                unxend();
        }
        if (!strncmp(buf, "    {", 5))
        {
            if (!fgets(buf, 133, fp))
                unxend();
            pfptr=fptr;
            fptr=getmem(128);
            pfptr->sa_fnext=fptr;
            pfptr->sa_gnext=fptr;
            fptr->sa_fprev=pfptr;
            fptr->sa_gprev=pfptr;
            fptr->sa_fnext=NULL;
            fptr->sa_gnext=NULL;
            *(rindex(buf, ',')) = NULL;
            fptr->sa_col=atoi(rindex(buf, ',')+1);
            *(rindex(buf, ',')) = NULL;
            fptr->sa_row=atoi(buf+4);
            if (!fgets(buf, 133, fp))
                unxend();
            *(rindex(buf, ',')) = NULL;
            fptr->sa_width=atoi(buf+4);
            if (!fgets(buf, 133, fp))
                unxend();
            *(rindex(buf, ',')) = NULL;
            fptr->sa_iocode = *(buf+strlen(buf)-1);
            if (!fgets(buf, 133, fp))
                unxend();
            if (*(buf+5) == 'w' && fndstr(buf+7, "_f"))
            {
                fptr->sa_ftype=typtab[atoi(index(buf, 'f')+1)];
                for (i=0; i<fptr->sa_width; i++)
                    fptr->sa_data[i]=fptr->sa_iocode;
                fptr->sa_data[++i]=NULL;
                fptr->sa_usernm[0] = NULL;
            }
            else
            if (*(buf+4) == '\042')
            {
                *(rindex(buf, '\042')) = NULL;
                strcpy(fptr->sa_data, buf+5);
                fptr->sa_ftype = 'c';
                fptr->sa_usernm[0] = NULL;
                fndioc(fptr->sa_iocode)->sa_iolabl='y';
            }
            else
            {
                fptr->sa_ftype = NULL;
                strcpy(fptr->sa_usernm, buf+5);
                fptr->sa_usernm[strlen(fptr->sa_usernm)-1]=NULL;
                for (i=0; i<fptr->sa_width; i++)
                    fptr->sa_data[i]=fptr->sa_iocode;
                fptr->sa_data[i++];
            }
        }
        else
        {
            if (!fgets(buf, 133, fp))
                unxend();
            endflg=1;
        }
    }
}
 
inpwin(buf,pwptr)
char buf[];

{
    int i;
    if (!fgets(buf, 133, fp))
        unxend();
    *(rindex(buf, ',')) = NULL;
    wptr->sa_rcol=atoi(rindex(buf, ',')+1);
    *(rindex(buf, ',')) = NULL;
    wptr->sa_lcol=atoi(rindex(buf, ',')+1);
    *(rindex(buf, ',')) = NULL;
    wptr->sa_lrow=atoi(rindex(buf, ',')+1);
    *(rindex(buf, ',')) = NULL;
    wptr->sa_urow=atoi(buf+4);
    if (!fgets(buf, 133, fp))
        unxend();
    *(rindex(buf, ',')) = NULL;  
    strcpy(wptr->sa_wdatr, buf+4);
    for (i=0; i<3; i++)
        if (!fgets(buf, 133, fp))
            unxend();
    if (!stwptr)
    {
        stwptr=wptr;
    }
    else
    {
        pwptr->sa_wnext=wptr;
        wptr->sa_wprev=pwptr;
    }
    wptr->sa_wnext=NULL;
    pwptr=wptr;
}

getcmd(testsw)
int testsw;
{
    char cmd;
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter command code: ");
    sbgets(s);
    cmd = s[0];
    if ((int)cmd>96 && (int)cmd<123)
        cmd=(char)((int)cmd-32);
    if (testsw==1)
    {
        cmd='E';
    }
    return(cmd);
}
 
addwin()
{
    struct SA_FIELD *fptr;
    fptr=getmem(128);
    if (fptr==NULL)
    {
        return(-1);
    }
    dumfld(fptr);
    wptr=getmem(128);
    if (wptr==NULL)
    {
        return(-1);
    }
    asknam();
    strcpy(wptr->sa_wname,s);
    askatt();
    strcpy(wptr->sa_wdatr,s);
    appwin(fptr);
    chgmod();
    return(NULL);
}

chgwin()

{
    if (!fndflg)
    {
        tputc(TO_MC, 23, 0);
        tputc(TO_ERL);
        printf("You must do a find first. ");
        sbgets(s);
        return;
    }
    chgmod();
}

delwin()

{
    if (fndflg)
    {
        if (wptr)
        {
            remiod();
            remfld();
            remwin();
            fndflg=0;
        }
        else
        {
            msgout("There is no window to delete");
        }
    }
    else
    {
        msgout("You must do a find first");
    }
}

fndwin()
{
    asknam();
    if (winsrc(s))
    {
        redwin();
        fndflg=1;
    }
    else
        fndflg=0;
}

diswin()
{
}

redwin()
{
    struct SA_FIELD *fptr;
    fptr=wptr->sa_ffld;
    tputc(TO_CS);
    while (fptr=fptr->sa_fnext)
    {
        tputc(TO_MC, fptr->sa_row, fptr->sa_col);
        tputs(fptr->sa_data);
    }
    tputc(TO_MC, currow, curcol);
}

prtwin()
{
}

getmem(size)
int size;

{
    char *p, c;
    p=malloc(size);
    if (p==NULL)
    {
        tputc(TO_MC,23,0);
        printf("Out of memory - Program aborts");
        c=getchar();
        tputc(TO_MC,23,0);
        tputc(TO_CS);
    }
    return(p);
}

dumfld(fptr)
struct SA_FIELD *fptr;
{
    fptr->sa_row=23;
    fptr->sa_col=0;
    fptr->sa_width=1;
    fptr->sa_iocode='*';
    fptr->sa_data[0]='\0';
    fptr->sa_fprev=NULL;
    fptr->sa_fnext=NULL;
    fptr->sa_gprev=NULL;
    fptr->sa_gnext=NULL;
}

asknam()
 
{
    tputc(TO_MC,23,0);
    tputc(TO_ERL);
    printf("Enter window name: ");
    sbgets(s);
}

askatt()

{
    tputc(TO_MC,23,0);
    tputc(TO_ERL);
    printf("Enter window attributes: ");
    sbgets(s);
}

appwin(fptr)
struct SA_FIELD *fptr;

{
    struct SA_WINDOW *wtptr, *svwptr;
    wptr->sa_urow=0;
    wptr->sa_lrow=22;
    wptr->sa_lcol=0;
    wptr->sa_rcol=79;
    wtptr=stwptr;
    wptr->sa_wprev=NULL;
    wptr->sa_wnext=NULL;
    wptr->sa_ffld=fptr;
    wptr->sa_fiod=NULL;
    if (stwptr!=NULL)
    {
        svwptr=stwptr;
        while ((wtptr=wtptr->sa_wnext) != NULL)
        {
            svwptr=wtptr;
        }
        svwptr->sa_wnext=wptr;
        wptr->sa_wprev=wtptr;
    }
    else
         stwptr=wptr;
}

chgmod()
{
    char c;
    int e, endflg=0;
    unsigned u;
    struct SA_FIELD *fptr;
    tputc(TO_MC,23,0);
    tputc(TO_ERL);
    printf("Start function mode");
    fptr=wptr->sa_ffld;
    tputc(TO_MC,fptr->sa_row, fptr->sa_col);
    currow=fptr->sa_row;
    curcol=fptr->sa_col;
    while (endflg != 1)
    {
        c=tgetc();
        switch((unsigned)c)
        {
            case F_BEGWIN:
                e=begwin();
                break;
            case F_ENDWIN:
                e=endwin();
                redwin();
                break;
            case F_WINRC:
                e=winrc();
                break;
            case F_NXTFLD:
                fptr=nxtfld(fptr);
                break;
            case F_PRVFLD:
                fptr=prvfld(fptr);
                break;
            case F_FLDRC:
                e=fldrc(fptr);
                break;
            case F_NXTGRP:
                fptr=nxtgrp(fptr);
                break;
            case F_PRVGRP:
                fptr=prvgrp(fptr);
                break;
            case F_INSFLD:
                fptr=insfld(fptr);
                break;
            case F_DELFLD:
                fptr=delfld(fptr);
                break;
            case F_UNDFLD:
                fptr=undfld(fptr);
                break;
            case F_ENDFLD:
                msgout("Not a valid function at this time");
                break;
            case F_CHGFLD:
                e=chgfld(fptr);
                break;
            case F_EDTIOC:
                e=edtioc();
                break;
            case F_INSCHR:
                e=inschr(fptr);
                break;
            case F_DELCHR:
                fptr=delchr(fptr);
                break;
            case F_INSLIN:
                e=inslin();
                if (e != -1)
                    redwin();
                break;
            case F_DELLIN:
                e=dellin(fptr);
                if (e != -1)
                {
                    redwin();
                    fptr=e;
                }
                break;
            case F_DUPLIN:
                e=duplin(fptr);
                if (e != -1)
                {
                    redwin();
                }
                break;
            case F_DEFGRP:
                e=defgrp(fptr);
                break;
            case F_ENDFUN:
                endflg=1;
                break;
            case F_CURLOC:
                e=curloc();
                break;
            case TI_MCU:
                e=curcon(TO_MCU);
                if (--currow<0)
                {
                    currow=23;
                }
                break;
            case TI_MCD:
                e=curcon(TO_MCD);
                if (++currow>23)
                {
                    currow=0;
                }
                break;
            case TI_MCR:
                e=curcon(TO_MCR);
                if (++curcol>79)
                {
                    curcol=0;
                }
                break;
            case TI_MCL:
                e=curcon(TO_MCL);
                if (--curcol<0)
                {
                    curcol=79;
                }
                break;
            default:
                msgout("Not a valid function");
        }
    }
}
sfpanic(s)
char s[];

{
    printf("\014Unrecoverable panic - %s",s);
    tputc(TO_SSCRL);
    tterm();
    exit();
}

begwin()

{
    if (valwin(currow, curcol, wptr->sa_lrow, wptr->sa_rcol))
    {
        wptr->sa_urow=currow;
        wptr->sa_lcol=curcol;
    }
    else
    {
        msgout("Function would place field outside window");
    }
    return(NULL);
}

endwin()

{
    if (valwin(wptr->sa_urow, wptr->sa_lcol, currow, curcol))
    {
        wptr->sa_lrow=currow;
        wptr->sa_rcol=curcol;
    }
    else
    {
        msgout("Function would place field outside window");
    }
    return(NULL);
}

winrc()

{
    if (wptr)
    {
        tputc(TO_MC, 23, 0);
        tputc(TO_ERL);
        printf("Window starts at %d %d. ",wptr->sa_urow, wptr->sa_lcol);
        printf("Window ends at %d %d.",wptr->sa_lrow, wptr->sa_rcol);
        tputc(TO_MC, currow, curcol);
    }
    else
        msgout("There is no window");
}

nxtfld(fptr)
struct SA_FIELD *fptr;

{
    if (fptr->sa_fnext)
    {
        fptr=fptr->sa_fnext;
        tputc(TO_MC, fptr->sa_row, fptr->sa_col);
        currow=fptr->sa_row;
        curcol=fptr->sa_col;
    }
    else
        msgout("There is no next field.");
    return(fptr);
}

prvfld(fptr)
struct SA_FIELD *fptr;

{
    if (fptr->sa_fprev)
    {
        fptr=fptr->sa_fprev;
        tputc(TO_MC, fptr->sa_row, fptr->sa_col);
        currow=fptr->sa_row;
        curcol=fptr->sa_col;
    }
    else
        msgout("There is no previous field.");
    return(fptr);
}

fldrc(fptr)
struct SA_FIELD *fptr;

{
    if (fptr)
    {
        tputc(TO_MC, 23, 0);
        tputc(TO_ERL);
        printf("Field is at %d, %d", fptr->sa_row, fptr->sa_col);
        printf(" width %d", fptr->sa_width);
        tputc(TO_MC, currow, curcol);
    }
    else
        msgout("There is no field.");
}

nxtgrp(fptr)
struct SA_FIELD *fptr;

{
    if (fptr->sa_gnext)
    {
        fptr=fptr->sa_gnext;
        tputc(TO_MC, fptr->sa_row, fptr->sa_col);
        currow=fptr->sa_row;
        curcol=fptr->sa_col;
    }
    else
        msgout("No next group");
    return(fptr);
}

prvgrp(fptr)
struct SA_FIELD *fptr;

{
    if (fptr->sa_gprev)
    {
        fptr=fptr->sa_gprev;
        tputc(TO_MC, fptr->sa_row, fptr->sa_col);
        currow=fptr->sa_row;
        curcol=fptr->sa_col;
    }
    else
        msgout("No previous group");
    return(fptr);
}

insfld(fptr)
struct SA_FIELD *fptr;

{
    struct SA_FIELD *newptr;
    int e;
    newptr=fptr;
    if (inwin(1))
    {
        if (infld(1)==NULL)
        {
            newptr=getmem(128);
            newptr->sa_fprev=fptr;
            newptr->sa_fnext=fptr->sa_fnext;
            if (fptr->sa_fnext)
                fptr->sa_fnext->sa_fprev=newptr;
            fptr->sa_fnext=newptr;
            newptr->sa_gprev=fptr->sa_gprev;
            newptr->sa_gnext=fptr->sa_gnext;
            newptr->sa_row=currow;
            newptr->sa_col=curcol;
            newptr->sa_iocode=fldioc(newptr,0);
            fldnam(newptr,0);
            newptr->sa_ftype=fldtyp(newptr,0);
            fldinf(newptr);
        }
        else
            msgout("Field overlay problem");
    }
    else
        msgout("Out of window bounds");
    return(newptr);
}

delfld(fptr)
struct SA_FIELD *fptr;

{
    if (fptr != wptr->sa_ffld)
    {
        if (dfptr)
        {
            free(dfptr);
        }
        dfptr=fptr;
        dfptr->sa_fprev->sa_fnext = dfptr->sa_fnext;
        if (dfptr->sa_fnext)
            dfptr->sa_fnext->sa_fprev = dfptr->sa_fprev;
        rmflgr(dfptr);
        dislin();
        fptr=dfptr->sa_fprev;
        currow=fptr->sa_row;
        curcol=fptr->sa_col;
        tputc(TO_MC, currow, curcol);
    }
    else
        msgout("You cannot do that");
    return(fptr);
}

undfld(fptr)
struct SA_FIELD *fptr;

{
    struct SA_FIELD *newptr;
    int e;
    newptr=fptr;
    if (dfptr)
    {
        if (inwin(dfptr->sa_width))
        {
            if (infld(dfptr->sa_width)==NULL)
            {
                newptr=getmem(128);
                newptr->sa_fprev=fptr;
                newptr->sa_fnext=fptr->sa_fnext;
                fptr->sa_fnext->sa_fprev=newptr;
                fptr->sa_fnext=newptr;
                newptr->sa_gprev=fptr->sa_gprev;
                newptr->sa_gnext=fptr->sa_gnext;
                newptr->sa_row=currow;
                newptr->sa_col=curcol;
                newptr->sa_iocode=dfptr->sa_iocode;
                newptr->sa_usernm[0]=NULL;
                newptr->sa_ftype=dfptr->sa_ftype;
                strcpy(newptr->sa_data, dfptr->sa_data);
                newptr->sa_width=dfptr->sa_width;
                dislin();
                tputc(TO_MC, currow, curcol);
            }
            else
                msgout("Field contention problem.");
        }
        else
            msgout("Field would be outside of window");
    }
    else
        msgout("There is no field to undelete.");
    return(newptr);
}

chgfld(fptr)
struct SA_FIELD *fptr;

{
    char c;
    int endfld=0, e, maxcol;
    struct SA_FIELD *optr;
    optr=fptr;
    if (inwin(1))
    {
        if (infld(1))
        {
            fldnam(fptr,1);
            fptr->sa_ftype=fldtyp(fptr,1);
            while (endfld==0)
            {
                c=tgetc();
                switch ((unsigned)c)
                {
                    case F_INSCHR:
                        e=inschr(fptr);
                        break;
                    case F_DELCHR:
                        fptr=delchr(fptr);
                        if (fptr!=optr)
                            return;
                        break;
                    case TI_MCR:
                        maxcol=fndcmx();
                        if (curcol<=maxcol && curcol<fptr->sa_col+fptr->sa_width)
                        {
                            e=curcon(TO_MCR);
                            curcol++;
                        }
                        else
                            tputc(TO_BELL);
                        break;
                    case TI_MCL:
                        if (curcol>fptr->sa_col)
                        {
                            e=curcon(TO_MCL);
                            curcol--;
                        }
                        else
                            tputc(TO_BELL);
                        break;
                    case F_ENDFLD:
                        endfld=1;
                        break;
                    default:
                        if ((unsigned)c>=32 && (unsigned)c<=126)
                        {
                            maxcol=fndcmx();
                            if (curcol<maxcol)
                            {
                                fndioc(fptr->sa_iocode);
                                if (ioptr->sa_iolabl != 'y' && ioptr->sa_iolabl != 'Y')
                                    c=ioptr->sa_code;
                                if (curcol==fptr->sa_col+fptr->sa_width)
                                {
                                    fptr->sa_data[fptr->sa_width++]=c;
                                }
                                else
                                {
                                    fptr->sa_data[curcol-fptr->sa_col]=c;
                                }
                                putchar(c);
                                curcol++;
                            }
                            else
                                msgout("No more room.");
                        }
                        else
                            msgout("Invalid character.");
                }
            }
        }
        else
            msgout("Cursor is not inside of a field.");
    }
    else
        msgout("Cursor is not inside of a window.");
}

edtioc()

{
    char iocode;
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter iocode (1 char.): ");
    sbgets(s);
    iocode=s[0];
    if ((ioptr=fndioc(iocode)))
    {
        ention(1);
        entior(1);
        entioa(1);
        entiof(1);
    }
    else
        msgout("Iocode not found");
    tputc(TO_MC, currow, curcol);
}

inschr(fptr)
struct SA_FIELD *fptr;

{
    int i;
    if (inwin(1))
    {
        if (!rowful())
        {
            if (fptr=infld(1))
            {
                if (fptr->sa_col != curcol)
                {
                    for (i=fptr->sa_width; i>=curcol-fptr->sa_col; i--)
                    {
                        fptr->sa_data[i+1]=fptr->sa_data[i];
                    }
                    fndioc(fptr->sa_iocode);
                    if (ioptr->sa_iolabl == 'y' || ioptr->sa_iolabl == 'Y')
                        fptr->sa_data[curcol-fptr->sa_col]=' ';
                    else
                        fptr->sa_data[curcol-fptr->sa_col]=ioptr->sa_code;
                    fptr->sa_width++;
                }
            }
            movcol(1);
            dislin();
            tputc(TO_MC, currow, curcol);
        }
        else
            msgout("No more room on row");
    }
    else
        msgout("You are not inside of the window");
}

delchr(fptr)
struct SA_FIELD *fptr;

{
    struct SA_FIELD *dcfptr;
    int i;
    if (inwin(1))
    {
        if (dcfptr=infld(1))
        {
            if (!(--dcfptr->sa_width))
            {
                dcfptr->sa_fprev->sa_fnext=dcfptr->sa_fnext;
                if (dcfptr->sa_fnext)
                    dcfptr->sa_fnext->sa_fprev=dcfptr->sa_fprev;
                rmflgr(dcfptr);
                fptr=dcfptr->sa_fprev;
                msgout("Field is being deleted");
            }
            else
            {
                fptr=dcfptr;
                i=curcol-fptr->sa_col;
                strcpy(fptr->sa_data+i, fptr->sa_data+i+1);
            }
        }
        movcol(-1);
        dislin();
        tputc(TO_MC, currow, curcol);
    }
    else
        msgout("You are not inside of a window.");
    return(fptr);
}

inslin()

{
    struct SA_FIELD *fptr;
    if (inwin(1))
    {
        if (!winful())
        {
            fptr=wptr->sa_ffld;
            while (fptr=fptr->sa_fnext)
            {
                if (fptr->sa_row >= currow)
                {
                    fptr->sa_row++;
                }
            }
        }
        else
        {
            msgout("Window is full.");
            return(-1);
        }
    }
    else
    {
        msgout("You are not inside of a window.");
        return(-1);
    }
    return(0);
}

dellin(fptr)
struct SA_FIELD *fptr;

{
    struct SA_FIELD *nfptr;
    nfptr=fptr;
    if (inwin(1))
    {
        fptr=wptr->sa_ffld;
        while (fptr=fptr->sa_fnext)
        {
            if (fptr->sa_row > currow)
            {
                fptr->sa_row--;
            }
            else if (fptr->sa_row==currow)
            {
                fptr->sa_fprev->sa_fnext=fptr->sa_fnext;
                if (fptr->sa_fnext)
                    fptr->sa_fnext->sa_fprev=fptr->sa_fprev;
                rmflgr(fptr);
            }
        }
        nfptr=wptr->sa_ffld;
    }
    else
    {
        msgout("You must be inside of a window");
        return(-1);
    }
    return(nfptr);
}

duplin(fptr)
struct SA_FIELD *fptr;

{
    struct SA_FIELD *sfptr, *newptr;
    if (!(inslin()))
    {
        sfptr=wptr->sa_ffld;
        while (sfptr=sfptr->sa_fnext)
        {
            if (sfptr->sa_row == currow-1)
            {
                newptr=getmem(128);
                newptr->sa_fprev=fptr;
                newptr->sa_fnext=fptr->sa_fnext;
                if (fptr->sa_fnext)
                    fptr->sa_fnext->sa_fprev=newptr;
                fptr->sa_fnext=newptr;
                newptr->sa_gprev=fptr->sa_gprev;
                newptr->sa_gnext=fptr->sa_gnext;
                newptr->sa_row=currow;
                newptr->sa_col=sfptr->sa_col;
                newptr->sa_iocode=sfptr->sa_iocode;
                newptr->sa_ftype=sfptr->sa_ftype;
                strcpy(newptr->sa_data, sfptr->sa_data);
                newptr->sa_width=sfptr->sa_width;
                fptr=newptr;
            }
        }
    }
    else
        return(-1);
    return(0);
}

defgrp(fptr)
struct SA_FIELD *fptr;

{
    msgout("Define group has not been defined, yet.");
}

curloc()

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Cursor is at %d, %d",currow, curcol);
    tputc(TO_MC, currow, curcol);
}

remiod()

{
    struct SA_IODATA *ioptr;
    ioptr=wptr->sa_fiod;
    while (ioptr)
    {
        free(ioptr);
        ioptr=ioptr->sa_ionext;
    }
}

remfld()

{
    struct SA_FIELD *fptr;
    fptr=wptr->sa_ffld;
    while (fptr)
    {
        free(fptr);
        fptr=fptr->sa_fnext;
    }
}

remwin()

{
    if (stwptr==wptr)
    {
        stwptr=wptr->sa_wnext;
        stwptr->sa_wprev=NULL;
    }
    else
    {
        if (wptr->sa_wprev)
            wptr->sa_wprev->sa_wnext=wptr->sa_wnext;
        if (wptr->sa_wnext)
            wptr->sa_wnext->sa_wprev=wptr->sa_wprev;
    }
    free(wptr);
}
    
fldioc(fptr,chgflg)
int chgflg;
struct SA_FIELD *fptr;

{
    char iocode;
    tputc(TO_MC,23,0);
    tputc(TO_ERL);
    printf("Enter iocode (1 char.): ");
    if (chgflg)
    {
        printf("%s", fptr->sa_iocode);
        tputc(TO_MC, 23, 24);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
    {
        iocode=s[0];
        if (!fndioc(iocode))
        {
            newioc(iocode);
        }
        return(iocode);
    }
    return(fptr->sa_iocode);
}

fldinf(newptr)
struct SA_FIELD *newptr;

{
    int maxcol, endflg=0;
    unsigned uc;
    char c;
    tputc(TO_MC, currow, curcol);
    maxcol=fndcmx();
    newptr->sa_width=0;
    while (endflg == 0 && curcol <= maxcol)
    {
        c=tgetc();
        uc=(unsigned)c;
        if ((uc > 31) && uc < 127 )
        {
            if (ioptr->sa_iolabl != 'y' && ioptr->sa_iolabl != 'Y')
                c=ioptr->sa_code;   
            newptr->sa_data[newptr->sa_width++]=c;
            putchar(c);
            curcol++;
        }
        else if (uc == TI_DEL)
        {
            if (newptr->sa_width!= 0)
            {
                newptr->sa_width--;
                curcol--;
                tputc(TO_MC, currow, curcol);
                putchar(' ');
                tputc(TO_MC, currow, curcol);
            }
            else
                msgout("Field is now zero length");
        }
        else if (uc == F_ENDFLD)
            endflg=1;
        else
            msgout("Key not recognized");
    }
    newptr->sa_data[newptr->sa_width]='\0';
}

fldnam(fptr,chgflg)
struct SA_FIELD *fptr;
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter field name (space for program generated): ");
    if (chgflg)
    {
        printf("%s", fptr->sa_usernm);
        tputc(TO_MC, 23, 48);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
    {
        strcpy(fptr->sa_usernm, s);
        if (strlen(s) == 1 && s[0] == ' ')
                s[0]=NULL;
    }
}

fldtyp(fptr,chgflg)
struct SA_FIELD *fptr;
int chgflg;

{
    int pass=0;
    while (!pass)
    {
        tputc(TO_MC, 23, 0);
        tputc(TO_ERL);
        printf("Enter field type (c, s, i, l, u, f, d): ");
        if (chgflg)
        {
            printf("%s", fptr->sa_ftype);
            tputc(TO_MC, 23, 41);
        }
        sbgets(s);
        if (!index("csilfd", s[0]))
            tputc(TO_BELL);
        else
            pass=1;
    }
    if (!chgflg || (chgflg && strlen(s)))
        return(s[0]);
    return(fptr->sa_ftype);
}

newioc(iocode)
char iocode;

{
    ioptr=getmem(128);
    if (ioptr != NULL)
    {
        ioptr->sa_code=iocode;
        ention(0);
        entior(0);
        entioa(0);
        entiof(0);
        entiol(0);
        ioptr->sa_ionext=NULL;
        iolink();
    }
}

ention(chgflg)
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter structure definition name: ");
    if (chgflg)
    {
        printf("%s",ioptr->sa_ioname);
        tputc(TO_MC, 23, 33);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
        strcpy(ioptr->sa_ioname, s);
}

entior(chgflg)
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter function routine name: ");
    if (chgflg)
    {
        printf("%s",ioptr->sa_iofunc);
        tputc(TO_MC, 23, 29);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
        strcpy(ioptr->sa_iofunc, s);
}

entioa(chgflg)
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter display attribute: ");
    if (chgflg)
    {
        printf("%s",ioptr->sa_ioattr);
        tputc(TO_MC,23, 25);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
        strcpy(ioptr->sa_ioattr, s);
}

entiof(chgflg)
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Enter I/O flags: ");
    if (chgflg)
    {
        printf("%s",ioptr->sa_ioflgs);
        tputc(TO_MC, 23, 17);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
        strcpy(ioptr->sa_ioflgs, s);
}

entiol(chgflg)
int chgflg;

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    printf("Is this for a label field? (y/n): ");
    if (chgflg)
    {
        printf("%s", ioptr->sa_iolabl);
        tputc(TO_MC, 23, 34);
    }
    sbgets(s);
    if (!chgflg || (chgflg && strlen(s)))
        ioptr->sa_iolabl = s[0];
}

iolink()

{
    struct SA_IODATA *newptr;
    newptr=ioptr;
    if (wptr->sa_fiod)
    {
        ioptr=wptr->sa_fiod;
        while (ioptr->sa_ionext)
        {
            ioptr=ioptr->sa_ionext;
        }
        ioptr->sa_ionext=newptr;
    }
    else
        wptr->sa_fiod=newptr;
    ioptr=newptr;
}

winsrc(winnam)
char winnam[];

{
    wptr=stwptr;
    while (strcmp(wptr->sa_wname, winnam) && wptr)
    {
        wptr=wptr->sa_wnext;
    }
    if (wptr)
        return(1);
    return(0);
}

infld(width)
int width;

{
    struct SA_FIELD *fptr;
    int i;
    fptr=wptr->sa_ffld;
    while ((fptr=fptr->sa_fnext) != NULL)
    {
        if (fptr->sa_row == currow)
        {
            for (i=curcol; i<curcol+width; i++)
            {
                if (i >= fptr->sa_col && i <= (fptr->sa_col+fptr->sa_width-1))
                {
                    return(fptr);
                }
            }
        }
    }
    return(NULL);
}

fndcmx()

{
    struct SA_FIELD *fptr;
    int maxcol=wptr->sa_rcol;
    fptr=wptr->sa_ffld;
    while ((fptr=fptr->sa_fnext) != NULL)
    {
        if (fptr->sa_row == currow)
        {
            if (fptr->sa_col > curcol  &&  fptr->sa_col <= maxcol)
            {
                maxcol=fptr->sa_col-1;
            }
        }
    }
    return(maxcol);
}

fndioc(iocode)
char iocode;

{
    ioptr=wptr->sa_fiod;
    while (ioptr)
    {
        if (ioptr->sa_code == iocode)
        {
            return(ioptr);
        }
        ioptr=ioptr->sa_ionext;
    }
    return(NULL);
}

valwin(ur,lc,lr,rc)
int ur, lc, lr, rc;

{
    struct SA_FIELD *fptr;
    int inflg=1;
    fptr=wptr->sa_ffld;
    while (((fptr=fptr->sa_fnext) != NULL) && inflg)
    {
        if (fptr->sa_row < ur)
            inflg=NULL;
        if (fptr->sa_row > lr)
            inflg=NULL;
        if (fptr->sa_col < lc)
            inflg=NULL;
        if (fptr->sa_col+fptr->sa_width-1 > rc)
            inflg=NULL;
    }
    return(inflg);
}

inwin(width)
int width;

{
    int inflg=1;
    if (currow < wptr->sa_urow)
        inflg=NULL;
    if (currow > wptr->sa_lrow)
        inflg=NULL;
    if (curcol < wptr->sa_lcol)
        inflg=NULL;
    if (curcol > wptr->sa_rcol)
        inflg=NULL;
    if (curcol+width-1 > wptr->sa_rcol)
        inflg=NULL;
    return(inflg);
}

rmflgr(tfptr)
struct SA_FIELD *tfptr;

{
    struct SA_FIELD *fptr;
    fptr=wptr->sa_ffld;
    while ((fptr=fptr->sa_fnext) != NULL)
    {
        if (fptr->sa_gprev == tfptr)
        {
            fptr->sa_gprev = tfptr->sa_fprev->sa_gprev;
        }
        if (fptr->sa_gnext == tfptr)
        {
            fptr->sa_gnext =NULL;
            if (tfptr->sa_fnext)
            {
                fptr->sa_gnext = tfptr->sa_fnext->sa_gnext;
            }
        }
    }
}

winful()

{
    struct SA_FIELD *fptr;
    fptr=wptr->sa_ffld;
    while (fptr=fptr->sa_fnext)
    {
        if (fptr->sa_row == wptr->sa_lrow)
            return(1);
    }
    return(NULL);
}

rowful()

{
    struct SA_FIELD *fptr;
    int fulflg=0;
    fptr=wptr->sa_ffld;
    while (((fptr=fptr->sa_fnext)!=NULL) && fulflg==NULL)
    {
        if ((fptr->sa_row == currow) && (fptr->sa_col+fptr->sa_width-1 == wptr->sa_rcol))
        {
            fulflg=1;
        }
    }
    return(fulflg);
}

movcol(n)
int n;

{
    struct SA_FIELD *fptr;
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    tputc(TO_MC ,currow, curcol);
    fptr=wptr->sa_ffld;
    while ((fptr=fptr->sa_fnext) != NULL)
    {
        if (fptr->sa_row == currow)
        {
            if (((fptr->sa_col >= curcol) && (n > 0)) || (fptr->sa_col > curcol))
            {
                fptr->sa_col=fptr->sa_col+n;
            }
        }
    }
}

dislin()

{
    struct SA_FIELD *fptr;
    tputc(TO_MC, currow, 0);
    tputc(TO_ERL);
    fptr=wptr->sa_ffld;
    while ((fptr = fptr->sa_fnext) != NULL)
    {
        if (fptr->sa_row == currow)
        {
            tputc(TO_MC, fptr->sa_row, fptr->sa_col);
            tputs(fptr->sa_data);
        }
    }
}

errmsg(msg)
char msg[41];

{
}

curcon(toecho)
unsigned toecho;
 
{
    char c;
    c=(char)toecho;
    tputc((int)toecho);
}

outban()

{
    char buf[133];
    int i;
    strcpy(buf, "/* ");
    strcat(buf, fn);
    strcat(buf, " - include file for windows */\n");
    fwrite(buf, strlen(buf), 1, wfp);
    strcpy(buf, "\n");
    fwrite(buf, strlen(buf), 1, wfp);
}

outdat()

{
    struct SA_FIELD *fptr;
    char buf[133], *typdes();
    int fldnum=0, i;
    strcpy(buf, "/* begin definitions of data areas */\n\n");
    fwrite(buf, strlen(buf), 1, wfp);
    fptr=wptr->sa_ffld;
    while (fptr=fptr->sa_fnext)
    {
        fndioc(fptr->sa_iocode);
        if (ioptr->sa_iolabl != 'y' && ioptr->sa_iolabl != 'Y' && !strlen(fptr->sa_usernm))
        {
            printf("#10: %s %s %c\n", fptr->sa_data, fptr->sa_usernm, fptr->sa_ftype);
            strcpy(buf, typdes(fptr->sa_ftype));
            strcat(buf, " w");
            itoa(winnum, buf+strlen(buf));
            strcat(buf, "_f");
            itoa(++fldnum, buf+strlen(buf));
            if (fptr->sa_ftype=='c')
            {
                strcat(buf, "[");
                itoa(fptr->sa_width, buf+strlen(buf));
                strcat(buf, "]");
            }
            strcat(buf, " = ");
            if (fptr->sa_ftype == 'c')
            {
                strcat(buf, "\042\042");
            }
            strcat(buf, ";\n");
            fwrite(buf, strlen(buf), 1, wfp);
        }
    }
    fwrite("\n", 1, 1, wfp);
}

outinc()

{
    char buf[133];
    strcpy(buf, SFMINC); 
    fwrite(buf, strlen(buf), 1, wfp);
    fwrite("\n\n", 2, 1, wfp);
}

outext()

{
    int i;
    char buf[133];
    strcpy(buf, "/* begin declarations of externals */\n\n");
    fwrite(buf, strlen(buf), 1, wfp);
    ioptr=wptr->sa_fiod;
    while (ioptr)
    {
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "extern ");
        strcat(buf, ioptr->sa_iofunc);
        strcat(buf, ";\n");
        fwrite(buf, strlen(buf), 1, wfp);
        ioptr=ioptr->sa_ionext;
    }
    fwrite("\n\n", 2, 1, wfp);
}

outiod()

{
    int i;
    char buf[133];
    strcpy(buf, "/* begin declarations of iodata structures */\n");
    fwrite(buf, strlen(buf), 1, wfp);
    ioptr=wptr->sa_fiod;
    while (ioptr)
    {
        fwrite("\n", 1, 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "struct ");
        strcat(buf, ioptr->sa_ioname);
        strcat(buf, " w");
        itoa(winnum, buf+strlen(buf));
        strcat(buf,"_io");
        buf[strlen(buf)]=ioptr->sa_code;
        strcat(buf," = {\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    ");
        strcat(buf, ioptr->sa_iofunc);
        strcat(buf, ",\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    ");
        strcat(buf, ioptr->sa_ioattr);
        strcat(buf, ",\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    ");
        strcat(buf, ioptr->sa_ioflgs);
        strcat(buf, "\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "};\n");
        fwrite(buf, strlen(buf), 1, wfp);
        ioptr=ioptr->sa_ionext;
    }
    fwrite("\n\n", 2, 1, wfp);
}

outfld()

{
    struct SA_FIELD *fptr;
    char buf[133];
    int i, fldnum=0;
    strcpy(buf, "/* begin declarations of field structures */\n\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf,"struct SF_FIELD fldlst");
    itoa(winnum, buf+strlen(buf));
    strcat(buf,"[] = {\n");
    fwrite(buf, strlen(buf), 1, wfp);
    fptr=wptr->sa_ffld;
    while (fptr=fptr->sa_fnext)
    {
        fwrite("\n", 1, 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    {\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    ");
        itoa(fptr->sa_row, buf+strlen(buf));
        strcat(buf, ",");
        itoa(fptr->sa_col, buf+strlen(buf));
        strcat(buf, ",\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    ");
        itoa(fptr->sa_width, buf+strlen(buf));
        strcat(buf, ",\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    &");
        strcat(buf, "w");
        itoa(winnum, buf+strlen(buf));
        strcat(buf, "_io");
        buf[strlen(buf)]=fptr->sa_iocode;
        strcat(buf, ",\n");
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        fndioc(fptr->sa_iocode);
        if (ioptr->sa_iolabl == 'y' || ioptr->sa_iolabl == 'Y')
        {
            strcpy(buf, "    \042");
            strcat(buf, fptr->sa_data);
            strcat(buf, "\042\n");
        }
        else
        {
            strcpy(buf, "    &");
            if (strlen(fptr->sa_usernm))
            {
                strcat(buf, fptr->sa_usernm);
            }
            else
            {
                strcat(buf, "w");
                itoa(winnum, buf+strlen(buf));
                strcat(buf, "_f");
                itoa(++fldnum, buf+strlen(buf));
            }
            strcat(buf, "\n");
        }
        fwrite(buf, strlen(buf), 1, wfp);
        for (i=0; i<133; i++)
            buf[i]=NULL;
        strcpy(buf, "    },\n");
        fwrite(buf, strlen(buf), 1, wfp);
    }
    strcpy(buf, "\n    SF_ENDFLD\n");
    fwrite(buf, strlen(buf), 1, wfp);
    strcpy(buf, "};\n\n\n");
    fwrite(buf, strlen(buf), 1, wfp);
}

outgrp()

{
}

outwin()

{
    char buf[133];
    int i;
    strcpy(buf, "/* begin declarations of the window structure */\n\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy (buf, "struct SF_WINDOW ");
    strcat(buf, wptr->sa_wname);
    strcat(buf, " = {\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf, "    ");
    itoa(wptr->sa_urow, buf+strlen(buf));
    strcat(buf, ",");
    itoa(wptr->sa_lrow, buf+strlen(buf));
    strcat(buf, ",");
    itoa(wptr->sa_lcol, buf+strlen(buf));
    strcat(buf, ",");
    itoa(wptr->sa_rcol, buf+strlen(buf));
    strcat(buf, ",\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf, "    ");
    strcat(buf, wptr->sa_wdatr);
    strcat(buf, ",\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf, "    SF_NULL,\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf, "    &fldlst");
    itoa(winnum, buf+strlen(buf));
    strcat(buf, "\n");
    fwrite(buf, strlen(buf), 1, wfp);
    for (i=0; i<133; i++)
        buf[i]=NULL;
    strcpy(buf, "    };\n");
    fwrite(buf, strlen(buf), 1, wfp);
    fwrite("\n\n\n", 3, 1, wfp);
}

delold()

{
    printf("#1: %s\n", fn);
    fclose(fp);
    unlink(fn);
}

renwrk()

{
    fclose(wfp);
    link("scrnwrk", fn);
    unlink("scrnwrk");
}

char *typdes(t)
char t;

{
    char typspc[45];
    char *pspec;
    int i;
    strcpy(typspc, ">char>short>int>long>unsigned>float>double>");
    pspec = typspc;
    printf("#2: %s %c\n", fn, t);
    for (i=0; i<40; i++)
        s[i]=NULL;
    while (pspec=index(pspec,'>'))
    {
        if (*(++pspec) == t)
        {
            strncpy(s,pspec,index(pspec, '>')-pspec);
            printf("#3: %s\n", fn);
            return(s);
        }
    }
    printf("#4: %s\n", fn);
    return(NULL);
}

char *fndstr(s1, s2)
char s1[], s2[];

{
    int i;
    for (i=0; i<strlen(s1)-strlen(s2) && s1[i]; i++)
        if (!strncmp(s1+i, s2, strlen(s2)))
            return(s1+i);
    return(0);
}

sbgets(strg)
char strg[];

{
    tterm();
    gets(strg);
    tinit();
}

mssext()

{
    msgout("Unexpected data found in file");
    tputc(TO_SSCRL);
    tterm();
    exit();
}

unxend()

{
    msgout("Unexpected end of file");
    tputc(TO_SSCRL);
    tterm();
    exit();
}

msgout(msg)
char msg[];

{
    tputc(TO_MC, 23, 0);
    tputc(TO_ERL);
    tputs(msg);
    tputc(TO_BELL);
    tputc(TO_MC, currow, curcol);
}

itoa(n, s1)
char s1[];
int n;
{
    int i, sign;
    if ((sign = n) < 0)
        n = -n;
    i = 0;
    do
    {
        s1[i++] = n%10+'0';
    }
    while ((n /= 10) >0);
    if (sign < 0)
        s1[i++] = '-';
    s1[i] = '\0';
    reverse(s1);
}

reverse(s1)
char s1[];

{
    int c, i, j;
    for (i = 0, j = strlen(s1)-1; i < j; i++, j--)
    {
        c = s1[i];
        s1[i] = s1[j];
        s1[j] = c;
    }
}
