/*                                                           */
/*       Copyright 1983 Technical Analysis Corporation       */
/*                                                           */

#define MAXDEPTH 10			/* link depth limit */

extern int errno;

main(argc, argv)
int argc;
char *argv[];
{
   int  verify;
   char linknam[133], reslnam[133];

   verify = chkcmnd(argc, argv, linknam);

   if (argc < 2 || argc > 3 || linknam[0] == '\0') {
      printf("Usage: path [-v] link-name\n");
      exit(-1);
   }

   switch (resolve(linknam, reslnam, verify)) {
      case 0:
	 if (verify == 0)
	    printf("%s\n", reslnam);
	 break;
      case 1:
	 printf("Not a link entry: %s\n", linknam); break;
      case 2:
	 printf("Link depth exceeded: %s\n", linknam); break;
      default:
	 printf("Path: unknown error\n");
   }

} /* end-main */

resolve(linknam, reslnam, verify)
char *linknam, *reslnam;
int  verify;
{
   int i, n, fd, depth;
   char tmp[133];

   strcpy(reslnam, linknam);

   for (depth = MAXDEPTH; depth > 0; depth--) {
      strcpy(tmp, reslnam);
      strcat(tmp, ".lk");
      if ((fd = open(tmp, 0)) < 0)
	 return((depth == MAXDEPTH) ? 1 : 0);
      if ((n = read(fd, reslnam, 133)) <= 0)
	 return((depth == MAXDEPTH) ? 1 : 0);
      for (i =0; i < n; i++)
	 if (reslnam[i] == '\n' || reslnam[i] == '\r' ||
	                           reslnam[i] == '\f' ||
			           reslnam[i] == '\0') {
	     reslnam[i] = '\0';
	     break;
	 }
      close(fd);
      if (verify != 0)
	 printf("%s\n", reslnam);
   }

   return(2);

} /* end-resolve */

chkcmnd(argc, argv, linknam) 
int  argc;
char *argv[], *linknam;
{
   int i, j, v;

   linknam[0] = '\0';

   for (v = 0, i = 1; i < argc; i++)
      if (argv[i][0] == '-') {
         for(j = 1; argv[i][j] != '\0'; j++)
            if (argv[i][j] == 'v')
               v = 1;
      } else
	 strcpy(linknam, argv[i]);

   return(v);

} /* end-chkcmnd */
