/*************************************************************************
*
*
*	Name:  bbplb.c
*
*	Description:  Makes a program library file
*
*
*	History:
*	Date		By	Comments
*
*	05/26/83	WEB
*	06/08/83	WEB	added scan for '.bp' extension
*	06/10/83	WEB	removed requirement for line-number table
*	06/16/83	mas	changed to leave a sector for the header
*				so that the buckets start on even sector
*				boundary
*	07/06/83	mas	changed to put pcode on sector boundary
*	07/12/83	mas	changed to compute hash frame using unsigned 
*				instead of characters
*	07/14/83	mas	changed listinh option to verify the p-code
*				header
*				also added an update switch to delete and then
*				add then program 
*	11/21/83	waf		Changes due to new multiple 'magic' values
*					('normal' pgms and 'overlay' pgms).
*	04/10/84	waf		Fixed truncation during calc of bucket number.
*						Fixed chksum calc bug.
*						Fixed bug that caused crash when pgm name
*					was 10 chars long.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Utility Module */




/*  Notes -

*/


#include <stdio.h>
#include "/bb/include/ptype.h"

#define BUCKCNT 	32  	/* entries per bucket */
#define BUCKSTART 	512L	/* start of buckets */
#define HASHMAX 	1000
#define PLMAGIC 	NORMPGM	/* 'magic' value for 'normal' bb pgms */
#define INTERACTIVE 1		/* usage modes */
#define SCRIPT 		0
#define	MAXPGMC		10		/* max # chars in a program root name */

extern long lseek();
extern errno;

int	 plfd, mode;
long	 plpos, progpos;
char	 plbname[133], plname[133];
unsigned addsw, cresw, delsw, listsw, linksw, cksum, updatsw;
PLHEADER plh;
PLENT	 plbuck[BUCKCNT];

main(argc, argv)
int	argc;
char	*argv[];
{
	int i, j, k, arglen, linkentry;
	char buf[512], tmp[133], *infil, *fopen();

	setup(argc, argv);

	if (mode == INTERACTIVE) {
		printf("Program library name: ");
		gets(plname);
		if (getpch() != 0) {
			printf("Frame size: ");
			gets(tmp);
			sscanf(tmp, "%u", &plh.hashfram);
			create();
			if (getpch() != 0)
				abend("can't open", plname);
			} 
		else
			printf("Frame size = %d\n", plh.hashfram);
		printf("Input file name [TTY]: ");
		gets(tmp);
		if (tmp[0] == '\0')
			infil = stdin;
		else if ((infil = fopen(tmp, "r")) == NULL)
			abend("can't open", tmp);
		while (getln(infil, buf) != 0) {
			arglen = strlen(buf);
			linkentry = FALSE;
			for (j = 0; j < arglen; ) {
				for (k = 0; j < arglen && buf[j] != ','; j++, k++)
					tmp[k] = buf[j];
				tmp[k] = '\0';
				modify(tmp, linkentry);
				linkentry = TRUE;
				j++;
				}
			} /* end-while */
		exit(0);
		}

	if (cresw == TRUE) {
		sscanf(argv[3], "%d", &plh.hashfram);
		create();
		exit(0);
		}

	if (getpch() != 0)
		abend("can't open", plname);

	if (listsw == TRUE) {
		list();
		exit(0);
		}

	if (addsw == TRUE || delsw == TRUE || updatsw == TRUE) {
		for (i = 3; i < argc; i++) {
			linksw = FALSE;
			linkentry = FALSE;
			arglen = strlen(argv[i]);
			for (j = 0; j < arglen; j++)
				linksw = (argv[i][j] == ',') ? TRUE : FALSE;
			if (linksw == TRUE && delsw == TRUE)
				abend("links not valid on delete", "");
			for (j = 0; j < arglen; ) {
				for (k = 0; j < arglen && argv[i][j] != ','; j++, k++)
					tmp[k] = argv[i][j];
				tmp[k] = '\0';
				modify(tmp, linkentry);
				linkentry = TRUE;
				j++;
				}
			}
		exit(0);
		}

	} /* end-main */



getln(infil, buf)
char *infil, buf[];
{
	int n;

	if (infil == stdin)
		printf(">> ");

	if (fgets(buf, 132, infil) == NULL) {
		buf[0] = '\0';
		if (infil == stdin)
			printf("\n");
		return(0);
		} 
	else {
		n = strlen(buf) - 1;
		if (buf[n] == '\n')
			buf[n] = '\0';
		return(1);
		}

	} /* end-getln */

create()
{
	int i;
	long l;

	if (plh.hashfram == 0 || plh.hashfram > HASHMAX)
		abend("invalid hash frame size", "");

	if ((plfd = creat(plname, 0644)) < 0)
		abend("can't create", plname);

	plh.entrycnt = BUCKCNT;
	plh.plmagic = PLMAGIC;
	swab((char *) &plh, (char *) &plh, sizeof(PLHEADER));

	if (write(plfd, &plh, sizeof(PLHEADER)) < 0)
		abend("can't write header", "");

	swab((char *) &plh, (char *) &plh, sizeof(PLHEADER));

	plpos = lseek(plfd, BUCKSTART, 0); 		/* set start of buckets */

	for (i = 0; i < BUCKCNT; i++) {
		plbuck[i].plname[0] = '\0';
		plbuck[i].plloc = 0;
		}

	for (i = 0; i < plh.hashfram; i++)
		if (write(plfd, plbuck, sizeof(plbuck)) < 0)
			abend("can't write bucket", "");

	close(plfd);

	} /* end-create */

modify(progname, linkentry)				/* add & delete */
char	progname[];
int	linkentry;
{
	int i, j;
	long l;
	char temp[133] ;
#	define	HBSIZE	MAXPGMC+1	/* pgm name + trailing null */
	char hbuf[HBSIZE] ;		/* buf for chksum calc of pgm name */
	unsigned cksum;

	bpscan(progname);
	strcpy(temp, progname);			/* build program name */
	strcat(temp, ".bp");

	if (strlen(progname) > MAXPGMC) {
		printf("%s: name too long\n", progname);
		return;
		}

	/* Get chksum from pgm name */
	for (i=0; i<HBSIZE; ++i)
		hbuf[i] = '\0';		/* null fill 'hex buf' */
	strcpy(hbuf,progname);
	swab(hbuf, hbuf, MAXPGMC);	/* fix for number format */
	for (i=0, cksum=0; i<MAXPGMC; i += 2)
		cksum += *((unsigned *)&hbuf[i]);

	cksum %= plh.hashfram; 			/* mod w/ number of buckets */

	/* l = plpos + (long)(cksum * sizeof(plbuck));	<<< 4/10/84 */
	l = (long) cksum * (long) sizeof(plbuck) ;
	l += plpos ;

	lseek(plfd, l, 0);				/* seek to bucket */

	if (read(plfd, plbuck, sizeof(plbuck)) < sizeof(plbuck))
		abend("can't read bucket", "");

	for (i = 0; i < plh.entrycnt; i++) {
		if (strcmp(progname, plbuck[i].plname) == 0) {
			if (addsw == TRUE)
				abend("already added", progname);
			if (delsw == TRUE || updatsw == TRUE) {
				plbuck[i].plname[0] = '\0';
				if (plbuck[i].pllink[0] != 'L') {
					swab(&plbuck[i].plloc, &progpos, sizeof(long));
					nullfill(progpos);
					}
				printf("%s: deleted\n", progname);
				lseek(plfd, l, 0);
				j = write(plfd, plbuck, sizeof(plbuck));
				if (j != sizeof(plbuck))
					abend("can't write header", "");
				if (delsw == TRUE)
					return;
				else
					break;
				}
			}
		}

	if (delsw == TRUE) {
		printf("%s: not found\n", progname);
		return;
		}

	for (i = 0; i < plh.entrycnt; i++) {
		if (plbuck[i].plname[0] == '\0') {
			if (linkentry == FALSE) {
				progpos = lseek(plfd, 0L, 2);
				progpos += 511;		/* round to next sector */
				progpos &= ~0x1ff;
				lseek(plfd, progpos, 0);	/* seek there */
				addprog(temp);
				}
			swab(&progpos, &plbuck[i].plloc, sizeof(long));
			strcpy(plbuck[i].plname, progname);
			if (linkentry == TRUE)
				plbuck[i].pllink[0] = 'L';
			else
				plbuck[i].pllink[0] = '\0';
			lseek(plfd, l, 0);
			j = write(plfd, plbuck, sizeof(plbuck));
			if (j != sizeof(plbuck))
				abend("can't write header", "");
			if (linkentry == FALSE)
				printf("program added: %s\n", progname);
			else
				printf("link added: %s\n", progname);
			return;
			}
		}

	abend("no room", progname);

	} /* end-modify */

list()
{
	int i, j, n, y,k;
	long l,m;
	struct phead pch;
	unsigned *uptr,x;

	n = 0;

	l = lseek(plfd,0L,1); /* get current position */

	do {
		lseek(plfd,l,0);	/* seek to current position */
		if (read(plfd, plbuck, sizeof(plbuck)) < sizeof(plbuck)) {
			printf("%s: read error\n", plbname);
			return;
			}
		l = lseek(plfd,0L,1); /* save current position */
		for (j = 1, i = 0; i < plh.entrycnt; i++, j++) {
			if (plbuck[i].plname[0] == '\0')
				continue;
			if (plbuck[i].pllink[0] == 'L')
				printf("a");
			else
				printf(" ");
			printf("%d/%d: %s", n+1, j, plbuck[i].plname);
			swab((char *)&plbuck[i].plloc,(char *)&m,sizeof(long));
			lseek(plfd,m,0);	/* look at pcode header */
			if (read(plfd,(char *)&pch,sizeof(pch)) < sizeof(pch)) {
				printf(" ERROR - Can't read p-code header!\n");
				continue;
				}
			if (pch.magic == 0 && plbuck[i].pllink[0] == 'L') {
				printf(" ERROR - Original program deleted\n");
				continue;
				}
			if ( pch.magic != NORMPGM && pch.magic != OVLYPGM ) {
				printf(" ERROR - Magic number = 0x%04x\n",pch.magic);
				continue;
				}
			if (pch.codsiz == 0) {
				printf(" ERROR - No code in p-code file!\n");
				continue;
				}
			for (y=0,uptr=(unsigned *)&pch,x=0;
				y < sizeof(pch)/sizeof(unsigned); ++y)
				    x += *uptr++;
			if (x != 0) {
				printf(" ERROR - P-code header does not checksum!\n");
				continue;
				}
			printf("\n");
			}
		n++;
		} 
	while (n < plh.hashfram);

	} /* end-list */


getpch()
{
	if ((plfd = open(plname, 2)) < 0) 		/* open for read/write */
		return(-1);

	if (read(plfd, &plh, sizeof(PLHEADER)) < sizeof(PLHEADER))
		abend("can't read program library header", "");

	swab((char *) &plh, (char *) &plh, sizeof(PLHEADER));

	plpos = lseek(plfd, BUCKSTART, 0);		/* set start of buckets */

	return(0);

	} /* end-getpch */

addprog(name)
char   *name;
{
	int fdin, i;
	unsigned cksum;
	long	l;
	struct phead pcheader;

	if ((fdin = open(name, 0)) < 0)
		abend("can't open", name);

	if (read(fdin, (char *) &pcheader, sizeof(pcheader)) != sizeof(pcheader))
		ioerr(errno);

	if (pcheader.magic != NORMPGM && pcheader.magic != OVLYPGM )
		abend("not a bb program", name);

	cksum = getchksum(&pcheader) ;
	if (cksum != pcheader.chksum)
		abend("chksum error", name);

	if (pcheader.codsiz == 0)
		abend("no pgm code!", name);

	if (pcheader.ustsiz != 0) {
		pcheader.ustsiz = 0;
		/* compute new checksum */
		pcheader.chksum = getchksum(&pcheader) ;
		}

	l = lseek(plfd, 0L, 1); /* save current position in prog lib*/
	if (write(plfd,(char *)&pcheader,sizeof(pcheader)) < sizeof(pcheader))
		abend("can't add program to library: ",plname);

	lseek(plfd, l + 512L, 0); /* position to code area in prog lib*/

	lseek(fdin, 512L, 0);

	pcopy(fdin, pcheader.codsiz);

	if (pcheader.ltabsiz != 0 && pcheader.noltab == FALSE)
		pcopy(fdin, pcheader.ltabsiz);

	if (pcheader.stksiz != 0)
		pcopy(fdin, pcheader.stksiz);

	close(fdin);

	} /* end-addprog */



static	getchksum ( hdptr )

struct phead *hdptr ;

/* Compute header chksum. */

{
	register unsigned *uptr ;
	register int	csum ;


	csum = 0 ;
	for ( uptr = hdptr ; uptr < &(hdptr->chksum) ; )
		csum -= *uptr++ ;

	return(csum);
	}

nullfill(loc)
long   loc;
{
	int   i;
	unsigned x, n,total;
	struct phead phd;
	char   nullblk[512];

	for (i=0; i < 512; i++)
		nullblk[i] = '\0';

	lseek(plfd, loc, 0);   		/* seek to pcode header */

	if ((n = read(plfd, (char *) &phd, sizeof(phd))) < sizeof(phd))
		abend("can't read pcode header", "");

	lseek(plfd, loc, 0);

	if (write(plfd, nullblk, 512) < 512)
		abend("can't overwrite pcode header", "");

	total = phd.codsiz + phd.stksiz;
	if (phd.noltab == FALSE)
		total += phd.ltabsiz;

	for (x = total; x > 0; x -= n) {
		n = (x > 512) ? 512 : x;
		if (write(plfd, nullblk, n) < n)
			abend("can't overwrite pcode", "");
		}

	} /* end-nullfill */


bpscan(name)
char   *name;
{
	register int   i;
	register char   *cptr;

	spscan(name);

	i = strlen(name);   			/* set i to null at end of string */

	if (i == 0)
		return;

	cptr = &name[--i];   		/* point to last character */

	for (; *cptr != '.' && cptr > name; cptr--)
		;      				/* scan back to period */

	if (cptr == name)
		return;

	if (strcmp(cptr,".bp") == 0)
		*cptr = '\0';   			/* null terminate at period */

	return;
	}


spscan(name)
char   *name;
{
	register int   i;
	register char   *cptr;

	i = strlen(name);   			/* set i to null at end of string */

	if (i == 0)
		return;

	cptr = &name[--i];   		/* point to last character */

	for (; *cptr <= ' ' && cptr > name; cptr--)
		;      				/* scan back past junk */

	*(++cptr) = '\0';   			/* null terminate */

	return;
	}


pcopy(fd, length)
int   fd;
unsigned length;
{
	register int i;
	char buf[8192];

	while (length != 0) {
		i = (length > 8192) ? 8192 : (int) length; 
		if (read(fd, buf, i) != i)
			ioerr(errno);
		if (write(plfd, buf, i) != i)
			ioerr(errno);
		length -= (unsigned) i;
		}

	} /* end-pcopy */

ioerr(ercod)
int ercod;
{
	printf(":s: i/o error number %d\n", ercod);
	exit(-1);
	} /* end-ioerr */


abend(msg, name)
char *msg, *name;
{
	printf("%s: %s", plbname, msg);
	if (*name != '\0')
		printf(" %s", name);
	printf("\n");
	exit(-1);
	} /* end-abend */

setup(argc, argv)
int	argc;
char	*argv[];
{
	int i, swcount;
	char c;

	strcpy(plbname, argv[0]);
	addsw = delsw = cresw = listsw = updatsw = FALSE;

	if (argc == 2 && strcmp(argv[1], "-i") == 0) {
		mode = INTERACTIVE;
		addsw = TRUE;
		return;
		}

	strcpy(plname, argv[1]);
	mode = SCRIPT;
	swcount = 0;

	if (argc >= 3 && argv[2][0] == '-')
		for (i = 1; (c = argv[2][i]) != '\0'; i++) 
			switch (c) {

			case 'a' :
			case 'A': 
				addsw = TRUE;
				swcount++;
				break;

			case 'd' :
			case 'D': 
				delsw = TRUE;
				swcount++;
				break;

			case 'c' :
			case 'C': 
				cresw = TRUE;
				swcount++;
				break;

			case 'l' :
			case 'L': 
				listsw = TRUE;
				swcount++;
				break;

			case 'u' :
			case 'U': 
				updatsw = TRUE;
				swcount++;
				break;

			default:
				abend("unknown switch", "");

				} /* end-switch */

	if (swcount == 1)
		return;

	printf("Usage: %s proglib -[adu] file [file ...] (to add,delete, or update programs)\n", plbname);
	printf("    or %s proglib -c hashframe           (to create a program library)\n", plbname);
	printf("    or %s proglib -l                     (to list entries in the library)\n", plbname);
	printf("    or %s -i                             (to use interactive mode)\n", plbname);
	exit(-1);

	} /* end-setup */

