:! SFORM - Screen Input/Output routines
:#
: This package of subroutines provides unformated handling of the DG 6053
: CRT.  It includes routines to display a screen, input
: a function, and input and output fields using screens created by CSM.
:
: Most routines require a field specification which may be provided
: in three ways.  R may be set to the line number on the screen
: and F to the field within the line (as defined by the CSM program).
: Or, F may be set to the line number times 100 plus the field
: within the line (R is not needed at all).  Or, F may be set to minus
: the field number (1 to n) on the screen.
:
:$ All the routines use the following scratch and permanant variables:
:     LINE$[80] = scratch string
:     SPACES$[80] = string of space characters
:     SCRN$[72+3*number of fields] = descibes each field (set by CSM)
:     X$[80] = input/output variable for string fields
:     X = input/output variable used for numeric fields
:     XROW = line number that the current field is on
:     XCOL = column number of the current field
:     XWID = width of the current field
:     XDEC = number of digits past the decimal point.
:     XFLGS = bit flags describing the field as follows:
:       BIT     MEANING
:       128     one if it is a numeric field, else it is a string
:        64     one if the field is a protected field
:        32     one if the field is to be left justified
:        16     one if a numeric field may have a variable number of decimals
:               on input
:               one if a string field may have lower case on input
:         8     one if a numeric field may be negative on input
:       4,2,1   XDEC if field is numeric
:
:     X10  = non-zero if function key terminated input, else 0
:     XLEN = Length of input data (before TRUN$)
:     Y% = scratch variable
:     Z% = scratch variable
:     E = error number 
:     FUNC = function number
:
: See also the routines in SCRNIO.SL and FORMIO.SL.
::

:! CLEARFORM - CLEAR ALL UNPROTECTED FIELDS.
:#
:     CLEARFORM clears all unprotected fields on the screen.
:> CALLING SEQUENCE
:     GOSUB 9100
::
9100 REM \ CLEARFORM
9105 LET F=-1
9110 STMA 21,SCRN$,F,XROW,Y%,XCOL,XWID,XFLGS
9115 IF Y%<0 THEN RETURN 
9120 IF AND(XFLGS,64)=0 THEN PRINT @(XROW,XCOL);SPACES$[1,XWID];
9125 LET F=F-1
9130 GOTO 9110
9135 RETURN 
:
:! INITFORM - Initialize the program and the terminal for screen I/O 
:#
:     INITFORM sets the necessary STMA's for screen I/O.
:> CALLING SEQUENCE
:     GOSUB 9150
::
9150 REM \ INITFORM
9152 UNPACK "UUUUUUUUU","<0>",X,XSHFT,Y%,Z%,R,XCOL,XWID,XFLGS
9153 LET SPACES$=FILL$(32)
9155 STMA 6,1
9160 STMA 6,3
9165 PRINT @(-1,255);@(-5,30);@(-54);
9170 RETURN 
:
:! ENDFORM - End screen I/O mode
:#
:     This routine reset the STMA's which were set above and clears the screen.
:> CALLING SEQUENCE
:     GOSUB 9175
::
9175 REM \ ENDFORM
9180 STMA 7,1
9185 STMA 7,3
9190 PRINT @(-19);@(-56);@(-30)
9195 RETURN 
:
:! READFORM - Input field F to X$ or X from a formated screen
:#
:     Readform inputs the field (F) to X$ if a string field, or to
:     X if a numeric field.  Numeric fields are converted according to
:     specifications in the screen file.
:     E is returned as zero if the input conversion was successful.
:     E is returned as 128 if the input conversion was in error.
:     String input will be converted to upper case
:     if the specification indicates.
:> CALLING SEQUENCE
:     F   - Field number (See SFORM)
:     R   - Row number (Optional - See SFORM)
:     GOSUB 9300
:     X$  - Field from screen
:     X   - Value of field if numeric
:     E   - Error code 
:           0   - OK
:           128 - INVALID INPUT
:     XLEN - Number of characters input (before TRUN$)
:     FUNC - Function key or 0 if carrige return
:$ STORAGE USED
:     (SEE SFORM)
:     Y%  - scratch variable
:     Z%  - scratch variable
:& EXTERNAL ROUTINES
:     SCRNSET (9800)
:     READFUNC (9650)
::
9300 REM \ READFORM
9302 GOSUB 9800 :  \ SCRNSET
9304 LET X$=""
9306 LET E=0
9308 LET XLEN=0
9310 IF AND(XFLGS,64) THEN RETURN 
9312 INPUT USING "",@(XROW,XCOL),@(-10,XWID),@(-18,-1+2*AND(1,SHFT(XFLGS,-4))),X$,@(-18,1);
9314 LET X10=SYS(10)
9316 LET XLEN=LEN(X$)
9318 IF XLEN THEN IF XLEN<XWID THEN PRINT SPACES$[XLEN+1,XWID];
9320 LET X$=TRUN$(X$,1)
9322 IF AND(XFLGS,128)=0 THEN GOTO 9650 :  \ READFUNC
9324 VALUE X,X$,Y%,Z%
9326 LET E=128
9328 IF Y% THEN GOTO 9342
9330 IF AND(XFLGS,8)=0 THEN IF X<0 THEN GOTO 9342
9332 LET Z%=XDEC-MAX(Z%,0)
9333 IF X=0 THEN GOTO 9340              : Moved from 9325 needed for null respone test
9334 IF AND(XFLGS,16)=0 THEN IF Z% THEN GOTO 9342
9336 IF Z%<0 THEN LET X=X/10^(-Z%)
9338 IF Z%>0 THEN LET X=X*10^Z%
9340 LET E=0
9342 GOTO 9650 :  \ READFUNC :  \ READFUNC 
:
:! WRITEFORM - Display field F from X$ or X to a screen
:#
:     WRITEFORM outputs the field (F) from X$ if a string field, or from
:     X if a numeric field.  Numeric fields are formatted according to
:     specifications in the screen file.
:> CALLING SEQUENCE
:     F  - Field number (SEE SFORM)
:     R  - Row number (Optional - SEE SFORM)
:     X$ - String to display if string field
:     X  - Value to display if a numeric field
:     GOSUB 9500
:$ STORAGE
:     (SEE SFORM)
:& EXTERNAL ROUTINES
:     SCRNSET (9800)
::
9500 REM \ WRITEFORM
9502 GOSUB 9800 :  \ SCRNSET
9504 IF AND(XFLGS,128)=0 THEN GOTO 9522
9506 IF XDEC=0 THEN GOTO 9520
9508 LET LINE$=ABS(X)
9510 LET X$=""
9512 IF X<0 THEN LET X$="-"
9514 LET LINE$=" ",FILL$(48,XDEC-LEN(LINE$)),ABS(X)
9516 LET X$[0]=LINE$[2,LEN(LINE$)-XDEC],".",LINE$[LEN(LINE$)-XDEC+1]
9518 GOTO 9522
9520 LET X$=X
9522 LET LINE$=TRUN$(X$,1)
9524 IF LEN(LINE$)>XWID THEN LET LINE$=FILL$(42,XWID)
9526 PRINT @(XROW,XCOL);
9528 IF AND(XFLGS,64) THEN PRINT @(-55);
9530 LET Y%=LEN(LINE$)+1
9532 IF AND(XFLGS,32)=0 THEN PRINT SPACES$[Y%,XWID];
9534 PRINT LINE$;
9536 IF AND(XFLGS,32) THEN PRINT SPACES$[Y%,XWID];
9538 IF AND(XFLGS,64) THEN PRINT @(-54);
9540 RETURN 
:
:! READFUNC - Input a function key
:#
:     This routine inputs a function key if X10 is set and returns
:     a value from 1 to 16 in FUNC.
:      0 is return if no function key was pressed.
:     -1 is return if an illegal function key is pressed.
:> CALLING SEQUENCE
:     GOSUB 9650
:     FUNC - Function key entered.
::
9650 REM \ READFUNC
9652 LET FUNC=0
9654 IF X10=0 THEN RETURN 
9658 INPUT USING "","",@(-10,-1),@(-18,7),@(-18,1),LINE$;
9662 STRPOS FUNC,"qrstuvwxabcdefgh",LINE$
9668 IF FUNC THEN LET FUNC=FUNC+XSHFT
9670 LET XSHFT=0
9672 IF FUNC=0 THEN LET FUNC=-1
9674 IF FUNC=7 THEN GOTO 9684
9676 PRINT @(-18,-7);
9678 RETURN 
9684 LET XSHFT=8
9686 INPUT USING "","",LINE$;
9688 IF SYS(10) THEN GOTO 9658
9690 PRINT "<7>";
9692 GOTO 9686
:
:! OUTSCRN - Output screen from file and set up for screen I/O
:#
:     This routine displays screen X from file 15 and loads
:     the SCRN$ string.
:> CALLING SEQUENCE
:     X - Screen number to be displayed
:     Screen file open on channel 15.
:     GOSUB 9700
::
9700 REM \ OUTSCRN
9702 PRINT @(-30);@(-55);
9704 POSITION FILE[15,X*5120+1536]
9706 LET X$=""
9708 READ FILE[15],LINE$[1,3],X$[1,ASC(LINE$[3,3])]
9710 LET XROW=ASC(LINE$[1,1])
9712 IF XROW=0 THEN GOTO 9720
9714 LET XCOL=ASC(LINE$[2,2])
9716 PRINT @(XROW,XCOL);X$;
9718 GOTO 9706
9720 PRINT @(-54);
9721 LET SCRN$=""
9722 POSITION FILE[15,X*5120+128]
9724 READ FILE[15],Y%,SCRN$[1,Y%]
9726 RETURN 
:
:! WAITFUNC - Waits at the current field for a function key.
:#
:     This routine waits at the current field for a function key.
:     All other input is ignored.
:> CALLING SEQUENCE
:     GOSUB 9750
:& CALLS:
:     READFUNC (9650)
9750 REM \ WAITFUNC
9752 LET FUNC=0
9755 PRINT @(-18,7);
9760 LET XSHFT=0
9765 IF F=0 THEN GOTO 9686
9768 GOSUB 9800 :  \ SCRNSET
9770 PRINT @(XROW,XCOL);
9772 GOTO 9686
:
:! WAITCLEAR - Waits at the current field for function 16.
:#
:     This routine waits at the current field for function 16.
:     It then clears the message area and returns.
:> CALLING SEQUENCE
:     GOSUB 9775
:& CALLS:
:     WAITFUNC (9750)
:     ERRCLEAR (9890)
::
9775 REM \ WAITCLEAR
9780 GOSUB 9750 :  \ WAITFUNC
9785 IF FUNC<>16 THEN GOTO 9780
9790 GOTO 9890 :  \ ERRCLEAR
:
:! SCRNSET - Convert R and F to local variables for screen I/O
:#
:     This routine converts a field in F or in R and F (if 0<F<100) into
:     XROW, XCOL, XWID, XFLGS, XDEC

:> CALLING SEQUENCE
:     F  - Field (SEE SFORM)
:     R  - Row (Optional - SEE SFORM)
:     GOSUB 9800
:     XROW - Row number
:     XCOL - Column number
:     XWID - Field width
:     XFLGS - Flags
:     XDEC - Digits past decimal
::
9800 REM \ SCRNSET
9802 LET XROW=R
9804 STMA 21,SCRN$,F,XROW,Y%,XCOL,XWID,XFLGS
9806 LET XDEC=AND(XFLGS,7)
9810 RETURN 
:
:! ERROUT - Output an error message to line 24 of a screen
:#
:     This routine output an error message on line 24 of the screen.
:     If E<>0 then it uses the message from ERM$.  If E=0 then the
:     user supplied error message in X$ is displayed.
:> CALLING SEQUENCE
:     E  - Error code (FOR ERM$)
:     X$ - Error message (If E=0)
:     GOSUB 9850
::
9850 REM \ ERROUT
9852 IF E THEN LET X$=ERM$(E)
9854 PRINT @(24,1);@(-56);X$;@(-32);@(-54);
9860 RETURN 
:
:! ERRCLEAR - Clear error message from line 24 of a screen
:#
:     This routine clears the error message from the screen.
:> CALLING SEQUENCE
:     GOSUB 9890
:& CALLS:
:     ERROUT (9850)
::
9890 REM \ ERRCLEAR
9892 LET X$=""
9894 GOTO 9854
9899 REM ** END SFORM.SL 03/09/79
