:! MUL - Compute X = Y * PCNT where PCNT is xx.xx%
:#
:     MUL calculates X = Y * PCNT when PCNT is of the form xx.xx% as
:     returned from DIV without overflow.
:> CALLING SEQUENCE
:     Y   - Multiplicand
:     PCNT - Multiplier
:     GOSUB 7500
:     X   - result
:$ STORAGE USED
:     S   - Sign of the result
:     Z1  - Temporary
:     Z2  - Temporary
::
7500 REM \ MUL 
7502 LET S=SGN(Y)*SGN(PCNT)
7505 LET X=0
7510 IF S=0 THEN RETURN 
7515 LET Z2=ABS(PCNT)
7520 LET X=ABS(Y)/10000*Z2
7525 LET Z1=MOD(Y,10000)
7530 LET X=X+(Z1/100*Z2)/100
7535 LET X=X+(MOD(Z1,100)*Z2)/10000
7538 LET X=X+((MOD((Z1/100*Z2),100)*100)+MOD((MOD(Z1,100)*Z2),10000)+5000)/10000
7540 LET X=X*S
7545 RETURN 
7549 REM * END MUL.SL 4/27/77
