:! GETREC - Get the next available record form a linked file
:#
:     GETREC gets an empty record from the logical file F% and returns
:     the record number in R1.  If the file is full, R1 is returned
:     as -1.  If the record retrieve has a status (first two bytes)
:     which is greater than zero, an ERROR 16 occurs at statement 8470.
:> CALLING SEQUENCE
:     F%  - Logical channel number (entry in C1 array)
:     GOSUB 8400
:     R1  - Logical record number of available record (-1 if file is full)
:$ STORAGE USED
:     C%  - Physical record number
:     C1  - Logical/Physical file table
:     W0  - temporary (byte position of record zero)
:     X0  - temporary
:     X0% - temporary
:     Y0  - temporary
:     Y0% - temporary
:     Z0  - temporary
:& CALLS:
:     POSFL (9610)
::
8400 REM \ GETREC 
8405 LET C%=C1[F%,0]         :PHYSICAL CHANNEL NUMBER
8410 LET W0=C1[F%,1]         :BYTE OFFSET TO RECORD ZERO
8415 POSITION FILE[C%,W0]    :POSITION TO RECORD ZERO
8420 READ FILE[C%],X0%,Y0,Z0
8430 IF Y0=-1 THEN GOTO 8472 :DELETED LIST EMPTY?
8440 LET R1=Y0               :GET NEXT REC IN CHAIN
8450 GOSUB 9610
8460 READ FILE[C%],Y0%,X0
8470 IF Y0%>0 THEN LET Y0%=1/0   :REC IN USE - PANIC ! ! !
8471 GOTO 8480
8472 IF Z0=-1 THEN GOTO 8494 :FILE FULL - RETURN ERROR
8474 LET Z0=Z0+1             :BUMP REC # USED
8475 LET X0=Y0               :PRESERVE DELETE LINK
8476 LET Y0=Z0               :RETURN AVAIL REC#
8478 IF Z0>=C1[F%,2] THEN GOTO 8496    :JUST USED LAST REC IN FILE?
8480 POSITION FILE[C%,W0]    :POSITION TO RECORD ZERO
8491 WRITE FILE[C%],X0%,X0,Z0
8492 LET R1=Y0               :RETURN REC #
8493 RETURN                  :DONE
8494 LET R1=Z0               :RETURN ERROR FLAG
8495 RETURN
8496 LET R1=-1
8497 RETURN
8499 REM * END GETREC.SL  
