:! DELREC - Delete logical record R1 from file F%
:#
:     DELREC deletes the logical record R1 from the logical file F%.
:     The record is placed on the available chain for reuse (SEE GETREC).
:     An illegal R1 results in ERROR 16 at 8605.
:> CALLING SEQUENCE
:     F%  - Logical channel number
:     R1  - Logical record to be deleted
:     GOSUB 8600
:$ STORAGE USED
:     C%  - Physical channel number (from 9610)
:     R1  - Logical record number
:     W0  - Temporary (byte position of record zero)
:     X0  - Temporary
:     X0% - Temporary
:     Y0  - Temporary
:     Y0% - Temporary
:& EXTERNAL ROUTINES
:     POSFL (9610)
::
8600 REM \ DELREC
8602 X0=R1                   : Relative record #
8605 IF R1<=0 THEN X0=1/0    : Invalid record #
8610 LET C%=C1[F%,0]         : Physical channel number
8615 LET W0=C1[F%,1]         : Byte offset to record zero
8620 POSITION FILE[C%,W0]    : Position to record zero
8630 READ FILE[C%],X0%,Y0
8650 GOSUB 9610
8652 READ FILE[C%],Y0%        : Check to see if record was already deleted.
8655 IF Y0%>0 THEN STMA 19,81 : If status bit is not 0 then delete it.
8657 RETURN
8658 GOSUB 9610
8660 Y0%=0                   : Set delete flag (status bit is 0 when L.A.R.
8670 WRITE FILE[C%],Y0%,Y0					:is deleted)
8680 POSITION FILE[C%,W0]    : Position to record zero
8692 WRITE FILE[C%],X0%,X0
8695 RETURN                  : Done
8699 REM * END DELREC  
