/*************************************************************************
*
*
*	Name:  qmath.c
*
*	Description:  quad math routines.
*
*
*	History:
*	Date		By		Comments
*
*	3/18/83	waf
*	4/22/83	waf	qstore - chk sign bit overflow in returned val.
*	5/20/83	waf	rewrite - use native number format for calculations.
*	6/24/83 	mas		changed to use registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> Native number storage converted to QMATH format.

> movbdz() must be used instead of movbd(), so that zeroes will be moved.

> This code assumes that order of long vals in a quad val is <high>/<low>
	and order of words in a long val is <high>/<low>.


.SH */
#include	"/bb/include/ptype.h"
#include "/bb/include/bberms.h"


/*  Global vars used by Q routines  */

#define	QPRECB	8			/* # of bytes in quad value */


/* define 'decomposable' long val */
typedef	union	{
	long	lvalue ;			/* long value */
	struct {
		int	hiword ;		/* hi order word */
		int	loword ;		/* lo order word */
		} ;
	struct {					/* unsigned words */
		unsigned	uhiword ;
		unsigned uloword ;
		} ;
	}	DLONG ;

/* define 'quad register' structure */
typedef	struct	{
	DLONG		hilong ;		/* hi order long */
	DLONG		lolong ;		/* low order long */
	} 	QREG ;

static	QREG	qr[2];		/* 'quad registers' */


/* Macros */

#define	qnegm( N )		/* macro to negate quad reg #N */ \
	qr[N].hilong.lvalue = ~(qr[N].hilong.lvalue) ;\
	if ( (qr[N].lolong.lvalue = -(qr[N].lolong.lvalue) ) == 0L ) \
		qr[N].hilong.lvalue++ ;



/* External refs */

long	getvl();

/* 
.SH
			**  QLOAD  **
*/

qload ( str, lval )

STRDES	str;		/* $ to be loaded */
long	lval;		/* # to load */
	{

	/* get low order long (in QMATH format) */
	swab( &lval, &qr[0].lolong.lvalue, 4 );

	/* get hi order long */
	qr[0].hilong.lvalue = (lval < 0L)? -1L : 0L ;

	/* store into $ */
	movbdz( &qr[0], QPRECB, &str );
	updcl( &str );
	}


			/**  QSTORE  **/

qstore ( nvar, str )

NUMDES	nvar;		/* # var to load to */
STRDES	str;		/* $ to load from */
	{

	/* move $ into qreg */
	ldqr( 0, &str );

	/* chk hi long (must be 0 or -1) */
	if ( qr[0].hilong.lvalue != 0L && qr[0].hilong.lvalue != -1L )
		bberr( BEARI );		/* quad val too big */

	/* chk sign of low long vs sign of hi long (must be same) */
	if ( (qr[0].hilong.hiword ^ qr[0].lolong.hiword) < 0 )
		bberr( BEARI );

	/* put val in nvar */
	putvl( &nvar, qr[0].lolong.lvalue );
	}

/* 
.SH
			** QADD & QSUB **
*/


qadd ( result, str1, str2 )

/* result <- str1 + str2 */

STRDES	result, str1, str2;
	{

	/* get vals in qregs */
	ldqr( 0, &str1 );
	ldqr( 1, &str2 );

	/* do add */
	addqr( 0, 1 );

	/* store result */
	stqr( 0, &result );
	updcl( &result );
	}


qsub ( result, str1, str2 )

/* result <- str1 - str2 */

STRDES	result,str1,str2;
	{

	/* get vals in qregs */
	ldqr( 0, &str1 );
	ldqr( 1, &str2 );

	/* do sub */
	subqr( 0, 1 );

	/* save result */
	stqr( 0, &result );
	updcl( &result );
	}


/* 
.SH
*/
addqr ( op1, op2 )

/* add 2 quad regs using native arithmetic.
	qr[op1] <- qr[op1] + qr[op2]  */

int	op1,op2;
	{
	DLONG	tmpl;

	/* get carry info */
	tmpl.lvalue = (long) qr[op1].lolong.uloword + (long) qr[op2].lolong.uloword ;
	tmpl.lvalue = (long) qr[op1].lolong.uhiword + (long) qr[op2].lolong.uhiword
			+ (long) tmpl.uhiword ;

	/* add vals */
	qr[op1].lolong.lvalue += qr[op2].lolong.lvalue ;
	qr[op1].hilong.lvalue += qr[op2].hilong.lvalue ;

	/* chk overflow */
	qr[op1].hilong.lvalue += (long) tmpl.uhiword ;	/* add in carry from low long */
	}


subqr ( op1, op2 )

/* subtract a quad register from another quad register in native arithmetic.
	qr[op1] <- qr[op1] - qr[op2]  */

int	op1,op2;
	{
	DLONG	tmpl ;

	/* get borrow info */
	tmpl.lvalue = (long) qr[op1].lolong.uloword - (long) qr[op2].lolong.uloword ;
	tmpl.lvalue = (long) qr[op1].lolong.uhiword - (long) qr[op2].lolong.uhiword
			+ (long) tmpl.hiword ;

	/* sub vals */
	qr[op1].lolong.lvalue -= qr[op2].lolong.lvalue ;
	qr[op1].hilong.lvalue -= qr[op2].hilong.lvalue ;

	/* chk borrow */
	qr[op1].hilong.lvalue += (long) tmpl.hiword ;
			/* subtract borrow from low long */

	}
/* 
.SH */
			/** QMUL **/

qmul ( result, lval1, lval2 )

/*	result$ <- lval1 * lval2 */
/*	notes -
	lval1 = multiplier
	lval2 = multiplicand
*/

STRDES	result ;
DLONG		lval1, lval2 ;
	{
register int	sign ;			/* sign of result */


	/** get sign info **/
	sign = 1 ;		/* assume pos result */
	if ( lval1.hiword < 0 )
		{
		sign = -1 ;
		lval1.lvalue = -(lval1.lvalue);
		}
	if ( lval2.hiword < 0 )
		{
		sign = -sign ;	/* invert sign */
		lval2.lvalue = -(lval2.lvalue) ;
		}


	/** initialize **/
	qr[1].hilong.hiword = qr[1].lolong.loword = 0 ;		/* tmp */


	/** qr0 = f*2^32 + o*2^16 + i*2^16 + l **/

	/* qr0 = first * 2^32 */
	qr[0].hilong.lvalue =
		((long) lval1.uhiword) * ((long) lval2.uhiword) ;

	/* qr0 = qr0 + last */
	qr[0].lolong. lvalue =
		((long) lval1.uloword) * ((long) lval2.uloword) ;

	/* qr0 = qr0 + (outer * 2^16) */
	*(long *)(&qr[1].hilong.loword) =
			((long) lval1.uhiword) * ((long) lval2.uloword) ;
	addqr( 0, 1 );						/* r = r + (o * 2^16)

	/* qr0 = qr0 + (inner * 2^16) */
	*(long *)(&qr[1].hilong.loword) =
			((long) lval1.uloword) * ((long) lval2.uhiword) ;
	addqr( 0, 1 );						/* r = r + (i * 2^16) */



	/** get sign **/
	if ( sign < 0 )
		{
		/* negate result */
		qnegm( 0 );
		}


	/** store result **/
	stqr( 0, &result );
	updcl( &result );
	}



/* 
.SH */
			/** QDIV **/

/*  The divide algorythm is the same as the BBII interpreter's.  */

qdiv ( result, dividend, divisor, remainder, errvar )

NUMDES	result ;
STRDES	dividend ;
DLONG		divisor;
NUMDES	remainder, errvar ;
	{
register int	shftn, shftcnt, lte ;
	long	rslt ;
	int	remsgn, rsltsgn;		/* sign of remainder & result */
	int	cmpbit, hibit ;


	/** reset error var **/
	if ( isvar( &errvar ) )
		putvl( &errvar, 0L );


	/** get dividend **/
	ldqr( 0, &dividend );		/* qr0 = dividend/quotient */


	/** chk divisor **/
	if ( divisor.lvalue == 0L )
		{
		diverr:
		errchk( &errvar, BEARI );
		return;
		}


	/** get sign info **/
	rsltsgn = remsgn = 1 ;		/* assume positive */
	if ( divisor.hiword < 0 )		/* if negative divisor */
		{
		rsltsgn = -1 ;					/* result sign */
		divisor.lvalue = -(divisor.lvalue) ;	/* negate */
		}
	if ( qr[0].hilong.hiword < 0 )		/* negative dividend */
		{
		rsltsgn = -rsltsgn ;	/* invert result sign flag */
		remsgn = -1 ;		/* remainder will be negative */
		qnegm( 0 );			/* negate qr0 */
		}
	

	/** chk overflow **/
	if ( qr[0].hilong.lvalue > divisor.lvalue )
		{
		/* result would be > 32 bits */
		goto diverr ;
		}


	/** do divide **/
	cmpbit = shftn = 0 ;
	forever
		{

		/* shift low long of dividend/quotient */
		hibit = (qr[0].lolong.hiword < 0)? 1 : 0 ;		/* save hi bit */
		qr[0].lolong.lvalue <<= 1 ;		/* shift left */
		if ( cmpbit )		/* test result of prev. compare */
			qr[0].lolong.lvalue++ ;

		/* chk loop cntr */
		if ( shftn++ == 32 )
			break ;		/* done */

		/* shift hi long of dividend */
		qr[0].hilong.lvalue <<= 1 ;
		if ( hibit )
			qr[0].hilong.lvalue++ ;		/* shift in hi bit of low long */

		/* compare hi long & divisor */
		if ( divisor.uhiword < qr[0].hilong.uhiword )	/* cmp hi words */
			goto divsub ;
		if ( divisor.hiword == qr[0].hilong.hiword
			&& divisor.uloword <= qr[0].hilong.uloword )	/* cmp lo words */
			{
			divsub:

			/* subtract divisor from dividend & set cmp bit */
			qr[0].hilong.lvalue -= divisor.lvalue ;
			cmpbit = 1 ;
			}
		else
			cmpbit = 0 ;

		}		/* loop */


	/** store quotient **/
	if ( qr[0].lolong.hiword < 0 )
		goto diverr ;		/* overflow */
	putvl( &result,
		(rsltsgn < 0)? -(qr[0].lolong.lvalue) : qr[0].lolong.lvalue );


	/** store remainder **/
	if ( isvar( &remainder ) )
		{
		putvl( &remainder,
			(remsgn < 0)? -(qr[0].hilong.lvalue) : qr[0].hilong.lvalue );
		}

	}

/* 
.SH
*/
			/** Subroutines **/


ldqr ( regnum, strdes )

/* load a 'quad reg' from a string var desc
	and convert to native number format. */

int	regnum;		/* # of quad reg to use */
STRDES	*strdes;
	{

	/* init all bytes of qr to 0 (in case $var is not 8 bytes) */
	qr[regnum].hilong.lvalue = qr[regnum].lolong.lvalue = 0L;

	/* move into qreg */
	movdb( strdes, &qr[regnum], QPRECB );

	/* convert to native format */
	swab( &qr[regnum], &qr[regnum], QPRECB );
	}

stqr ( regnum, strdes )

/* store qreg val into str desc
	and convert to QMATH format. */

int	regnum;
STRDES	*strdes;
	{

	/* convert format */
	swab( &qr[regnum], &qr[regnum], QPRECB );

	/* move into str */
	movbdz( &qr[regnum], QPRECB, strdes );
	}
