
/*************************************************************************
*
*
*	Name:  prua
*
*	Description:  alphanumeric print-using formats
*
*
*	History:
*	Date		By	Comments
*
*	03/09/83	WEB
*	06/16/83	mas	memory and speed squeeze
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/

#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"


prua(string, pbufx)
STRDES string;
PRUDES *pbufx;
{
register PRUDES	*pbuf;
register int n,count;
   char fmtchar, *tptr, getfmt();

   pbuf = pbufx;

					/* check for end of format */
   if (pbuf->prfmtptr >= pbuf->prfmtend)

      if (pbuf->practivecount == 0)

	 return;			/* exit if no active formats */

      else {
					/* otherwise start over again */
	 pbuf->prfmtptr = pbuf->prfmtdes.data;

	 chkpru(pbuf);

      }

   fmtchar = getfmt(pbuf);

   switch (fmtchar) {

      case 'A':				/* alphanumeric formats */
      case 'R':
      case 'S':
	 n = getnum(pbuf, &count);

	 if (count == 0)
	    n = 1;			/* default to 1 if no number */

					/* save pointer to last field */
	 pbuf->prlastactive = pbuf->prioptr;

	 while (fmtchar == 'R' && n > string.curlth) {
	    *pbuf->prioptr++ = ' ';	/* space pad on left for R */
	    n--;
	 }

					/* move data */
	 while (n > 0 && string.curlth > 0) {
					/* replace nulls with spaces */
	    *pbuf->prioptr++ = (*string.data == '\0') ? ' ' : *string.data;
	    string.data++;
	    string.curlth--;
	    n--;
	 }

	 while (fmtchar == 'A' && n > string.curlth) {
	    *pbuf->prioptr++ = ' ';	/* space pad on right for A */
	    n--;
	 }

	 pbuf->practivecount++;		/* alphas count as active */

	 break;

      case 'L':				/* buffer manipulation formats */
	 if (getfmt(pbuf) != '1')
	    bberr(BEIFS);		/* error if not L10 or L11 */

	 switch (getfmt(pbuf)) {	/* select second digit only */

	    case '0':			/* L10: copy i/o buffer to string */
	       movbd(iobuf, IOSIZE, &string);

	       updcl(&string);

	       break;

	    case '1':			/* L11: copy string to i/o buffer */
	       tptr = iobuf;		/* start at beginning of i/o buffer */

	       count = IOSIZE;		/* maximum length of i/o buffer */

					/* move data wo/ updating i/o pointer*/
	       while (count > 0 && string.curlth > 0) {
		  *tptr++ = *string.data++;
		  count--;
		  string.curlth--;
	       }

	       break;

	    default:
	       bberr(BEIFS);		/* others are an error */

	 pbuf->practivecount++;		/* L10, L11, L12 count as active */

	 } /* end-switch */

	 break;

      default:
	 bberr(BEIFS);			/* others are an error */

   } /* end-switch */

   chkpru(pbuf);			/* process literals, etc. */

} /* end-prua */
