/*************************************************************************
*
*
*	Name:  phist.c
*
*	Description:  accumulates p-code histogram info
*
*
*	History:
*	Date		By	Comments
*
*	05/09/83	mas
*	6/24/83 	mas	Changed to use registers where possible
*	08/09/83	waf	Added profil() option.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

When the histogram option is turned on, bb will record certain data about
the execution of a given bb program.
This data is dumped to the file <pgmname>.st when execution is terminated.
The program /bb/utl/phdump is used to review the data.

If the PCODESW constant is set, frequency of execution of each p-code is
recorded.
If the PCSW constant is set, frequency of execution of given points in the
bb runtime code is recorded. The points are determined by the value of the
constant 'scale'. The system monitor function 'profil()' is used to record
this data.


waf	8/9/83
  Added new option to histogram to turn on the profil() system option.
  Thus, when a 'histogram' version of bb is created, it can use EITHER
  the (locally generated) p-code frequency histogram or the (profil() generated)
  pc frequency histogram.


.SH*/
#define	dbug	1

#include "/bb/include/ptype.h"
#include "/bb/include/pcondcomp.h"	/* hist switch, and type of hist data */

#ifdef PHIST

#include "/bb/include/pextern.h"

#if	PCSW
#define	scale	017777+1	/* scale factor for profil().
								Map 16 words to one (???)  */
#define	ptbytes	scale		/* #bytes in data buffer */
#else
#define	ptbytes	4096	/* size of array (in *bytes*) to hold hist data */
#endif

#define	ptwords	(ptbytes>>1)
#define	ptlongs	(ptwords>>1)


int		phsw;			/* if set, histogram enabled. (Set by parsecmd.c) */
long	phtab[ptlongs];	/* data stored in this array */
							/* type = long due to pcode hist */
static	PHHEAD	header;	/* hist output file header */

phinit()
{
register int	i;

	if (phsw != TRUE)
		return;

	for (i=0; i<ptlongs; ++i)
		phtab[i]=0;

#if	PCSW
	profil( phtab, ptbytes, 0, scale );		/* turn on profil() */
#endif

	return;
}

phinc(pcode,leadin)
char	pcode;
int	leadin;
{
register unsigned x;

	if (phsw != TRUE || PCSW == TRUE)
		return;

	x = leadin * 256 + (0xff & (int)pcode);

	if (x > 1023)
		x = 1023;

	++phtab[x];

	return;
}

phdump()
{
	char	phname[PATHSIZE];
register int	phfd;

	if (phsw != TRUE)
		return;

	strcpy(phname,ust.pname);
	strcat(phname,".st");

	if ((phfd = creat(phname,0666)) < 0)
		return;
	
	/* label output file */
#if	PCODESW
	strcpy( header.phtype, "pcodes" );
#else
	strcpy( header.phtype, "profil" );
#endif
	header.phwords = ptwords ;		/* # words in table */
	header.phscale = scale ;		/* scale factor */
	write( phfd, &header, sizeof(header) );	/* output header */

	/* dump phist table */
	swab(phtab,phtab,sizeof(phtab));
	write(phfd,phtab,sizeof(phtab));
	close(phfd);
	return;
}
#endif
