/*************************************************************************
*
*
*	Name:  parsecmd.c
*
*	Description:  Parses commands (argv[]) and sets debugsw and startline
*
*
*	History:
*	Date		By	Comments
*
*	03/23/83	mas
*	04/25/83	mas	added support for sys(11) by setting 
*				globsw
*	05/09/83	mas	added switch for p-code histogram
*	05/16/83	mas	added call to bpscan to remove .bp
*	06/13/83	mas	added continue switch
*	07/28/83	mas	added parse for push file name
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"

#include "/bb/include/pcondcomp.h"

#ifdef PHIST
extern	int	phsw;
#endif

#ifdef DEBDEF
unsigned DEB;
#endif

parsecmd(argc,argv) 
int	argc;
char	*argv[];
{
register int	i,j;
	long	l,x;
	char	c;
	unsigned t;

#ifdef DEBDEF
	DEB = FALSE;
#endif

	globsw = 0;
	debugsw = contsw = FALSE;
	startline = 0;
	ust.pname[0] = '\0';

	pushname = "\0";

	for (i=1; i<argc; ++i) {
		if (argv[i][0] == '+') {	/* push file name */
			pushname = &argv[i][1];
			continue;
		}
		if (argv[i][0] == '-') {
			for(j=1; (c = argv[i][j]) != '\0'; ++j) {
				if (c == 'd') {
					debugsw = TRUE;
					continue;
				}
				if (c == 'c') {
					contsw = TRUE;
					continue;
				}
#ifdef PHIST
				if (c == 's') {
					phsw = TRUE;
					continue;
				}
#endif
				if (c >= 'A' && c <= 'Z') {
					t = 31 - (c - 'A');
					x = 1;
					x <<= t;
					globsw |= x;
				}
#ifdef DEBDEF
				if (c == 'Z')
					DEB = TRUE;
#endif
			}
		}else if(argv[i][0]>='0'&&argv[i][0]<='9'&&ust.pname[0]!='\0'){
			if (startline != 0)
				bberr(BESYN);
			cdbl(&argv[i],&l,1);
			if (l > 0 && l < 10000)
				startline = l & 0xffffL;
		} else {
			if (ust.pname[0] != '\0')
				bberr(BESYN);
			strncpy(ust.pname,argv[i],PATHSIZE-1);
			bpscan(ust.pname);	/* get rid of .bp */
		}
	}
	return;
}
