/*************************************************************************
*
*
*	Name:  lintable.c
*
*	Description:
*			Line Table routines
*
*			nextstmt - finds PC of next statement given current PC
*			linetopc - finds the PC given the line number
*			pctoline - finds the line number given the PC
*
*	History:
*	Date		By	Comments
*
*	03/02/83	mas
*	05/09/83	mas	changed to handle the case where no line
*				number table is loaded
*	05/12/83	mas	changed pctoline to handle the case where
*				lines have no numbers
*	05/16/83	mas	removed unused automatics and used registers
*				where possible
*	09/13/83	waf	nextstmt() - stop if PC = start of stmt.
*	12/15/83	waf		Chk for LTP = 0. (See note).
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

09/13/83	waf
  Previously, nextstmt() would goto the next stmt, even if the input PC was
the addr of an STMTX stmt (e.g. even if the PC was already at the beginning
of a stmt, nextstmt() would skip over to the next stmt).
This was changed so that, nextstmt() will return immediately if PC is the
addr of the beginning of a statement line.
This was done for the RETINT p-code, which uses nextstmt() to find the
stmt to 'return' to after processing interrupt code.
NOTE - if using nextstmt() to skip some or all of the code in a given stmt
line, used 'nextstmt(PC+1)' to be sure to skip to the NEXT stmt line.

12/15/83	waf
  At some points, the GFP is set to point to the 'dummy' global frame. When
it is, the value of LTP will be '0'. This means that the line# table is not
usable at this point, so all routines which reference the line# table must
chk for this, and, if LTP is 0, handle it as a special case.
  Note special handling in each function.

*/




#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"
#include "/bb/include/bberms.h"

char *nextstmt (PC)
/*
synopsis -
	Find the addr of the beginning p-code of the 'next' statement.

description -
	Uses the line table to find the first line which starts at an addr
	greater than or equal to the input addr.
	NOTE that, if the input addr is the addr of a stmt line, the function
	does NOT skip to the next stmt.
	If you want to be sure to skip the current stmt code, use 'nextstmt(PC+1)'.

return -
	return val	= (abs) addr of first p-code of 'next' stmt.
*/
POINTER PC;
{
	register struct lnrec *lnptr;
	register unsigned	target;
	char	*endtbl;


	/* get line# table ptr */
	if (pcheader.noltab == TRUE)	/* no line# table */
		bberr(BEOPT);
	lnptr = GFP->LTP;
	if ( lnptr == (char *) 0 )		/* line# table not current */
		panic() ;	/* should not have been called */

	/* find 'next' stmt */
	target = (unsigned)(PC.B - begmem) ;		/* offset of input addr */
	endtbl = (char *)GFP->LTP + pcheader.ltabsiz;	/* end of line table */
	while ( lnptr->pcoffset < target ) {
		++lnptr;
		if ( (char *)lnptr >= endtbl ) {
			/* end of line table, return last stmt */
			--lnptr;
			break;
			}
		}
	return ((char *)(begmem + lnptr->pcoffset));
	}

char *linetopc (line)
unsigned line;
{
	register struct lnrec *lnptr;


	/* get line# table ptr */
	if (pcheader.noltab == TRUE)	/* no line# table */
		bberr(BEOPT);
	lnptr = GFP->LTP;
	if ( lnptr == (char *) 0 )		/* line# table not current */
		panic() ;	/* should not have been called */

	while (lnptr->lineno != line) {
		++lnptr;
		if ((char *)lnptr >= ((char *)GFP->LTP)+pcheader.ltabsiz)
			return((char *)0);
		}
	return ((char *)(begmem + lnptr->pcoffset));
	}

long pctoline (PC,mode)

/* Convert tpc to line#. */

POINTER PC;
int	mode;			/*    0  return last line with number */
					/*    1  return line plus offset */
{
	register int	i;
	unsigned offset;
	char	*endtab,*begtab;
	long	l;
	register struct lnrec *lnptr;


	/* get tpc offset */
	if (PC.B == (char *)0)		/* tpc not set */
		return(0);			/* return line# '0' */
	offset = PC.B - begmem;		/* set offset to look for */

	/* get line# table ptr */
	if (pcheader.noltab == TRUE)	/* no line# table */
		return(offset);
	lnptr = GFP->LTP;		    /* set beginning of table */
	if ( lnptr == (char *) 0 )		/* line# table not current */
		return(0) ;				/* return line# '0' */

	begtab = (char *)lnptr;
	endtab = begtab + pcheader.ltabsiz; /* set end of table */

	/* scan forward until pc greater than given PC */
	for  ( ;(char *)lnptr < endtab && lnptr->pcoffset <= offset; ++lnptr)
		;

	/* backup one entry */
	if ((char *)lnptr > begtab)
		--lnptr;

	/* compute offset from that line */
	for (i=0; (char *)lnptr > begtab && lnptr->lineno == 0; ++i,--lnptr)
		;

	if (mode == 0)
		l = 0;
	else {
		l = i;
		l <<= 16;
		}

	l |= lnptr->lineno & 0xffffL;

	return(l);
	}
