/*************************************************************************
*
*
*	Name:  crm.c
*
*	Description:  CRM$ and UCM$ statements.
*
*
*	History:
*	Date		By		Comments
*
*	4/6/83	waf	
*	4/??/83	mas	Change order of args.
*	4/12/83	waf	Fix crammed values.
*	6/24/83 mas	changed to use registers where possible
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */
#include	"/bb/include/ptype.h"
#include "/bb/include/pextern.h"
/*
			**  CRM  **
*/
#define	CRM_S1	0		/* crammed special char #1 */
#define	CRM_S4	3		/* crammed special char #4 */
#define	CRM_0		4		/* crammed '0' */
#define	CRM_9		13		/* crammed '9' */
#define	CRM_A		14		/* crammed 'A' */
#define	CRM_Z		39		/* crammed 'Z' */

extern	char	cram[];


crma ( dststr,srcstr  )

STRDES	srcstr, *dststr ;
	{
register int	i;
	unsigned	wbuff;	/* cram into this word */
	char	cbuf[2];		/* movs buffer */

	/**  convert src bytes  **/
	while ( srcstr.curlth != 0 && dststr->maxlth != 0 )
		{

		/** fill word buffer with next 3 bytes from src str **/
		wbuff = 0 ;
		for ( i=0 ; i < 3 ; i++ )
			wbuff = wbuff * 40 + gcvt( &srcstr ); /* *40+next byte*/ 
		
		/** put word buffer in dst str **/
		swab( &wbuff, cbuf, 2 );	/* move into char buffer */
		movbdz( cbuf, 2, dststr );	/* move to dst str */
		}

	return;
	}


/* 
.SH
*/

gcvt ( strdes )

/*  get next byte from src strdes & convert to cram format  */
/*  returns converted int val or converted ' ' if end of $ or 
		0 if char is not cram char )  */

STRDES	*strdes;
	{
register int	b;
register char	c;
	int	ptr;

	b = acsv( strdes );
	c = (char) b ;
	if ( b != -1 )
		{

		/** convert alpha or numeric **/
		/* test alpha */
		if ( c >= 'A' && c <= 'Z' )
			return( c - 'A' + CRM_A );
		/* test numeric */
		if ( c >= '0' && c <= '9' )
			return( c - '0' + CRM_0 );
		}

	else
		c = ' ';		/* use ' ' if end of $ */

	/** convert special char **/
	for ( ptr=0 ; ptr < 4 ; ptr++ )
		if ( c == cram[ptr] )  return( ptr + CRM_S1 );	/* char found */
	return( CRM_S1 );		/* not cram char */
	}


acsv ( xstr )

/*  get next byte from SRC str desc  */
/*  returns int val or '-1' if no bytes left  */

STRDES	*xstr;
	{
register STRDES	*str;
register unsigned	retval;

	str = xstr;

	if ( str->curlth != 0 )
		{
		str->curlth-- ;
		retval = ( *(str->data++) & 255 );
		}
	else
		retval = ( -1 );
	return( retval );
	}

/* 
.SH
			**  UCM$  **
*/

ucma ( xdststr,srcstr  )

STRDES	srcstr, *xdststr ;
	{
	char	cbuff[3];
	unsigned	wbuff;
register STRDES *dststr;

	dststr=xdststr;

	while ( srcstr.curlth != 0 && dststr->maxlth != 0 )
		{

		/** get next 2 bytes from src **/
		cbuff[1] = 255 ;	/* use 255 for b2 if only 1 byte */
		movdb( &srcstr, cbuff, 2 );		/* get 2 bytes */
		swab( cbuff, &wbuff, 2 );		/* convert to int */

		/** convert to uncrammed **/
		cbuff[0] = cstr( (wbuff / 1600) );	/* 1st byte */
		wbuff %= 1600 ;
		cbuff[1] = cstr( (wbuff / 40) );		/* 2nd byte */
		wbuff %= 40 ;
		cbuff[2] = cstr( wbuff );			/* 3rd byte */

		/** move it to dst str **/
		movbdz( cbuff, 3, dststr );
		}

	return;
	}


cstr ( xb )

/*  convert byte b to uncrammed form  */

int	xb;
	{
register int b;

	b = xb;

	/** test numeric **/
	if ( b >= CRM_0 && b <= CRM_9 )
		return( b - CRM_0 + '0' );

	/** test alpha **/
	if ( b >= CRM_A && b <= CRM_Z )
		return( b - CRM_A + 'A' );

	/** cram special char **/
	return( cram[ b - CRM_S1 ] );
	}
