/*************************************************************************
*
*
*	Name:  chkpath.c
*
*	Description:  does search of current directory, then /bb/syslib
*		      then used BBPATH in environ for further searching
*
*
*	History:
*	Date		By	Comments
*
*	05/20/83	mas
*	06/01/83	mas	fixed bug where second name in BBPATH
*				was getting garbled
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */



/*  Notes -

*/


#include "/bb/include/ptype.h"
#include "/bb/include/pextern.h"


chkpath(name1,name2)
char	*name1,*name2;
{
	char	buf[PATHSIZE+1],buf1[PATHSIZE+1],*cptr;
register int	i,e;

	spscan(name1);	/* remove trailing junk */

	/* try current directory */
	if ((e = resolve(name1,name2)) != 0)
		return(e);
	if (access(name2,0) == 0)
		return(0);

	/* try /bb/syslib directory */
	strcpy(buf,xlibdir);
	strcat(buf,name1);
	if ((e = resolve(buf,name2)) != 0)
		return(e);
	if (access(name2,0) == 0)
		return(0);
	
	/* try BBPATH */
	if (bbpath == (char *)0 || strlen(bbpath) == 0) {
		strcpy(name2,name1);
		return(0);
	}

	strncpy(buf,bbpath,PATHSIZE);

	for(i=0; buf[i] == ':'; ++i)
		;

	for(; i < PATHSIZE; ++i) {
		cptr = &buf[i];
		for (; buf[i] != ':' && buf[i] != '\0' && i < PATHSIZE; ++i) 
			;
		buf[i] = '\0';
		strcpy(buf1,cptr); /* put in dir name */
		strcat(buf1,"/");
		strcat(buf1,name1);
		if ((e = resolve(buf1,name2)) != 0)
			return(e);
		if (access(name2,0) == 0)
			return(0);
	}

	strcpy(name2,name1);

	return(0);
}
