/*************************************************************************
*
*
*	Name:  bpopen.c
*
*	Description:  opens a pipe to a shell script using only fd's.
*
*
*	History:
*	Date		By	Comments
*
*	04/27/83	mas	
*	05/18/83	mas		added call to spscan to remove trailing spaces and
*					control characters.
*	05/25/83	mas		changed to use the shell to execute a string so
*					that pipes and i/o redirection and PATH searching work.
*	06/23/83	mas		error on null string.
*	07/25/83	waf		Added BB/PC conditional code.
*					bpopen() disabled for BB/PC.
*	09/08/83	waf		Added bpclose() function.
*					Added pipe_pid[] array.
*	09/13/83	waf		bpclose(fd) - return status returned by close().
*					Also, bpopen(fd) - return status returned by pipe() call.
*	09/13/83	waf		Chk fd against MAXFD before indexing pipe_pid array.
*	10/25/83	waf		Change 'MAXFD' constant to 'SYSCHANS'.
*	12/07/83	waf		Ignore non-EINTR errors returned by wait() call.
*					(See Note).
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -
		Taken from vol. 2a of the XENIX manuals
		"UNIX Programming - Second Edition"
		by Brian W. Kernigan
		   Dennis M. Ritchie
		page 13


09/08/83	waf
  The array pipe_pid[] was added to allow multiple pipes to be open. This
extends the 'bpopen()' fn described in XENIX manual.
  NOTE - the bpclose() function MUST be called to close the pipe created by
bpopen(). If not, the defunct process hangs around until the parent process
(bb) terminates.

12/07/83	waf
  If the SYSTEM BB command is executed after a pipe is opened via bpopen
(e.g. after an OPEN FILE in mode 12 or 13),
the 'system()' call which is invoked by the SYSTEM BB command code *may* 
flush the pid of the pipe we opened via bpopen(). Thus, if bpclose() gets
an error returned from the wait which is not EINTR, THE ERROR IS IGNORED.

12/14/83	waf
  NOTE - Errors from the wait() call in bpclose() are IGNORED because there
are other routines which call wait(), and they IGNORE pid's that they are 
not looking for. (i.e. system(), bpause()).
  Ignoring errors was done as a 'quick fix'. To fix this bug correctly,
all routines which do a wait() must be able to handle multiple pids (using
the pipe_pid array defined in this mod).

*/




#include	"/bb/include/pdefine.h"
#include	"/bb/include/bberms.h"
#include	<errno.h>



#if	BB_X86		/* only implemented for BB/X86 */

#define READ 0
#define WRITE 1
#define tst(a,b) (mode == READ?(b):(a))
extern	int	errno;
extern	int	valikey;


int	pipe_pid[SYSCHANS];		/* save pid of each pipe call using fd as index */

bpopen (cmd, mode)

char	*cmd;
int	mode;
{
	int	p[2],i,j;
	char	*argv[100];
	int		pid;
	int		fd;

	spscan(cmd);		/* remove trailing junk */

	if (strlen(cmd) == 0)
		bberr(BESAR);

	argv[0] = "/bin/sh";
	argv[1] = "-c";
	argv[2] = cmd;
	argv[3] = (char *)0;

	if ( (i=pipe(p)) < 0)
		return( i );		/* return error status */

	if ( (pid = fork()) == 0) {	/* child process */
		close(tst(p[WRITE],p[READ]));
		close(tst(0,1)); /* connect to stdin/out */
		dup(tst(p[READ],p[WRITE]));
		close(tst(p[READ],p[WRITE]));
		execv(argv[0],argv);
		_exit(-1);
		}
	close(tst(p[READ],p[WRITE]));

	fd = tst(p[WRITE],p[READ]);		/* fd of pipe */

	/* set pipe_pid entry to pid of pipe */
	if ( fd >= SYSCHANS )
		panic();		/* somebody lied */
	pipe_pid[fd] = pid ;			/* save pid for bpclose() */

	return( fd );
	}

bpclose ( fd )

/* Close a file and, if the fd is for a pipe, wait for the death of
   the pipe process.

Description -
	After closing the fd of a pipe, it is necessary to wait for the
	termination of the pipe process. This function does the close
	and, if the pipe process has not already died, waits for the pipe
	process to die. The array pipe_pid is used to flag fd's which are
	associated with a pipe process. If the pipe_pid entry is non-zero,
	the pipe process for that fd (if one exists) has not yet died.

return -
	return val	= value returned by the call to close().
*/

int		fd;		/* fd of file to close */
{
	register int	retpid;
	register int	pipepid;
	int		status;
	int		i;
	int		clsret;		/* val returned from close() call */


	/* close the fd (and kill pipe proc if it exits) */
	if ( (clsret = close( fd )) < 0 ) {
		;		/* bad fd (already close()'ed). Chk it anyway.		   ??? */
		}

	/* chk pipe_pid array for live pipe process */
	if ( fd >= SYSCHANS )
		panic();		/* oops */
	pipepid = pipe_pid[fd] ;
	if ( pipepid == 0 )
		return( clsret );		/* not a pipe fd */


deathwatch:
	/** wait for death of pipe proc **/
	valikey = FALSE ;		/* be sure ikeys are 'disabled' */
	retpid = wait(&status);		/* wait for pipe proc death */
	if ( retpid == pipepid ) {
		/* this is our pipe proc */
		pipe_pid[fd] = 0 ;		/* flag as dead */
		return(clsret) ;
		}

	/* some other signal */
	if ( retpid < 0 ) {		/* error - could be int signal */
		if ( errno == EINTR )
			goto deathwatch;	/* ikey - flag set by int code */
		/* some other error */
		return(clsret);		/* Ignore other errors					   <<< */
		}
	for ( i=(SYSCHANS - 1) ; i-- > 0 ; ) {
		if ( pipe_pid[i] == retpid ) {
			pipe_pid[i] = 0 ;		/* flag as dead */
			goto deathwatch ;		/* keep waiting for our's */
			}
		}
	
	/* Some other proc. What to do ??? */
	goto deathwatch;		/* ignore it 							   <<< */

	}
#endif
