
/*************************************************************************
*
*
*	Name:  pexit.h
*
*	Description:  Define p-machine exit code values.
*
*
*	History:
*	Date		By		Comments
*
*	08/30/83	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

When p-machine execution ends, an exit code is returned to the parent process
(if any). The exit code returned is determined by the method by which the 
program the pmachine was executing terminated. The constants defined below
assign values to the termination conditions.

The status return code values were chosen to be consistent with Xenix return
code conventions.



.SH*/

/***	These are ** temporary ** values	***/


#define	NORM_XIT	0		/* Normal exit (END or BYE) */

#define	STOP_XIT	0 /*	0177	/* Pgm term'ed by a 'STOP' statement.
							This is the 'special code' documented in wait(2)*/

#define	INTR_XIT	0 /*	2		/* Pgm term'ed by (untrapped) ikey.
							This code corresponds to the SIGINT code. */

#define	PGMER_XIT	0 /*	15		/* Pgm term'ed by (untrapped) pgm error.
							This code corresponds to the SIGTERM code. */

#define	SYSER_XIT	(-1)	/* P-machine execution term'ed due to 'system' error. */
