/*************************************************************************
*
*
*	Name:  index.h
*
*	Description:  structures used by the logical file indexing
*		      routines (isam.c)
*
*
*	History:
*	Date		By	Comments
*
*	05/12/83	WEB
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

	All numerics (unsigneds) MUST be swab'd prior to use
	 as the index file is not stored in internal format

*/


/*************************************************************************

	block zero - first 32 bytes of buffer string

*************************************************************************/

	typedef	struct	 blk0 {
		unsigned keysiz;	/* bytes per key (incl. pointer) */
		unsigned keyblk;	/* keys per block */
		unsigned lastblk;	/* last block number */
		unsigned nextblk;	/* next available block */
		unsigned lv0blk;	/* level zero block number */
		unsigned blkfact;	/* keys per block (re-build only) */
		unsigned kflags;	/* flags  1b0 = dup keys allowed */
		char	 kfill[16];	/* filler */
		unsigned curkey;	/* relative pointer to current key */
	} BLOCK0;

/*************************************************************************
	
	index block - last 512 bytes of buffer string

*************************************************************************/

	typedef	struct	 idxblk {
		unsigned keycnt;	/* number of keys in this block */
		unsigned klink;		/* link to next block in sequence */
					/*       0 = not lowest level */
					/*      -1 = end of seq list  */
		char	 kdata[508];	/* key data */
	} IDXBLK;

/*************************************************************************
	
	buffer string layout for KADD, KDEL, KNEXT, KFIND

*************************************************************************/

	typedef	struct	kbuf {
		BLOCK0	b0;
		IDXBLK	dat;
	} KBUF;

/*************************************************************************
	
	support definitions for ISAM routines

*************************************************************************/

#define KFIND 1
#define KNEXT 2
#define KADD  3
#define KDEL  4

#define ALLOW_DUPS 1

