
: !P_TBUILD
:
: BUILDS TAG FILE GIVEN A INDEX FILE (KEY & RECORD NUMBER)
:   OR DATA FILE (IMBEDDED KEY & DATA RECORD NUMBER).
:
: ARGUEMENTS PASSED IN COMMON
:   LOC  LEN  USE
:    1    4   CHANNEL # OF INPUT FILE 
:    5    4   BYTE OFFSET TO REC # 0 OF INPUT FILE
:    9    4   LAST-RECORD-NUMBER IN INPUT FILE 
:   13    4   # OF BYTES PER RECORD IN INPUT FILE
:   17    4   CHANNEL # OF TAG FILE 
:   21    4   BYTE OFFSET TO REC # 0 OF TAG FILE
:   25    4   LAST-RECORD-NUMBER IN TAG FILE 
:   29    4   # OF BYTES PER RECORD IN TAG FILE 
:   33    2   # PER BLOCK (BLOCKING FACTOR)
:   35    2   FLAG TO DISALLOW DUPLICATE KEYS   
:   37    2   FLAG TO CHECK FOR DELETED RECORDS
:   39    2   TOTAL KEY FIELD LENGTH (BYTES)
:   41    2   # OF KEY FIELDS 
:   43+  2*2  STARTING & ENDING BYTE # (RELATIVE TO 1) OF KEY
:             FIELDS IN ORDER OF SIGNIFIGANCE
:
: RETURNED
:   STMA 2,1,(ERROR CODE)
:   STMA 2,2,(LINE # IN ERROR)
:
: DATA FILE: KEY EXTRACTED FROM DATA RECORD COMPOSED OF THE FIELDS 
:   SPECIFIED, UP TO THE TOTAL KEY FIELD LENGTH. PADDING OF ODD SIZED
:   KEYS WITH NULLS IS AUTOMATIC.
:   DATA RECORDS 1 TO MAX#-1 ARE PROCESSED.
:
: TAG FILE: CONTAINS KEY FIELD BEGINNING AT BYTE 0 AND RECORD NUMBER
:   IMMEDIATELY FOLLOWING KEY (4 BYTES LONG)
:   RECORDS 0 TO MAX#-1 ARE PROCESSED.
:
:   TBUILD - Program to build a tag file, given a data file or index file.
:
0100 ON ERR THEN GOTO 5030          :Return error traps to c calling program
0101 REM TBUILD - REV 2.00 (09/26/77)
0110 LET ERCODE%=0                  :Clear error code
0200 DIM COM$[512]                    :Read arguments from common
0230 BLOCK READ COM$
0260 UNPACK "LLLLLLL",COM$,INPCHN%,INPDSP%,INPMAX%,INPSIZ%,TAGCHN%,TAGDSP%,TAGMAX% 
0290 UNPACK "@29LJJJJJ",COM$,TAGSIZ%,KPBLOC%,DUPKEY%,CKSTAT%,KEYLEN%,NKFLDS% 
0518 LET INPTYP%=NKFLDS%
0519 IF INPTYP%>0 THEN GOTO 0522
0520 LET INPTYP%=0                 :Adjust for index & tag input
0521 GOTO 0650
0522 LET INPTYP%=1                 :Flag for input file type (data)
0523 DIM KDEF%[NKFLDS%*2,0]        :Allocate key definition array
0524 FOR I%=43 TO 41+4*NKFLDS% STEP 2   :Extract field locations
0525   LET KDEF%[(I%-43)/2]=ASC(COM$[I%,I%+1])
0526 NEXT I%
0528 LET NKFLDS%=NKFLDS%-1         :Change 1:n to 0:n-1
0530 DIM KDEF%[NKFLDS%,1]          :ReDIM for easier access
0535 DIM REC$[INPSIZ%]             :Allocate input record
0650 DIM KEY$[KEYLEN%]              :Allocate key buffer
0680 DIM LASTKY$[KEYLEN%]           :Allocate buffer for seq check
0710 IF KEYLEN%+4>TAGSIZ% THEN GOTO 5005      :Tag rec large enough??
0770 LET RECCNT=0                   :Clear record count
0800 LET SEQFLG%=1                  :Assume sorted file
0830 LET DUPFLG%=0                  :Assume no duplicates in file 
0860 IF INPTYP% THEN GOTO 3000      :For data file skip index routines
:
:   Index file input proocedure
0890 LET X%=INPDSP%/512             :Byte offset to block ofset
0920 IF MOD(INPDSP%,512) THEN GOTO 5008       :Verify offset is block boundary
0950 DIM LFTABL$[52],BUFFER$[544]   :Allocate descriptor & buffer for index routines
0980 LOPEN FILE[1,INPCHN%,3],"","I",512,INPMAX%,INPDSP%
1010 LET KEY$=""                    :Find beginning of index
1040 LET RECNO=0
1070 KFIND 1,BUFFER$,KEY$,RECNO
1100 IF ASC(BUFFER$[1,2])>TAGSIZ% THEN GOTO 5005   :Tag record large enough?
1130 LET RECNO=ABS(RECNO)         :Correct sign of firt pointer
1160 GOTO 1220                      :Jump into read seq loop
1190 KNEXT 1,BUFFER$,KEY$,RECNO    :Next entry
1220 IF RECNO<=0 THEN GOTO 3120    :End of index??
1250 GOSUB 4800                   :Write tag record
1280 GOTO 1190
:
:   Data file procedure
3000 POSITION FILE[INPCHN%,INPDSP%+INPSIZ%] :Position to beginning of file 
3005 FOR ITMP=1 TO INPMAX%-1         :Process data file between limits
3010   LET RECNO=ITMP               :Current record #
3020   POSITION FILE[INPCHN%,RECNO*INPSIZ%+INPDSP%]
3040   READ FILE[INPCHN%],REC$       :Read record
3050   IF EOF(INPCHN%) THEN GOTO 3130     :File shorter than specified
3060   IF CKSTAT% THEN IF REC$[1,2]="<0><0>" THEN GOTO 3110    :Skip deleted records
3064   LET KEY$=""                 :Clear key
3066   FOR I%=0 TO NKFLDS%         :Compose key
3068     LET KEY$[0]=REC$[KDEF%[I%,0],KDEF%[I%,1]]
3070   NEXT I%
3100   GOSUB 4800                   :Write tag record
3110 NEXT ITMP
: EOF processing
3120 LET COM$[25,28]=CHR$(RECCNT,4)   :Return  record count to calling program
3130 IF SEQFLG% THEN GOTO 3150    :Pass back err indicating file unsorted
3140 GOTO 5006
3150 IF DUPKEY%=0 THEN IF DUPFLG% THEN GOTO 5003    :Pass duplicate entry err
3160 GOTO 5060
:
:  Tag record write
4800 IF KEY$<LASTKY$ THEN LET SEQFLG%=0   :File not sorted
4810 IF KEY$=LASTKY$ THEN LET DUPFLG%=1   :Duplicate found
4820 LET LASTKY$=KEY$           :Keep key for seq check
4830 IF RECCNT>=TAGMAX% THEN GOTO 5010    :Tag file full??
4840 POSITION FILE[TAGCHN%,TAGSIZ%*RECCNT+TAGDSP%]
4850 WRITE FILE[TAGCHN%],KEY$,RECNO   :Write tag record
4860 LET RECCNT=RECCNT+1          :Bump recordcount
4870 RETURN 
:
: Error code returns
5000 DATA 68,150,148,45,149,151,85,146
5003 READ ERCODE%        : 146 - Duplicate entry
5004 READ ERCODE%        : 077 - Invalid record pointer
5005 READ ERCODE%        : 151 - Key size found > specified
5006 READ ERCODE%        : 149 - Input record out of sequence
5007 READ ERCODE%        : 045 - Illegal index record size(<>512)
5008 READ ERCODE%        : 148 - Illegal index file displacement
5009 READ ERCODE%        : 150 - Illegal blocking factor
5010 READ ERCODE%        : 068 - Index space exhausted
5015 LET X%=0                     :Clear line #, not a BASIC error
5020 GOTO 5050
5030 LET ERCODE%=SYS(7)           :BASIC error code
5040 LET X%=SYS(20)         :Line # in error
5050 STMA 2,2,X%
5060 STMA 2,1,ERCODE%
5070 BLOCK WRITE COM$
5080 END
