/*************************************************************************
*
*
*	Name:  debsubs.c
*
*	Description:  Debugger -  'subroutines' for debug code.
*
*
*	History:
*	Date		By		Comments
*
*	4/15/83	waf
*	4/20/83	waf	chksum() - return neg. value.
*	5/2/83	waf	pmcall() - disable caller check.
*	6/27/83	mas	added cnvangle for conversion of angle brackets
*			in a string assignment
*	12/07/83	waf		Deleted chksum() fn.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -


.SH */

#include	"debug.h"

/***  access p-codes  ***/

getpcode ( os )

/* given pc offset, return code at that location in pmd/push file */

int	os;
{
	int	icode;
	char	b;
	long	ptr;

	ptr = pcdfp + (long) os ;
	lseek( pmfd, ptr, 0 );
	read( pmfd, &b, 1 );
	icode = (int) b ;
	if (0)
		printf( "getpcode: os,ptr,val = %s %Xh %s\n",
			numstr(os),ptr,numstr(icode) );
	return( icode );
	}

putpcode ( os, icode )

/* given pc offset, write icode to pmd/push file */

int	os, icode;
{
	long	ptr;
	char	code;

	ptr = pcdfp + (long) os ;
	lseek( pmfd, ptr, 0 );
	code = (char) icode ;
	write( pmfd, &code, 1);
	if (0)
		printf( "putpcode: os,ptr,val = %s %Xh %s\n",
			numstr(os),ptr,numstr(code) );
	}
/* 
.SH */

/***  access values in stack  ***/


getstkb ( sos )

/* get byte from eval stack, given (stack) offset */
/** returns int **/

int	sos;
{
	int	ix;
	unsigned	rslt;

	rslt = (int) evalstk[ sos ];
	rslt = rslt & 255;
	if (0)
		printf( "getstkb: sos, val = %s %s\n", numstr(sos),numstr(rslt) );
	return( rslt );
	}

getstkw ( sos )
/* given (stack) offset, get word from eval stack */

int	sos;
{
	int	rslt;
	int	hi,lo;

	rslt = *(int *)(evalstk + sos);
	if (0)
		printf( "getstkw: sos, val = %s %s\n", numstr(sos),numstr(rslt) );
	return( rslt );
	}

long	getstklw ( sos )

/* given (stack) offset, get long word from eval stack */

int	sos;
{
	long	rslt;
	int	hiwd,lowd;

	rslt = *(long *)(evalstk + sos);
	if (0)
		printf( "getstklw: sos, val = %s  %Dd\n", numstr(sos),rslt );
	return( rslt );
	}

putstkw ( sos, val )

/* given (stack) offset, put word in eval stk */

int	sos,val;
{

	*(int *)(evalstk + sos) = val;
	}

putstklw ( sos, val )

/* given (stack) offset, put long word in eval stk */

int	sos;
long	val;
{

	*(long *)(evalstk + sos) = val;
	}
/* 
.SH */

/***  variable lookup  ***/


varlookup ( varstr )

/* given var name, look-up var & return vartable index, or -1 if not found */

char	*varstr;
{
	int	i;

	if (dbug)
		printf( "varlookup: target var is >%s<\n", varstr );
	for ( i=0; i<348 ; i++ ) {
		if (dbug)
			printf( "varlookup: >%s<\n", vtab[i].vname);
		if ( vtab[i].vname[0] == '\0' )  break ;
		if ( strcmp( varstr, vtab[i].vname ) == 0 )
			return( i );
		}
	errmsg( "Var not found" );
	return( -1 );
	}


getvartyp()

/* get varname from input. 
	Return type in char
*/
{
	char	c;

	gettkn( -1 );
	c = cmdline[clptr];		/* next char after name */
	if ( c == '%' ) {
		clptr++;
		strcat( token.str, "%" );
		return( 'J' );
		}
	if ( c == '$' ) {
		clptr++ ;
		strcat( token.str, "$" );
		return( 'A' );
		}
	else  return( 'L' );
	}


getvaros ( ix )

/* given index into var table, return stack offset of var desc */

int	ix;
{
	unsigned	rval;

	rval = vtab[ix].voffset ;		/* offset in var table */
	if (dbug)
		printf( "getvaros: ix, os = %s %s\n", numstr(ix),numstr(rval) );
	return( rval );
	}
/* 
.SH */

/***  array & string descriptors  ***/


getades ( ix )

/* given index into evalstack, build an array desc from eval stack */

int	ix;
{
	int	i, j;

	ades.adata.l = getstkw( ix );
	ades.type = getstkw( ix+2 );
	ades.amaxsiz = getstkw( ix+4 );
	ades.numdim = getstkw( ix+6 );
	arydim1 = getstkw( ix+8 );
	arydim2 = getstkw( ix+10 );
	if (dbug) {
		printf( "getades: data ptr, maxsiz, numdim = %s %d %d\n",
		numstr(ades.adata.l), ades.amaxsiz, ades.numdim );
		printf( "getades: dims are %d %d\n", arydim1, arydim2 );
		}
	}

getsdes ( ix )

/* given index in eval stk, get a string desc */

int	ix;
{
	int	x;

	sdes.pdata = getstkw( ix );
	sdes.pcurlth = getstkw( ix+2 );
	sdes.pmaxlth = getstkw( ix+4 );
	}

putsdes ( ix )

/* given eval stk index, store a $ desc */

int	ix;
{

	putstkw( ix, sdes.pdata );
	putstkw( ix+2, sdes.pcurlth );
	putstkw( ix+4, sdes.pmaxlth );
	}

/* 
.SH */

/*** checks ***/

ltexists ( erflag )

/* chk existance of line table */

int	erflag;		/* show error msg if set */

{

	if ( ltfd < 0 ) {
		if ( erflag != 0 )
			errmsg( "Line Table not available" );
		return( FALSE );
		}
	else
		return( TRUE );
	}


stexists ( erflag )

/* chk existance of symbol table */

int	erflag;

{

	if ( stfd < 0 ) {
		if ( erflag != 0 )
			errmsg( "Symbol Table not available" );
		return( FALSE );
		}
	else
		return( TRUE );
	}


pmcall ()

/* Return TRUE if this process was invoked by a p-machine call. */
{

	return( TRUE );		/*  <<< patch >>>  */
	if ( caller == PMACH )
		return( TRUE );
	else {
		errmsg( "Command not allowed with dump file" );
		return( FALSE );
		}
	}
/* 
.SH */

/*** other routines ***/

cnvangle(source)
char	*source;
{
	char	buf[600];
	register char	*cptr,*origsrc;
	char	*sptr;
	int	i,j,l;

	origsrc = source;
	cptr = buf;
	while (*source != '\0') {
		if (*source == '<') {
			sptr = source + 1;	/* skip < */
			sscanf(sptr,"%d",&l);
			printf("value in brackets = %d\n",l);
			for(; *sptr >= '0' && *sptr <= '9'; ++sptr)
				;
			printf("*sptr = %c\n",*sptr);
			if (*sptr != '>' || l > 256)
				*cptr++ = *source++; /* move < over */
			else {
				*cptr++ = (char)l;   /* put byte in string */
				source = sptr + 1;    /* skip > */
				}
			} 
		else
			*cptr++ = *source++;
		}

	j = cptr - buf;  /* figure out new size */

	for (i = 0,cptr = buf; i < j; ++i)
		*origsrc++ = *cptr++;
	*origsrc = '\0'; /* null terminate string */
	return(j);
	}

