/************************************************************************
*
*
*	Name:  debscan.c
*
*	Description:  Debugger - scanner and I/O routines, and error fns.
*
*
*	History:
*	Date		By		Comments
*
*	05/05/83	waf
*	05/13/83	waf		cmdcmp() to allow cmd abbreviations.
*	06/23/83 	mas		changed cmdcmp() to always look at at least 2 chars
*					before matching.
*						Also changed gettoken() function to check length
*					of string to keep from overflowing token.str
*	06/27/83 mas		changed command line to 512 bytes and added checking
*					to getcmd() to limit it to that.
*	10/11/83	waf		Changed cmdcmp() to allow *minimum* # chars in a cmd
*					abbreviation. Can be overridden with MINCHAR definition.
*	10/25/83	waf		Added uc_cmd() to convert cmd line to all upper case.
*	11/04/83	waf		gettkn() - Added arg for chk'ing token type.
*						Added errmsg(), error(), syntax().
*	03/09/84	waf		Added chk_eol().
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*g**********************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

10/25/83	waf
	The uc_cmd() fn is called after the '!' cmd line prefix is chk'ed.
  If the '!' is used, the cmd line must not be converted to upper case.

11/4/83		waf
	Note - Unary '+' is not allowed in a numeric expression (gets confused
  in '300+1' line# format).


.SH*/
#include	"debug.h"
#include	"ctype.h"


gettkn ( type ) 

int	type;	/* if >=0, type of token should match value of 'type' */

/*		Get next tkn from command line.

	Ret:	<retval>	= type of next token.
			token		= token.

	Assumes clptr points to next char.

	Notes -
		> Unary '+' not supported.
*/
{
	register char	c;
	int	ptr;
	long	val;
	int	x;
	int	sgn;


	token.nval = -1 ;
	token.str[0] = '\0' ;

	/* skip leading ' 's */
	while ( (c=cmdline[clptr++]) == ' ' ) ;

	if ( c == '\0' )
		/* End of Line */
		token.typ = EOLN ;

	else if ( c >= 'A' && c <= 'Z' ) {
		/* var */
		token.str[0] = c ;
		ptr = 1 ;
		for (;;)
			if ( (c=cmdline[clptr++]) >= 'A' && c <= 'Z' )
				token.str[ptr++] = c ;
			else if ( c >= '0' && c <= '9' )
				token.str[ptr++] = c ;
			else {
				clptr-- ;
				break ;
				}
		token.str[ptr] = '\0' ;
		token.typ = STR ;
		}

	else if ( c == '+' || c == '-' ) {
		/* signed number or char */
		if ( c == '+' )
			goto other;		/* unary + not currently allowed */
		sgn = (c == '-')? -1 : 0 ;
		c = cmdline[clptr++];	/* get next char */
		if ( c >= '0' && c <= '9' ) {
			/* signed number */
			gettkn( NUM );
			if ( sgn  )
				token.nval = -token.nval ;
			}
		else {
			/* char */
			goto other;
			}
		}

	else if ( c >= '0' && c <= '9' ) {
		/* number */
		val = c - '0' ;
		while ( (c=cmdline[clptr]) >= '0' && c <= '9' ) {
			val = (val * 10) + (c - '0');
			clptr++ ;
			}
		token.nval = val ;
		token.typ = NUM ;
		}

	else if ( c == '"' ) {
		/* string literal */
		for (x=0; (c=cmdline[clptr++]) != '"' && x < 511; ++x)
			token.str[x] = c;
		token.str[x] = '\0' ;
		token.typ = STRLIT ;
		}

	else {
other:	token.typ = OTHER ;
		token.nval = c ;
		token.str[0] = c ;
		token.str[1] = '\0' ;
		}

	if (dbug) {
		printf( "\ngettkn: type = %d\n", token.typ );
		printf( "gettkn: ret $ =  >%s<\n", token.str ) ;
		printf( "gettkn: nval = %D\n", token.nval );
		}

	/* chk type */
	if ( type >= 0 )  {		/* if type wanted was specified */
		if ( token.typ != type ) {		/* type scanned is not type wanted */
			/* types not exactly equal, chk for 'compatable' types */
			if ( type == PNUM ) {	/* pos number */
				if ( token.typ != NUM || token.nval < 0L )
					syntax() ;
				}
			else if ( type == STR )		/* string - allow string literal */
				if ( token.typ != STRLIT )
					syntax();
			else
				syntax() ;
			}
		}

	return( token.typ ) ;
	}
/*
*/


#include <stdio.h>

getcmd ( )

/* get input cmd line */
{
	int	x;

	cmdline[0] = '/0';
	clptr = 0;
	fgets( cmdline,512,(FILE *)stdin ) ;
	for (x=0; cmdline[x] != '\0' && cmdline[x] != '\n'; ++x)
		;
	cmdline[x] = '\0';
	if ( cmdline[0] == '/0' )  return( -1 );
	return( 0 );
	}


uc_cmd()		/* Convert cmd line to upper case */
{
	register char	*ptr;
	register char	c;

	for ( ptr = cmdline ; *ptr != '\0' ; ) {
		c = *ptr ;
		if (c == '"') {

			/* str literal */
			ptr++ ;
			while ( *ptr != '"' && *ptr != '\0' )
				ptr++ ;
			if ( *ptr == '\0' )
				syntax();
			}

		else {
			if ( islower( *ptr ) )
				*ptr = toupper( *ptr );
			}

		ptr++ ;
		}
	}


#define	MINCHAR	1	/* minimum # chars allowed in an cmd abbreviation */

/* list of 1st letter of cmds and minimum # chars in an abbreviation
   of a command with that first letter.
   Words in parens are cmd objects (e.g. 'locks' in 'dump locks').
   Their position makes them unique from commands. */
static	char	cmdchar[52] = {
	'A', '\1',		/* ABORT, (ALL) */
	'B', '\2',		/* BREAK, BASE */
	'C', '\2',		/* CLEAR, CON */
	'D', '\1',		/* DUMP */
	'E', '\1',		/* ERR */
	'F', '\1',		/* (FILES) */
	'G', '\1',		/* GOTO, (GF) */
	'H', '\1',		/* HELP */
	'I', '\0',
	'J', '\0',
	'K', '\0',
	'L', '\2',		/* LET, (LOCKS), (LT) */
	'M', '\0',
	'N', '\0',
	'O', '\0',
	'P', '\1',		/* PMD */
	'Q', '\0',
	'R', '\0',
	'S', '\3',		/* STOP, STATS, STEP, (STK) */
	'T', '\1',		/* TRACE */
	'U', '\1',		/* (UST) */
	'V', '\1',		/* (VARS) */
	'W', '\0',
	'X', '\0',
	'Y', '\0',
	'Z', '\0',
	};


cmdcmp( cwptr )

/* compare token.str to command in 'cmdword'.
	Return '0' if token.str is an acceptable abbreviation of cmdword. */

char	*cwptr;		/* ptr to (one word) cmd */
{
	register int	i;
	register char	*cmdword;

	cmdword = cwptr ;		/* use reg var */

	/* chk 1st chars of cmdword and command */
	if ( token.str[0] != cmdword[0] )
		return( -1 );

	/* chk len(cmdword) <= len(cmd) */
	if ( strlen(token.str) > strlen(cmdword) )
		return( -1 );

	/* chk cmdchar entry for 1st char of cmd */
	for ( i = 0 ; i < 50 ; i += 2 ) {
		if ( cmdchar[i] == cmdword[0] ) {

			/* chk for unique abbreviation */
			i = (int) cmdchar[i+1] ;
			if ( i < MINCHAR )
				i = MINCHAR ;
			if ( strlen( token.str ) < i ) {
				/* command abbrev. not unique */
				strcpy( token.str, "*bad*" );		/* only one error msg */
				error( "Illegal cmd abbreviation" );
				}
			break;
			}
		}

	/* compare (possibly truncated) cmd str to input command word */
	/* cmd str must match cmd string until end of cmd str */
	for ( i = 0 ; i < strlen(token.str) ; i++ )
		if ( token.str[i] != cmdword[i] )
			return( -1 );		/* no match */

	if (0)
		printf("cmdcmp: truned cmd = >%s<\n", token.str );

	return( 0 );		/* match */
	}



char	*trun( str, n )

/* truncate str at char # n */

char	*str;
int	n;
{

	strcpy( trunbuf, token.str );		/* put str in buff */
	trunbuf[n] = 0 ;		/* truncate */
	return( trunbuf );
	}



chk_eol ()

/* Check to see if scanner is at end of command line.
   Report error if it isn't.
*/
{


	if ( gettkn(-1) == EOLN )
		return(TRUE) ;
	else
		error("Cmd error") ;
	
	}

		/**  Exception routines  **/


error ( msg )		/* Show error message and abort cmd */
char	*msg;
{
	errmsg( msg );
	longjmp( errenv, 1 );
	}


syntax ()			/* Report syntax error */
{
	errmsg( "Syntax error" );
	longjmp( errenv, 2 );
	}


errmsg ( msg )		/* Show error message */
char	*msg;
{

	if ( BELL )  putchar( '\7' );
	printf( "  * %s *\n", msg );
	}
