/*************************************************************************
*
*
*	Name:  debbp.c
*
*	Description:  Debugger - set/reset breakpoints.
*
*
*	History:
*	Date		By		Comments
*
*	4/14/83	waf
*	11/15/83	waf		Chk for STMTX p-code before inserting BREAK p-code.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communications Assoc.
*
*************************************************************************
* BB/Xenix Runtime Module */




/*  Notes -

> Chk for multiple statements with the same offset ?

11/15/83	waf
	Some statements, such as an 'ELSE' statement, do not have an STMTX as
  the first p-code. A BREAK p-code can not be inserted at the beginning
  of these lines, because code in this module does not save the p-code
  which was written over by the BREAK (it is assumed it was an STMTX).

*/


#include	"debug.h"
#include	"/bb/include/opcodes.h"

/*
.SH */

debbreak ()

/* BREAK commands */

{
	register int	x,i,n;

	if ( ltexists(1) == FALSE )
		return( -1 );
	gettkn( -1 );
	if ( strcmp( token.str, "?" ) == 0 ) {

		/* Show all break points */
		sohead();
		for ( i = 1 ; i < ltnent ; i++ ) {
			x = getpcode( linetbl[i].pcoffset );
			if ( x == BREAK )
				showlo( i );
			}
		}

	else if ( strcmp( token.str, "ALL" ) == 0 ) {

		/* Set breaks at each stmt */
		n = 0 ;
		ltloop(1) {
			x = getpcode( linetbl[ltix].pcoffset );
			if ( x != STMTX )
				continue ;		/* can only break at STMTX */
			putpcode( linetbl[ltix].pcoffset, BREAK );
			n++ ;
		}
		printf( "  %d breakpoint(s) set\n", n );
		}

	else {

		/* Set break point at line# */
		x = stmt_os(-1);
		i = getpcode(x);
		if ( i == STMTX ) {
			putpcode( x, BREAK );
			showso( x );
			}
		else
			if ( i != BREAK )
				error( "Can not break at that line" );
		}

	return( 0 );
	}


debclear ()

/* CLEAR commands */

{
	int	x,n,i;
	int	ptr,ix;
	int	varos,varix;
	char	vartype;

	if ( ltexists(1) == FALSE )
		return( -1 );
	gettkn( -1 );
	if ( strcmp( token.str, "ALL" ) == 0 ) {

		/* Clear all break points */
		n = 0 ;
		ltloop(1) {
			x = getpcode( linetbl[ltix].pcoffset );
			if ( x == BREAK ) {
				putpcode( linetbl[ltix].pcoffset, STMTX );
				n++ ;
				}
			}
		printf( "  %d breakpoint(s) cleared\n", n );
		}

	else {

		/* Clear a breakpoint */
		x = stmt_os(-1);
		if ( getpcode( x ) == BREAK ) {
			putpcode( x, STMTX );
			showso( x );
			}
		}

	return( 0 );
	}
