/*************************************************************************
*
*
*	Name:		program.c
*
*	Description:	compile a main program
*
*	History:
*	Date		By	Comments
*
*	11/30/83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "label.h"
#include "vartab.h"
#include "symbols.h"

int	lineno, lstlineno;
int	errcnt;
unsigned pc;
unsigned fcodepc, ldatapc;
unsigned maxsize;

/* program := decls? block* EOF
*/
program()
{
   lstlineno = 0;
   fcodepc = 0; ldatapc = 0;
   argsym[0] = 1;
   pinit();
   nextline();
   decls();
   makelabel(0,limp);
   while (token != EOFT) block();
   pend();
   if (errcnt != 0) exit(-1);
}

/* block := IF if-block
	  | FOR for-block
          | %SIZE equals NUMLIT
	  | stmt
*/
block()
{
   switch (token) {
case TIF:
      if (fcodepc == 0) fcodepc = pc;
      gettoken();
      ifblock();
      break;
case TFOR:
      if (fcodepc == 0) fcodepc = pc;
      gettoken();
      forblock();
      break;
case TSIZE:
      gettoken();
      if (token == EQUALS) gettoken();
      else synerr("= expected.");
      if (token == NUMLIT) {
	 maxsize = value;
	 gettoken();
      }
      else synerr("Numeric constant required.");
      break;
default:
      if (fcodepc == 0) fcodepc = pc;
      stmt();
      break;
   }
}

/* ifblock := IF relexp thengo eoln block* ( ELSE eoln block* )? END IF
	    | IF relexp thengo if-tail
*/
ifblock()
{
   unsigned tjmp, fjmp;

   makelabel(lineno,limp);
   genop(STMTX);
   relexp();
   thengo();
   if (token == EOLN) {
      fjmp = genJMP(JMPF,-1);
      nextline();
      while (token != TELSE && token != TENDIF && token != EOFT) block();
      if (token == TELSE) {
	 makelabel(lineno,limp);
	 tjmp = genJMP(JMP,-1);
	 jmppatch(fjmp,pc);
	 nextline();
	 while (token != TENDIF && token != EOFT) block();
	 fjmp = tjmp;
      }
      if (token == TENDIF) {
	 makelabel(lineno,limp);
      } else synerr("Missing END IF");
      jmppatch(fjmp,pc);
   } else
      iftail();
   nextline();
}

/* forblock := FOR numadr equals numexp TO numexp ( STEP numexp )? eoln
	       block* NEXT numadr
*/
forblock()
{
   unsigned ljmp;
   int ltype, rtype;
   struct VTAB *forvar, *nxtvar;

   makelabel(lineno,limp);
   genop(STMTX);
   ltype = smpadr(&forvar);
   if (token == EQUALS) gettoken();
   else synerr("= expected");
   fixtos(ltype,numexp(ltype));
   if (token == TTO) gettoken();
   else synerr("TO expected");
   fixtos(ltype,numexp(ltype));
   if (token == TSTEP) {
      gettoken();
      fixtos(ltype,numexp(ltype));
   } else {
      switch (ltype) {
      case typeJ:
	 genLDCJ(1);
	 break;
      case typeL:
	 genLDCL(1L);
	 break;
      default:
	 synerr("Invalid FOR loop variable");
      }
   }
   ljmp = genJMP(FORJ+ltype,-1);
   if (token != EOLN) synerr("End of line expected");
   nextline();
   while (token != TNEXT && token != EOFT) block();
   if (token == TNEXT) {
      makelabel(lineno,limp);
      genop(STMTX);
      gettoken();
      rtype = smpadr(&nxtvar);
      if (forvar != nxtvar) synerr("NEXT variable does not match FOR variable");
      genop(NXTJ+ltype);
   } else synerr("FOR without matching NEXT");
   jmppatch(ljmp,pc);
   nextline();
}

/* stmt := DATA data-stmt
	 | DEF def-stmt
	 | END
	 | REM rem-stmt
	 | RFORM rform-stmt
	 | eoln
	 | imp-stmt
*/
stmt()
{

   switch(token) {
case TDATA:
      datastmt();
      break;
case TDEF:
      makelabel(lineno,limp);
      genop(STMTX);
      gettoken();
      defstmt();
      break;
case TEND:
      makelabel(lineno,limp);
      genop(STMTX);
      gettoken();
      genop(PEND);
      break;
case TREM:
      makelabel(lineno,lrem);
      remstmt();
      break;
case TRFORM:
      rformstmt();
      break;
case EOLN:
      break;
default:
      makelabel(lineno,limp);
      genop(STMTX);
      impstmt();
      break;
   }
   if (token != EOLN) synerr("Statement does not end properly.");
   nextline();
}

datastmt()
{
   unsigned jmp;
   makelabel(lineno,ldata);
   genop(STMTX);
   jmp = genJMP(DATA,-1);
   if (ldatapc != 0) jmppatch(ldatapc,pc);
   do {
      gettoken();
      switch (token) {
case MINUS:
case NUMLIT:
	 numcon(typeL);
	 break;
case STRLIT:
	 strcon();
	 break;
default:
	 goto exit;
      }
   } while (token == COMMA);
exit:
   ldatapc = genJMP(JMP,-1);
   jmppatch(jmp,pc);
}

defstmt()
{
   int jmp;

   if (token == FNCNAM) {
      genI(DEFFN,symtype); jmp = emitJ(-1);
      gettoken();
      if (token == LPAREN) gettoken();
      else synerr("( expected");
      if (token == NUMVAR) {
	 strncpy(argsym,symbol,8);
	 genLDA(LDA,0,-8); /* address of return value */
	 gettoken();
	 if (token == RPAREN) gettoken();
	 else synerr(") expected");
	 if (token == EQUALS) gettoken();
	 else synerr("= expected");
	 sametype(typeL,numexp(typeL));
	 genop(STIL);
      }
      genJ(RETFN,4);
      jmppatch(jmp,pc);
   } else
      synerr("Function name expected");
   argsym[0] = 1;
}

remstmt()
{
   token = EOLN;
}

rformstmt()
{
   unsigned jmp;
   char *s;

   makelabel(lineno,lrform);
   genop(STMTX);
   jmp=genJMP(RFORM,-1);
   get_rlit();
   genLDCA(symbol,symlen);
   token = EOLN;
   jmppatch(jmp,pc);
}
