/*************************************************************************
*
*
*	Name:		impstmt.c	
*
*	Description:	Imperative statements
*
*	History:
*	Date		By	Comments
*
*	07/12 /83	jle
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright 1983 by Technical Analysis Corporation.
*
*************************************************************************
* BB/Xenix Compiler Module */




/*  Notes -

*/

#include "tokens.h"
#include "opcodes.h"
#include "label.h"
#include "vartab.h"
#include "symbols.h"
#include "/bb/include/ptype.h"

int	lineno, lstlineno;
extern	gswd, gswt;
unsigned pc, fnspc;

/* imp-stmt := BLOCK blkio-stmt
	  | BREAK
	  | BYE
	  | ( CHAIN | SWAP ) chain-stmt
	  | CLOSE close-stmt
	  | DEBUG debug-stmt
	  | DELAY procall
	  | DELETE del-stmt
	  | DELREC procall
	  | DIM dim-stmt
	  | EXTRACT procall
	  | GETREC procall
	  | GOTO go-stmt
	  | GOSUB go-stmt
	  | IF if-stmt
	  | ( INPUT | TINPUT) input-stmt
	  | ( KADD| KDEL | KFIND | KNEXT ) k-stmt
	  | LOCK lock-stmt
	  | LOPEN lopen-stmt
	  | LREAD lread-stmt
	  | LWRITE lwrite-stmt
	  | NEW
	  | ON on-stmt
	  | OPEN open-stmt
	  | PACK pack-stmt
	  | POSITION posfilstmt
	  | PRINT print-stmt
	  | ( QADD | QSUB | QMUL | QDIV | QLOAD | QSTORE ) procall
	  | RANDOMIZE
	  | READ read-stmt
	  | RENAME rename-stmt
	  | REPLACE procall
	  | RESTORE rest-stmt
	  | RETURN
	  | SAVE procall
	  | ( STMA | STMB | STMC ) stmcall
	  | ( SCANWHILE | SCANUNTIL ) procall
	  | STOP
	  | STRPOS procall
	  | ( SCANWHILE | SCANUNTIL | EXTRACT ) procall
	  | SYSTEM procall
	  | TRACE trace-stmt
	  | UNLOCK procall
	  | UNPACK unpack-stmt
	  | VALUE procall
	  | WRITE write-stmt
	  | XCALL stmcall
	  | LET let-stmt
	  | let-stmt
*/

impstmt()
{
   int t;
   switch (token) {
case TBLOCK:
      gettoken();
      blkiostmt();
      break;
case TBREAK:
      gettoken();
      if (gswd) genop(SBREAK);
      break;
case TBYE:
      gettoken();
      genop(BYE);
      break;
case TCHAIN:
case TSWAP:
      chainstmt();
      break;
case TCLOSE:
      gettoken();
      closestmt();
      break;
case TDEBUG:
      gettoken();
      debugstmt();
      break;
case TDELETE:
      gettoken();
      delstmt();
      break;
case TDIM:
      dimstmt();
      break;
case TGOTO:
      gettoken();
      gostmt(JMP);
      break;
case TGOSUB:
      gettoken();
      gostmt(GOSUB);
      break;
case TIF:
      gettoken();
      ifstmt();
      break;
case TINPUT:
case TTINPUT:
      inputstmt();
      break;
case TKADD:
case TKDEL:
case TKFIND:
case TKNEXT:
      kstmt();
      break;
case TLOCK:
      lockstmt();
      break;
case TLOPEN:
      gettoken();
      lopenstmt();
      break;
case TLREAD:
      gettoken();
      lreadstmt();
      break;
case TLWRITE:
      gettoken();
      lwritestmt();
      break;
case TNEW:
      gettoken();
      genop(NEW);
      break;
case TON:
      gettoken();
      onstmt();
      break;
case TOPEN:
      gettoken();
      openstmt();
      break;
case TPACK:
      gettoken();
      packstmt();
      break;
case TPOSITION:
      gettoken();
      posfilstmt();
      break;
case TPRINT:
      prntstmt();
      break;
case TRANDOMIZE:
      gettoken();
      genop(RNDMZ);
      break;
case TREAD:
      gettoken();
      readstmt();
      break;
case TRENAME:
      gettoken();
      renamestmt();
      break;
case TRESTORE:
      gettoken();
      reststmt();
      break;
case TRETURN:
      gettoken();
      genop(RETSUB);
      break;
case TSTMA:
case TSTMB:
case TSTMC:
case TXCALL:
      stmcall();
      break;
case TSTOP:
      gettoken();
      genop(STOP);
      break;
case TDELAY:
case TDELREC:
case TXTRACT:
case TGETREC:
case TQADD:
case TQSUB:
case TQMUL:
case TQDIV:
case TQLOAD:
case TQSTORE:
case TREPLACE:
case TSAVE:
case TSWHILE:
case TSUNTIL:
case TSTRPOS:
case TSYSTEM:
case TUNLOCK:
case TVALUE:
      t = token;
      gettoken();
      procall(t,0);
      break;
case TTRACE:
      gettoken();
      tracestmt();
      break;
case TUNPACK:
      gettoken();
      unpackstmt();
      break;
case TWRITE:
      gettoken();
      writestmt();
      break;
case TLET:
      gettoken();
default:
      letstmt();
      break;
   }
}
   
/* chainstmt := ( CHAIN | SWAP ) strexp (thengo line-number)?
*/
chainstmt()
{
   int op;
   op = (token == TCHAIN) ? CHAIN : SWAP;
   gettoken();
   strexp();
   if (token != EOLN) {
      thengo();
      if (token == NUMLIT) {
	 genJ(op,(int) value);
	 gettoken();
      } else {
	 genJ(op,0);
      }
   } else {
      genJ(op,0);
   }
}

/* debugstmt := DEBUG ( ON | OFF )
*/
debugstmt()
{
   if (token == TON) {
      gettoken();
      if (gswd) genLDCJ(16);
   } else if (token == TOFF) {
      gettoken();
      if (gswd) genLDCJ(-1);
   } else {
      synerr("ON or OFF expected");
      if (gswd) genLDCJ(-1);
   }
   if (gswd) genop(DEBUG);
}

/* delstmt := errvar strexp
*/
delstmt()
{
   errvar();
   strexp();
   genop(DELETE);
}

/* errvar := ( numvar comma )?
*/
errvar()
{
   int type;
   if (token == NUMVAR) {
      type = numadr();
      genLDCJ(type);
      if (token == COMMA) gettoken();
      else synerr(", expected.");
   } else {
      genLDCL(0L);
   }
}

/* dimstmt := DIM dimvar ( comma dimvar )*
   dimvar  := numvar open subscript close
	    | strvar open number close
*/
dimstmt()
{
   struct vtab *p;
   do {
      gettoken();
      if (token == NUMVAR) {
	 p = findsym(symbol);
	 gettoken();
	 if (token == LPAREN || token == LBRACK) {
	    makevar(p,typeUNDF,subscript(1));
	 } else synerr("( expected");
	 genLDCJ(p->numsubs);
	 genJ(DIMJ+(p->vtype),p->voffset);
      } else if (token == STRVAR) {
	 p = findsym(symbol);
	 gettoken();
	 if (subscript(1) != 1) 
	    synerr("Wrong number of dimensions for string variable");
	 makevar(p,typeA,0);
	 genJ(DIMA,p->voffset);
      } else synerr("Varible name expected");
   } while (token == COMMA);
}

/* kstmt := numexp procall
	  | strexp procall
*/
kstmt()
{
   int t;
   t = token;
   gettoken();
   if (token == STRLIT || token == STRVAR) procall(t,1);
   else procall(t,0);
}

/* letstmt := numadr equals numexp
	    | numadr comma mulnlet
	    | strvar equals strletexp
	    | strvar comma mulslet
*/
letstmt()
{
   int ltype, rtype;
L:
   if (token == NUMVAR) { 
      ltype = numadr();
      if (token == EQUALS) {
	 gettoken();
	 rtype = numexp(ltype);
      } else if (token == COMMA) {
	 gettoken();
	 rtype = mulnlet();
      } else synerr("= expected");
      numstore(ltype,rtype);
   } else if (token == STRVAR) {
      ltype = strvar();
      if (token == EQUALS) {
	 strletexp();
	 genop(UPCL);
      } else if (token == COMMA) {
	 gettoken();
	 mulslet();
	 genJMP(CALLFS,fnspc);
      } else synerr("= expected");
   } else synerr("Unknown statement type");
   if (token == BSLASH) {
      gettoken();
      goto L;
   }
}

/* mulnlet := numadr ( comma numadr )* equals numexp
*/
mulnlet()
{
   int ltype, rtype;
   if (token == NUMVAR) { 
      ltype = numadr();
      if (token == EQUALS) {
	 gettoken();
	 rtype = numexp(ltype);
      } else if (token == COMMA) {
	 gettoken();
	 rtype = mulnlet();
      } else synerr("= expected");
   } else {
      synerr("numeric variable expected");
      rtype = typeL;
   }
   genop(DPRJ+rtype);
   numstore(ltype,rtype);
   return rtype;
}

/* strletexp  := strletitem ( comma strletitem )*
   strletitem := string-function open explist close | expression
*/
strletexp()
{
   int rtype;
   do {
      gettoken();
      if (token >= TCHR && token <= TUCM) {
	 funcall();
      } else {
	 rtype = expression(typeJ);
         if (rtype == typeA) genop(MOVS);
	 else genop(STRJ+rtype);
      }
   } while (token == COMMA);
}

/* mulslet := strvar ( comma strvar )* equals strletexp
*/
mulslet()
{
   unsigned skppc;

   if (token == STRVAR) {
      strvar();
      if (token == EQUALS) {
	 skppc = genJMP(JMP,-1);
	 fnspc = pc;
	 genLDD(LDD,0,typeA,-8);
	 strletexp();
	 genop(UPCL);
	 genJ(RETFN,sizeof (STRDES));
	 jmppatch(skppc,pc);
      } else if (token == COMMA) {
	 gettoken();
	 mulslet();
      } else synerr("= expected");
   } else synerr("string variable expected.");
   genJMP(CALLFS,fnspc);
}

/* lockstmt := numexp comma ( strexp procall | numexp procall )
*/
lockstmt()
{
   gettoken();
   fixtos(typeJ,numexp(typeJ));
   if (token == COMMA) gettoken();
   else synerr(", expected");
   if (token == STRLIT || token == STRVAR) procall(TLOCK,1);
   else procall(TLOCK,0);
}

/* packstmt := PACK (strexp | line-number) comma strvar (comma expression)*
*/
packstmt()
{
   int type;
   struct PATCH p;
   struct VTAB *v;

   if (token == NUMLIT) {
      p.ptype = lrform;
      p.pval = value;
      p.ppc = genJMP(MAKDL,-1);
      addpatch(&p);
      gettoken();
   } else {
      strexp();
   }
   if (token == COMMA) gettoken();
   else synerr(", expected.");
   strvar();
   genop(PAKSET);
   while (token == COMMA) {
      gettoken();
      if (token == NUMVAR) {
	 v = findsym(symbol);
	 if (v->numsubs == 0) {
	    type = numexp(typeJ);
	    genop(PAKJ+type);
	 } else {
	    genJ(LDAV,v->voffset);
	    type = numadr();
	    genop(PAKD);
	 }
      } else {
	 type = expression(typeJ);
	 if (type == typeA) genop(PAKA);
	 else genop(PAKJ+type);
      }
   }
   genop(PAKEND);
}

/* unpackstmt := UNPACK (strexp | line-number) comma strexp (comma (numvar | strvar) )*
*/
unpackstmt()
{
   int type;
   struct VTAB *v;

   if (token == NUMLIT) {
      labref(MAKDL,(int) value,lrform);
      gettoken();
   } else {
      strexp();
   }
   if (token == COMMA) gettoken();
   else synerr(", expected.");
   strexp();
   genop(UPKSET);
   while (token == COMMA) {
      gettoken();
      if (token == STRVAR) {
	 strvar();
	 genop(UPKA);
      } else if (token == NUMVAR) {
	 v = findsym(symbol);
	 if (v->numsubs == 0) {
	    type = numadr();
	    genop(UPKJ+type);
	 } else {
	    genJ(LDAV,v->voffset);
	    type = numadr();
	    genop(UPKD);
	 }
      } else
	 synerr("Variable expected.");
   }
   genop(PAKEND);
}

/* renamestmt := RENAME errvar strexp comma strexp
*/
renamestmt()
{
   errvar();
   strexp();
   if (token == COMMA) gettoken();
   else synerr(", expected.");
   strexp();
   genop(RENAME);
}

/* reststmt := RESTORE number?
*/
reststmt()
{
   if (token == NUMLIT) {
      labref(RESTOR,(int) value,ldata);
      gettoken();
   } else
      genJMP(RESTOR,7);
}

/* gostmt := GOTO number
	   | GOSUB number
*/
gostmt(op)
int op;
{
   int i;

   if (token == NUMLIT) {
      labref(op,(int) value,limp);
      gettoken();
   } else synerr("Statement number expected");
}

/* ifstmt := IF relexp thengo if-tail
*/
ifstmt()
{
   relexp();
   thengo();
   iftail();
}

/* iftail := ( line-number | imp-stmt )
	     ( ELSE ( GOTO? line-number | imp-stmt ) )?
*/
iftail()
{
   int fjmp, tjmp;

   if (token == NUMLIT) {
      gostmt(JMPT);
      fjmp = 0;
   } else {
      fjmp = genJMP(JMPF,-1);
      impstmt();
   }
   if (token == TELSE) {
      if (fjmp != 0) {
	 tjmp = genJMP(JMP,-1);
	 jmppatch(fjmp,pc);
      }
      gettoken();
      if (token == TGOTO) gettoken();
      if (token == NUMLIT) gostmt(JMP);
      else impstmt();
      if (fjmp != 0) jmppatch(tjmp,pc);
   }  else 
      if (fjmp != 0) jmppatch(fjmp,pc);
}

/* on-stmt := ON ( ERR | IKEY ) onerrtail 
	    | ON numexp thengo ( linelist | GOSUB linelist )
 onerrtail := thengo (line-number | INT | imp-stmt)
  linelist := line-number ( comma line-number )*
*/
onstmt()
{
   struct PATCH p;
   int lab[100], ilab, nlabs, ltype, op;

   switch (token) {
case TERR:
case TIKEY:
      op = (token==TERR)? ONERR : ONINT;
      gettoken();
      thengo();
      if (token == TINT) {
	 genJ(op,0);
	 gettoken();
      } else {
	 p.ppc = genJMP(op,-1);
	 if (token == NUMLIT)
	    gostmt(JMP);
	 else {
	    if (gswt) synerr("Illegal statement with option -t");
	    impstmt();
	    if (op == ONERR) genop(RETERR);
	    else genop(RETINT);
	 }
	 jmppatch(p.ppc,pc);
      }
      break;
default:
      ltype = numexp(typeJ);
      fixtos(typeJ,ltype);
      thengo();
      if (token == TGOSUB) {
	 gettoken();
	 op = ONGS;
      } else
	 op = ONGO;
      if (token != NUMLIT)
	 synerr("GOTO or GOSUB expected");
      nlabs = 0;
      while (token == NUMLIT) {
	 lab[nlabs++] = value;
	 gettoken();
	 if (token == COMMA) gettoken();
      }
      genI(op,nlabs);
      for (ilab = 0; ilab < nlabs; ilab++) {
	 p.ppc = emitJ(-1);
	 p.pval = lab[ilab];
	 p.ltype = limp;
	 addpatch(&p);
      }
      break;
   }
}

stmcall()
{
   int t1, t2;
   t1 = token;
   gettoken();
   if (token == NUMLIT) {
      t2 = value;
      gettoken();
      if (token == COMMA) gettoken();
      procall(t1,t2);
   } else
      synerr("Constant required.");
}

/* thengo := GOTO line-number
	   | THEN GOTO line-number
	   | THEN line-number
	   | THEN 
	   | {not a line-number or eoln}
returns with token = NUMLIT if any of first three forms found
*/
thengo()
{
   if (token == TGOTO) {
      gettoken();
      if (token != NUMLIT) synerr("Statement number expected");
   } else if (token == TTHEN) {
      gettoken();
      if (token == TGOTO) {
	 gettoken();
	 if (token != NUMLIT) synerr("Statement number expected");
      }
   } else if (token == NUMLIT || token == EOLN) synerr("THEN expected.");   
}

/* tracestmt := TRACE ON ( FILE filespec )?
	      | TRACE OFF
*/
tracestmt()
{
   if (token == TON) {
      gettoken();
      if (token == TFILE) {
	 if (gswd) filespec("j");
	 else token = EOLN;
      } else
	 if (gswd) genLDCJ(16);
   } else if (token == TOFF) {
      gettoken();
      if (gswd) genLDCJ(-1);
   } else {
      synerr("ON or OFF expected");
      if (gswd) genLDCJ(-1);
   }
   if (gswd) genop(TRACE);
}
