/*
	Copyright 1983
	Alcyon Corporation
	8716 Production Ave.
	San Diego, CA  92121

*/

char *version = "@(#)teksendc68.c	2.1	7/10/84";

/**
 *  this program reads a c.out format binary file and converts
 *  it to the extended Tekhex load format acceptable by 
 *  the Tektronic 8560 development system
 *  and then sends it down the standard output file
**/

#ifdef MC6800
#	include <cout.h>
#	include <sendc68.h>
#endif

#ifdef VAX11
#	include <c68/cout.h>
#	include <c68/sendc68.h>
#endif

#ifdef PDP11
#	include <c68/cout.h>
#	include <c68/sendc68.h>
#endif

#define RBLEN 32	/* number of bytes per data block */
#define DBLEN 256
#define SBLEN 64

long loctr, pgstart, pgsize;
short fout, ofd, pflg, syno, noclear, blklen, sectdef, debug;
char cksum, *ofn;

char sectname[] = "memory";
short bcnt = RBLEN;
char databuf[DBLEN];
char *dptr = databuf;
char *calledby;

struct symtab symbuf;
struct hdr2 couthd;
struct buf *file, filbuf;

char *getsym();

main(argc,argv)
int argc;
char **argv;
{
	long l, l1;
	short word, i;

	file = &filbuf;
	calledby = *argv++;
	if (argc-- < 2) {
		printf("Usage: %s objectfile [outputfile]\n",calledby);
		exit(-1);
	}

	if(**argv == '-') {
		noclear++;
		i++;
		argv++;
		argc--;
	}

	openfile(*argv++);
	if(argc > 1) {
		ofn = *argv;	/* tty device name */
		if((ofd=creat(ofn,0666)) < 0)
			fatal("unable to create %s\n", ofn);
	}
	else
		ofd = dup(1);	/* standard output file */

	fout = ofd;		/* use buffered output */
	l1 = couthd.ch_tsize;
	loctr = couthd.ch_entry;
	pgstart = loctr;
	pgsize = couthd.ch_tsize + couthd.ch_dsize + couthd.ch_bsize;
mloop:
	for (l = 0; l < l1; l += 2) {
		lgetw(&word,file);
		outword(word);
		loctr += 2;
	}
	if(couthd.ch_magic==MAGIC1) {
		while(bcnt != RBLEN)	/* fill out the last S1 buffer */
			outword(0);
		loctr = couthd.ch_dstart;
	}
	l1 = couthd.ch_dsize;
	for(l=0; l<l1; l+= 2) {
		lgetw(&word,file);
		outword(word);
		loctr += 2;
	}
	if(noclear==0) {
		if(couthd.ch_magic==MAGIC1) {
			while(bcnt != RBLEN)	/* fill out the last S1 buffer */
				outword(0);
			loctr = couthd.ch_bstart;
		}
		l1 = couthd.ch_bsize;		/* size of bss */
		while(l1 > 0) {
			outword(0);		/* clear the bss */
			l1 -= 2;
			loctr += 2;
		}
	}
	while(bcnt != RBLEN)	/* fill out the last S1 buffer */
		outword(0);
	flush();
	l1 = couthd.ch_ssize;	/* symbol table size */
	bcnt = SBLEN;
	while(l1>0) {
		getsym();	/* get one symbol entry */
		outsym();
		l1 -= OSTSIZE;
	}
	endsyblk();		/* last symbol block */
	termblk();
}

openfile(ap)
char *ap;
{
	register char *p;

	if (debug)
		printf("%s input file : [%s]\n",calledby,ap);
	p = ap;
	if( (file->fildes = open(p,0)) < 0 )
		fatal("unable to open %s\n",p);
	ifilname = p;	/* point to current file name for error msgs */
	readhdr();				/* read file header */
}

#define BADMAGIC(magic) (magic<EX_MAGIC || magic>EX_4KSTXT)
readhdr()
{
	if (getchd(file, &couthd) == -1) {
		printf("read error on: %s\n",ifilname);
		exit(-1);
	}
	if (debug) {
		printf("magic = %x\n",couthd.ch_magic);
		printf("tsize = %ld\n",couthd.ch_tsize);
		printf("dsize = %ld\n",couthd.ch_dsize);
		printf("bsize = %ld\n",couthd.ch_bsize);
		printf("ssize = %ld\n",couthd.ch_ssize);
		printf("stksize = %ld\n",couthd.ch_stksize);
		printf("entry = %ld\n",couthd.ch_entry);
		if (couthd.ch_magic == EX_ABMAGIC) {
			printf("dstart = %ld\n",couthd.ch_dstart);
			printf("bstart = %ld\n",couthd.ch_bstart);
		}
	}
	if (BADMAGIC(couthd.ch_magic))
		fatal("file format error: %s %x\n",ifilname,couthd.ch_magic);
}

outword(i)
int i;
{
	register char *p;

	if(bcnt==RBLEN) {	/* beginning of record */
		cksum = 0;
		dptr = databuf;
		if(loctr >= 0x10000L) {
			blklen = RBLEN*2 + 14;
			hexchr((short)'8');
			hexby((short)(loctr>>16));
		}
		else {
			blklen = RBLEN*2 + 10;
			hexchr((short)'4');
		}
		hexwd((short)loctr);
	}
	hexwd((short)i);
	bcnt -= 2;
	if(bcnt==0) {	/* end of record */
		putchar('%');
		outhexby(blklen);	/* block length */
		putchar('6');
		cksum += 6;
		outhexby(cksum);
		dumpdabuf();
		bcnt = RBLEN;
	}
}

hexwd(word)
int word;
{
	hexby((short)(word>>8));
	hexby(word);
}

hexby(c)
int c;
{
	c &= 0xff;
	outhex((c>>4)&017);
	outhex(c&017);
}

outhexby(c)
int c;
{
	c &= 0xff;
	putouthex((c>>4)&017);
	putouthex(c&017);
}

outhex(x)
int x;
{
	if(x>=0 && x<=9)
		*dptr = (x+'0');
	else if(x>=10 && x<=15)
		*dptr = (x-10+'A');
	else
		exit();
	gensum(*dptr++);
}

putouthex(x)
{
	register char ac;

	if(x>=0 && x<=9)
		putchar(ac=(x+'0'));
	else if(x>=10 && x<=15)
		putchar(ac=(x-10+'A'));
	else
		exit();
	gensum(ac);
}

delay()
{
	register i, j;

	for(i=0; i!= 012000; i++)
		j=0;
}

hexchr(ac)
int ac;
{
	*dptr++ = ac;
	gensum(ac);
}

dhexchr(ac)
int ac;
{
	*dptr++ = ac;
	gensum(ac);
	bcnt--;
}

gensum(ac)
char ac;
{
	register char c;

	c = ac;
	if(c>='0' && c<='9')
		cksum += c-'0';
	else if(c>='A' && c<='Z')
		cksum += c-'A'+10;
	else if(c>='a' && c<='z')
		cksum += c-'a'+40;
	else if(c=='.')
		cksum += 38;
	else if(c=='_')
		cksum += 39;
	else
		fatal("gensum invalid char: 0%o\n", c);
}

char *
getsym()
{
	register short i;
	register short *p;

	p = &symbuf;
	for (i = 0; i < (OSTSIZE/2); i++)
		*p++ = getw(&file);
}

outsym()
{
	register char *p, *p1;

	p = &symbuf;
	if(p->flags&SYXR)		/* register name */
		return;
	if(*p=='~' && *(p+1)=='~')
		return;					/* second function name */
	while(*p=='_' || *p=='~')
		p++;
/*  output one symbol */
	if(bcnt == SBLEN) {		/* first symbol on block */
		cksum = 0;
		dptr = databuf;
		p1 = sectname;
		dhexchr(sizeof sectname -1 + '0');
		while(*p1) {
			dhexchr(*p1++);
		}
		if(sectdef==0) {	/* define a section */
			sectdef++;
			dhexchr('0');		/* section definition */
			outval(pgstart);
			outval(pgsize);
		}
	}
	dhexchr('1');	/* global address */
	p1 = p;
	while(*p && p<&symbuf.name[8])
		p++;
	dhexchr(p-p1+'0');	/* symbol name length */
	while(p1 < p)
		dhexchr(*p1++);	/* output symbol name */
	outval(symbuf.vl1);	/* output symbol value */
	if(bcnt <= 0) {		/* end of one block */
		endsyblk();
	}
}

/*  output a symbol value */
outval(av)
long av;
{
	register char *p;
	register short i, j;
	char adchrs[8];

	p = adchrs;
	i = 0;
	while(av) {
		j = av&0xf;
		if(j<10)
			j += '0';
		else
			j += 'A'-10;
		av >>= 4;
		i++;
		*p++ = j;
	}
	if(p == adchrs) {
		i++;
		*p++ = '0';
	}
	dhexchr(i+'0');
	while(p > adchrs) {
		dhexchr(*--p);
	}
}

endsyblk()
{
	register char *p1;

	putchar('%');
	outhexby(SBLEN-bcnt+5);	/* block length */
	putchar('3');		/* block type */
	cksum += 3;
	outhexby(cksum);
	dumpdabuf();
	bcnt = SBLEN;
}

dumpdabuf()
{
	register char *p1;

	p1 = databuf;
	while(p1 < dptr)
		putchar(*p1++);
	putchar(015);		/* CR */
	putchar('\n');
	flush();
	delay();
}

termblk()
{

	putchar('%');
	bcnt = RBLEN;
	cksum = 0;
	dptr = databuf;
	outval(pgstart);
	outhexby(RBLEN-bcnt+5);
	putchar('8');
	cksum += 8;
	outhexby(cksum);
	dumpdabuf();
}

fatal(template,arg1,arg2,arg3,arg4)
char *template;
int arg1, arg2,arg3,arg4;
{
	printf("%s :",calledby);
	printf(template, arg1, arg2, arg3, arg4);
	exit(-1);
}
