
/*
	Copyright 1984
	Alcyon Corporation
	8716 Production Ave.
	San Diego, CA  92121

	@(#)test6.c	2.12	1/31/85

	Test #6, 4.7+ c68 ALCYON Compiler Test Program 
*/

char *version = "@(#)test6.c	2.11	1/30/85";

struct {
	char b0;
	struct {
		char b10;
		unsigned b11[3];
	} b1;
} a = {0x01, {0x07, {9,0xf,'.'}}};

struct {
	char x;
	unsigned y[2];
} b = { 1, { 2, 3 }};

struct one {
	char *p;
	int i;
};

struct two {
	struct one a;
	char align;		/* padding for this byte occurs at wrong time !!! */
	struct one c;
} xyz = {
	{"abc", 1},
	9,
	{"def", 2}
};

unsigned long ulong1, ulong2;
char *charp1, *charp2;

int enums;

main()
{
	char *ptra, *ptrb;
	long lsize;
	short ssize;
	register short *wp, *wp2;

	usign();
	test_a();
	test_b();
	stest_zero();
	stest_one();
	stest_two();
	test_c();
	ar_test();
	test_d();
	lsize = ptra-ptrb;			/* No Warning */
	ssize = ptra-ptrb;			/* Warning */
	ssize = (short)(ptra-ptrb);	/* No Warning */
	equiv(ptra-ptrb,ssize);		/* Warning */
		/* Bug 10 - via video, 31 may 1984 */
	wp2 = wp & 0xffff;			/* Warning */
	bfield();
	printf("0x80000000 == %ld = %ld\n",0x80000000,0x80000000/1);
	if (enums == 0)
		printf(">>>> Far Freaking Out <<<<\n");
	else
		printf(">>>> Tough Luck <<<<\n");
}

error(num)
int num;
{
	enums++;
	printf("error $%x\n",num);
}

usign()
{
	char x;
	unsigned char *memc, k[256];
	char ch, ch2;
	register long l1, l2;
	register unsigned long ul1, ul2;

		/* Signed/Unsigned Comparisons */
	l1 = -1; ul1 = -1;
	l2 = 5; ul2 = 5;
	if (l1 < l2 ) 		/* -1 < 5 signed */
		; else error(0x40);
	if (ul1 < ul2 ) 	/* -1 < 5 unsigned */
		error(0x41);
	if (l2 < l1 ) 		/* 5 < -1 signed */
		error(0x42);
	if (ul2 < ul1 ) 	/* 5 < -1 unsigned */
		; else error(0x43);
	l1 = 0x7fffffff; ul1 = 0x7fffffff;
	if (l1 < l2 ) 		/* 0x7fffffff < 5 signed */
		error(0x44);
	if (ul1 < ul2 ) 	/* 0x7fffffff < 5 unsigned */
		error(0x45);
	if (l2 < l1 ) 		/* 5 < 0x7fffffff signed */
		; else error(0x46);
	if (ul2 < ul1 ) 	/* 5 < 0x7fffffff unsigned */
		; else error(0x47);
	l1 = 0x8fffffff; ul1 = 0x8fffffff;
	if (l1 < l2 ) 		/* 0x8fffffff < 5 signed */
		; else error(0x48);
	if (ul1 < ul2 ) 	/* 0x8fffffff < 5 unsigned */
		error(0x49);
	if (l2 < l1 ) 		/* 5 < 0x8fffffff signed */
		error(0x4a);
	if (ul2 < ul1 ) 	/* 5 < 0x8fffffff unsigned */
		; else error(0x4b);

		/* Unsigned structure element offset tests */
	x = a.b0;
	if (x != 0x01) error(0x01);
	x = a.b1.b10;
	if (x != 0x07) error(0x02);
	x = a.b1.b11[0];
	if (x != 9) error(0x03);
	x = a.b1.b11[1];
	if (x != 0xf) error(0x04);
	x = a.b1.b11[2];
	if (x != '.') error(0x05);

		/* Unsigned char & unsigned long equivilency tests */
	charp1 = ulong1 = 0xff00ff00ff;
	charp2 = ulong2 = 0xfff0ff00ff;
	if (ulong1 > ulong2) error(0x06);
	if (charp1 > charp2) error(0x07);
	ch = 0x0f; ch2 = 0xff;
	if ((unsigned)ch > (unsigned)ch2) error(0x08);
	ulong1 = 0xf0000000; 
	ulong2 = 0xf00000;
	if (ulong2 >= ulong1) error(0x09);
	if ((unsigned long)0xf000f00 > (unsigned long)0xf000f000) error(0x0a);
	ulong1 = 1000000;
	ulong2 = 100000;
	if ((ulong1/ulong2) != 10) error(0x0b);

		/* Unsigned increment test */
	*memc = *(k + *memc);
		/* Unsigned divide of very large numbers */
	ul2 = 0x80000000;
	ul1 = 0x4000000; 
#ifdef LUDIVTST
	ul1 = ul2 / ul1;
	if (ul1 != 2) error(0x0c);
#endif
}

struct four_i_s {
	int a,b,c,d;
};

struct ss_test {
	int a1;
	struct four_i_s e[20];
	long f[20];
} str;

#define UNIX
#ifdef UNIX
#define abs(x) ((x) < 0 ? -(x):(x))
#define max(a,b) ((a) > (b) ? (a):(b))
#define min(a,b) ((a) <= (b) ? (a):(b))
int t = min(1,2);
#endif
#undef UNIX

test_a()
{
	char *b, *p, c;
	register int a;
	char v1 = 0x10;
	register int i, xsize, ysize;
	unsigned long ul_index;
	long l_index;
	int ar[10], x, y;

		/* Preprocessor ifdef/undef testing */
	xsize = 34; ysize = -34;
	i = min(xsize,ysize);
	if (i != -34) error(0x10);
	i = max(xsize,ysize);
	if (i != 34) error(0x11);
	i = abs(xsize);
	if (i != 34) error(0x12);
	xsize = -34; ysize = 34;
	i = min(xsize,ysize);
	if (i != -34) error(0x13);
	i = max(xsize,ysize);
	if (i != 34) error(0x14);
	i = abs(xsize);
	if (i != 34) error(0x15);

		/* Char/unsigned int Bit wise and operation */
	a = 0x371;
	c = 0x22;
	b = &c;
	if ((a & *b) != 0x20) error(0x16);

		/* offset > 32K from pointer.... */
	p = 3240;
	p = p+65000;
	if (p != 68240) error(0x17);

		/* Constant expression tests */
	i = 5/3;
	if (i != 1) error(0x18);

	ar[5] = 32;
	l_index = 5;
	ul_index = 5;
	l_index = ar[l_index];
	if (l_index != 32) error(0x19);
	l_index = ar[ul_index];
	if (l_index != 32) error(0x1a);

		/* Sizeof tests */
	i = sizeof(str.e);
	if (i != 160) error(0x1b);
	i = sizeof(str.f);
	if (i != 80) error(0x1c);

		/* Constant versus optimizer... */
	y = 2;
	x = 2000L / y;
	if (x != 1000L) error(0x1d);

		/* Pointer assigned long constant */
	p = 0x0000a000L;
	l_index = p;
	if (l_index != 0x0000a000L) error(0x1e);

		/* Bug 9 - via video, 31 may 1984 */
	i = -((int)(((unsigned)0x8000)>>8));
	if (i != -128) error(0x1f);
}

typedef struct strx	*XPTR;
struct strx {
	long	x1;
};

struct st_tb {
	int x;
	unsigned int y:3;
} ftb[2] = { 1, 2, 3, 4};

test_b()
{
	register long l, *p;
	long x, l2, *p2;
	char v1 = 0x10;
	unsigned int v2 = 0x111;
	char *gx = 0x7fff7fff;
	register XPTR xp = (XPTR) (((long)(gx))&~01);
	int a,b,c;

		/* Strangeness that people will try... */	
	34>21==7;
	1.21>1.20==1;

		/* Register offset, with pointed to value */
	x = 25;
	p2 = p = &x;
	l2 = l = 450;
	p = (long)(l + (long)*p);
	if ((long)p != 475) error(0x20);
	p2 = (long)(l2 + (long)*p2);
	if ((long)p2 != 475) error(0x21);

		/* Equivilence testing */
	if (!equiv(1,5/3)) error(0x22);
	if (!equiv(v1+v2==0x121,1)) error(0x23);
	if (!equiv(100000==100000,1)) error(0x24);

		/* Casting/Typedef/Initialization Tests */
	l = gx;
	l &= ~01;
	if (xp != l) error(0x25);

		/* Last Item in initialized struct is bit field */
	if (ftb[1].x != 3) error(0x26);

		/* Parenthesized expressions as function arguments */
	a = b = c = 0;
	if (sum((a=2, a+3), 4)!=9) error(0x27);
	if (sum(3,(a=4,a+2))!=9) error(0x28);
	if (sum(a=3,(b=5,b+1))!=9) error(0x29);
	if (sum((a=3,a+1),(b=2,b+3))!=9) error(0x2a);
	if (tri_sum((a=3,a+3),(b=2,b+2),c=1)!=11) error(0x2b);
	if (tri_sum(a=1,(b=2,b=3,b+5),c=2)!=11) error(0x2c);
	if (tri_sum(a=2,(b=3,b+2),(c=1,c+3))!=11) error(0x2d);
	if (tri_sum((a=2,a+2),(b=3,b+3),(c=0,c+1))!=11) error(0x2e);
	if (tri_sum(a=5,b=2,(c=6,c-2))!=11) error(0x2f);
}

sum(a,b)
int a, b;
{
	return (a+b);
}

tri_sum(a,b,c)
int a,b,c;
{
	return(a+b+c);
}

equiv(a,b)
int a, b;
{
	return (a == b);
}

struct ddd {
	unsigned char ddd_x;
	char ddd_y;
	int ddd_i;
	unsigned char ddd_z;
	int ddd_j;
	char ddd_a;
	unsigned char ddd_b;
	long ddd_k;
	unsigned char ddd_c;
	int ddd_l;
};

struct ddd ttt = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9};


/* Fast Floating Point Systems bug... */
struct siuser_t {
	char x;
	long y;
	struct {
		char *ptr;
		int len;
		int full : 1;
		char msgbuf[512];
	} buf;
	int connected : 1;
	int io_abort : 1;
	int io_blkrdy : 1;
} siuser;

union msg_buf_t {
	char buffer[20];			/* 0 offset */
	union {
		struct {
			struct msg_hdr_t {
				char stx;		/* 10 offset */
				char type;		/* 11 offset */
				short int length;
				long id;		/* 14 offset */
			} hdr;
			char message[8];	/* 18 offset */
			long crc;
		} data;
		struct rsp_hdr_t {
			char stx;
			char response;
		} rsp;
	} buf;
} inmsg, outmsg;

struct ctype_a {
	char *str;
	int fill;
};

struct cdummy {
	int filler;
	char *str;
};

struct ctype_b {
	long fill;
	int loc;
	struct ctype_a *a_ptr;
};

struct ctype_a carray[] = {
	"This is string zero",
	33,
	"This is string one",
	44,
};

struct ctype_b ctest = {
	0,
	1,
	carray
};

stest_zero()
{
	char ar[10];
	struct ctype_b *cptr;

		/* struct alignment testing */
	if (xyz.align != 9) error(0x30);
	if (xyz.c.i != 2) error(0x31);

		/* character alignment tests */
	if (ttt.ddd_y != 1) error(0x32);
	if (ttt.ddd_i != 2) error(0x33);
	if (ttt.ddd_z != 3) error(0x34);
	if (ttt.ddd_j != 4) error(0x35);
	if (ttt.ddd_a != 5) error(0x36);
	if (ttt.ddd_b != 6) error(0x37);
	if (ttt.ddd_k != 7) error(0x38);
	if (ttt.ddd_c != 8) error(0x39);
	if (ttt.ddd_l != 9) error(0x3a);
	if (ttt.ddd_x != 0) error(0x3b);

		/* Fast Floating Point Systems bug... */
	siuser.buf.ptr = ar;
	inmsg.buf.data.message[1] = 33;
#ifdef OK
	if (&(inmsg.buf.data.message[0]) != (inmsg+18)) error(0x3d);
#endif
	*siuser.buf.ptr = inmsg.buf.data.message[1];
	if (ar[0] != 33) error(0x3c);
	siuser.buf.ptr++;
	*(siuser.buf.ptr) = 25;
	if (ar[1] != 25) error(0x3e);

		/* struct field as index into struct array */
	cptr = &ctest;
	if (cptr->a_ptr[cptr->loc].fill != 44) error(0x3f);
}

	/* Structure Field Testing .... */
struct s1 { 
	struct s2 *a, *b; 
};
struct s2 { 
	struct s1 *b, *a; 
	int p;
};
struct s3 {
	struct s4 {
		int a;
		int b;
	} *p, *q;
};
struct s5 {
	struct s6 {
		int b;
		struct s3 *a;
	} *q, *p;
};

struct t1 { 
	struct t2 *a, *b; 
};

struct t2 { 
	struct t1 *b, *a; 
	int i;
};

struct t3 {
	struct t4 {
		int a;
		int b;
	} *p, *q;
};

struct s1 ss1 = { 0x1134, 0x1144 };
struct s2 ss2 = { 0x1234, 0x1244, 34 };
struct s3 ss3 = { 0x1334, 0x1344 };
struct s5 ss5 = { 0x1534, 0x1544 };

struct s1 *ptr = &ss1;
struct s2 *ptr2 = &ss2;
struct s3 *ptr3 = &ss3;
struct s5 *ptr4 = &ss5;

struct t1 st1a, st1b;
struct t2 st2a, st2b;
struct t1 *tptr;
struct t2 *tptr2;

/* Bug 7 - via video, 31 may 1984 */
struct PT {
	int a;
	int b;
};

struct {
	struct PT f_array[4];
	struct PT f_pt;
	int f_a[4];
} vv7;

struct abcd {
	long i;
};

struct bcde {
	struct abcd b1;
	struct abcd b2;
};


stest_one()
{
	long l;
	struct PT array[4];
	long size;

	l = ptr->a;
	if (l != 0x1134) error(0x50);
	l = ptr2->a;
	if (l != 0x1244) error(0x51);
	ptr->a = ptr2;
	l = ptr->a->p;
	if (l != 34) error(0x52);
	l = ptr3->p;
	if (l != 0x1334) error(0x53);
	l = ptr4->p;
	if (l != 0x1544) error(0x54);

		/* Structure fields which are pointers to structures */
	st1a.a = &st2a;
	st2a.a = &st1b;
	st1b.a = &st2b;
	st2b.a = &st1a;
	tptr = &st1a;
	tptr2 = &st2a;

		/* st1a -> st2a -> st1b -> st2b */
	l = ((tptr->a)->a)->a;
	if (l != &st2b) error(0x55);
		/* st2a -> st1b -> st2b -> st1a */
	l = ((tptr2->a)->a)->a;
	if (l != &st1a) error(0x56);

		/* Bug 7 - via video, 31 may 1984 */
	size = sizeof(array);
	if (size != 16) error(0x57);
	size = sizeof(vv7.f_array);
	if (size != 16) error(0x58);
	size = sizeof(vv7.f_pt);
	if (size != 4) error(0x59);
	size = sizeof(vv7.f_a);
	if (size != 8) error(0x5a);

		/* Constants coerced to structure pointers */
	l = &((struct bcde *)0xed0000L)->b1;
	if (l != 0xed0000L) error(0x5b);
	l = &((struct bcde *)0xed0000L)->b2;
	if (l != 0xed0004L) error(0x5c);
}

union uu {
	long ll;
	char *pp;
	int *ii;
};

union uu ufu1();
union uu ufu2();
union uu u1;

typedef long sint32;
typedef struct {
	sint32 xform[3][3];
} XFM;

typedef struct {
	XFM fxform;
} FONT_TBL;

FONT_TBL cm_fonts = { 1,2,3,4,5,6,7,8,9 };

struct {	/* works ok */
	int a[4];
} dim_one = {
	1, 2, 3, 4
};

struct {	/* doesn't work */
	int b[2][2];
} dim_two = {
	1, 2, 3, 4
};

stest_two()
{
	struct hm {
		struct hmh {
			char mi;
			char fd;
			char ms;
			char om;

			union {
				long io;
				long fn;
				long pr;
			} len;

			long fp;
		} hh;

		char buffer[10];
	} sthm;

	struct hrm {
		int ri : 8;
		char buffer[12];
	} sthrm;

	char *sp, *dp;
	struct hm *hmp;
	struct hrm *hrmp;


		/* Cast char pointer to struct pointer */
	sthm.buffer[0] = 0x92;
	sthrm.buffer[0] = 0x23;
	dp = &sthm;
	sp = ((struct hm *)dp)->buffer;
	if (*sp != 0x92) error(0x60);
	dp = &sthrm;
	sp = ((struct hrm *)dp)->buffer;
	if (*sp != 0x23) error(0x61);

		/* Struct pointer field name non-unique */
	hmp = &sthm;
	hrmp = &sthrm;
	sp = hmp->buffer;
	if (*sp != 0x92) error(0x62);
	sp = hrmp->buffer;
	if (*sp != 0x23) error(0x63);

		/* Cast struct pointer to other struct type */
	hmp = &sthrm;
	hrmp = &sthm;
	sp = ((struct hm *)hrmp)->buffer;
	if (*sp != 0x92) error(0x64);
	sp = ((struct hrm *)hmp)->buffer;
	if (*sp != 0x23) error(0x65);

		/* Functions Returning Unions */
	u1 = ufu1(1L);
	if (u1.ll != 1) error(0x66);
	u1 = ufu2();
	if (u1.ll != 100) error(0x67);

		/* Struct-Struct-2 dimensioned array initialization */
	if (cm_fonts.fxform.xform[0][2] != 3) error(0x68);
	if (cm_fonts.fxform.xform[1][2] != 6) error(0x69);
	if (cm_fonts.fxform.xform[2][2] != 9) error(0x6a);
	if (dim_one.a[3] != 4) error(0x6b);
	if (dim_two.b[1][1] != 4) error(0x6c);
	if (dim_two.b[1][0] != 3) error(0x6d);
}

union uu ufu1(l)
long l;
{
	return(l);
}

union uu ufu2()
{
	return(100L);
}

struct {
	unsigned char s2;
	unsigned char s3;
} my_us;

struct {
	char s2;
	char s3;
} my_ss;

unsigned int retuint();
test_c()
{
	char *p;
	long l;
	register int value, result;
	char c, x;
	register char *rp;
	short j;

	p = 0x0000a000L;
	l = 0x0000a000L;
	if (p != l) error(0x70);

		/* Via Video bug #4 of 31 may 1984 */
	value = 0xfefe;
	result = (value & 0xffff) >> 8;
	if (result != 0xfffe) error(0x71);
	result = (value & 0xffffL) >> 8;
	if (result != 0xfe) error(0x72);
	result = ((long)value & 0xffff) >> 8;
	if (result != 0xfffe) error(0x73);
	result = ((long)value & 0xffffL) >> 8;
	if (result != 0xfe) error(0x74);

		/* Char equal-op Char */
	x = 20;
	c = 5;
	c *= x;
	if (c != 100) error(0x75);

	c = 5;
	c += x;
	if (c != 25) error(0x76);

	c = 5;
	c -= x;
	if (c != -15) error(0x77);

	c = 40;
	c /= x;
	if (c != 2) error(0x78);

		/* Unsigned return from function as argument */
	luarg((long)retuint());	/* error 0x79 */

		/* Unsigned char offsets into structures */
	if (sizeof(my_us) != 2) error(0x7a);
	if (sizeof(my_ss) != 2) error(0x7b);

		/* 16 bit int comparisons to pointers */
	j = 0x7fff;
	rp = 0x7fff;
	if (j != rp) error(0x7c);
	rp = 0xff7fff;
	if (j == rp) error(0x7d);
	p = 0x7fff;
	if (j != p) error(0x7e);
	p = 0xff7fff;
	if (j == p) error(0x7f);
}

unsigned int
retuint()
{
	return(0xfefe);
}

luarg(lval)
long lval;
{
	if (lval != 0xfefeL)
		error(0x79);
}

unsigned char ga[10];
unsigned char ge[10];

/**
 * Array Indexing Tests
 * spawned via Transera - bug report #9 of 9 July 84 
**/
ar_test()
{
	unsigned char a[10];
	extern unsigned char ge[10];
	char x;
	short y, result;
	unsigned short b;
	unsigned char c;

	x = 2;
	y = 2;
	b = 2;
	c = 2;
	a[y] = 0x34;
	if (a[c] != 0x34) error(0x80);
		/* Unsigned char as index into unsigned char array */
	result = (int)a[c];
	if (result != 0x34) error(0x81);
	ga[2] = 0x35;
	result = (int)ga[c];
	if (result != 0x35) error(0x82);
	ge[2] = 0x36;
	result = (int)ge[c];
	if (result != 0x36) error(0x83);

		/* Signed char as index into unsigned char array */
	ga[2] = 0x38;
	result = (int)ga[x];
	if (result != 0x38) error(0x84);
	a[2] = 0x38;
	result = (int)a[x];
	if (result != 0x38) error(0x85);
	ge[2] = 0x39;
	result = (int)ge[x];
	if (result != 0x39) error(0x86);

		/* Signed short as index into unsigned char array */
	a[2] = 0x3a;
	result = (int)a[y];
	if (result != 0x3a) error(0x87);
	ge[2] = 0x3b;
	result = (int)ge[y];
	if (result != 0x3b) error(0x88);

		/* Unsigned short as index into unsigned char array */
	a[2] = 0x3c;
	result = (int)a[b];
	if (result != 0x3c) error(0x89);
	ge[2] = 0x3d;
	result = (int)ge[b];
	if (result != 0x3d) error(0x8a);
}

typedef struct {
	char label[8];
	char desc[32];
	int addr;
	char mask;
	char type;
	char color[4];
} IODATA, *IOPTR;

struct DSS {
	long dsf_ptr;
	IOPTR io_ptr;
	int *info_ptr;
};

warnings(dss_ptr)				/* Don't execute this routine !!!! */
struct DSS *dss_ptr;
{
	IOPTR io_ptr;

	io_ptr = dss_ptr.io_ptr;
	io_ptr = *dss_ptr.io_ptr;	/* Should generate a warning */
}

struct snow {
	int socal;
	int nocal;
	struct water *pw;
};

struct water {
	int wet;
	int socal;
	int nocal;
};

struct snow snowski = { 35, 25, 0L };
struct water waterski = { 1, 85, 70 };

struct soccer {
	int cleats, goalie, ball;
};

struct football {
	int halftime, touchdown, helmet, cleats;
};

struct soccer worldwide = { 1, 2, 3 };
struct football national = { 4, 5, 6, 7 };
int global;

test_d()
{
	register char *p;
	register int n;
	struct snow *pps;
	struct water *ppw;
	char greens[10];
	char *lettuce, *tomato;
	char carrot, salad;
	long *cucumber;
	register long *watermelon;

		/* Pointer increment test */
	p = 100;
	n = 4;
	p += n;
	if (p != 104) error(0x90);

		/* non-unique structure field offset */
	pps = &snowski;
	ppw = &waterski;
	n = pps->socal;
	if (n != 35) error(0x91);
	n = pps->nocal;
	if (n != 25)  { printf("%d (%d) != 25\n",n,pps->nocal); error(0x92); }
	n = ppw->socal;
	if (n != 85) error(0x93);
	n = ppw->nocal;
	if (n != 70) error(0x94);
	if (worldwide.cleats != 1) error(0x95);
	if (national.cleats != 7) error(0x96);

		/* Pointer arithmetic */
	greens[9] = 31;
	lettuce = &greens[0];
	tomato = 2;
	carrot = 7;
	salad = *(lettuce + carrot + tomato);
	if (salad != 31) error(0x97);

		/* non-zero address testing */
	global = 0;
	if (&global == 0) error(0x98);
	(&global == 0) ? 0 : 1;

		/* Pointer comparisons, shouldn't cast... */
	cucumber = 32;
	if (cucumber != 32) error(0x98);
	if (cucumber == 128) error(0x99);
	watermelon = 31;
	if (watermelon != 31) error(0x9a);
	if (watermelon == 124) error(0x9b);
}

struct r_info {
	int	r_zero;	
	unsigned long r_one:24,
				  r_two:8,
				  r_three:8,
				  r_four:24,
				  r_five:32;
};

struct r_info xx = {
	0x23, 0x11011, 0x101, 0x77, 0x20102, 0x13131313
};

bfield()
{
		/* Long Bit-Fields Initialization */
	if (xx.r_one != 0x11011) error(0xa0);
	if (xx.r_two != 0x1) error(0xa1);
	if (xx.r_three != 0x77) error(0xa2);
	if (xx.r_four != 0x20102) error(0xa3);
	if (xx.r_five != 0x13131313) error(0xa4);

		/* Long Bit-Field Assignment */
	xx.r_one = 0x101;
	if (xx.r_one != 0x101) error(0xa5);
	xx.r_two = 0x101;
	if (xx.r_two != 0x1) error(0xa6);
	xx.r_three = 0x101;
	if (xx.r_three != 0x1) error(0xa7);
	xx.r_four = 0x101;
	if (xx.r_four != 0x101) error(0xa8);
	xx.r_five = 0x101;
	if (xx.r_five != 0x101) error(0xa9);

		/* Long Bit-Field Equal-ops */
	xx.r_one &= 0x10;
	if (xx.r_one != 0) error(0xaa);
	xx.r_two |= 0x10;
	if (xx.r_two != 0x11) error(0xab);
	xx.r_three &= 0x1;
	if (xx.r_three != 0x1) error(0xac);
	xx.r_four |= 0x1100;
	if (xx.r_four != 0x1101) error(0xad);
	xx.r_five &= 0xff0ff;
	if (xx.r_five != 0x1) error(0xae);
}
