/*
	Copyright 1983
	Alcyon Corporation
	8716 Production Ave.
	San Diego, Ca.  92121
*/

/* Test suite, module #5 - miscellaneous tests, unsigned tests */

char *version = "@(#)test5.c	2.4	2/5/85";

char array[33000];		/* test for array size > 32k bytes */

struct {
	int a;
	char b[7];
	long d;
} s[5] = {				/* test structure array initialization */
	1,      "one", 10,
	-32768, "two", 010,
	0,      "three", 0x10,
	32767,  "four h", 1000000000,
	-1,     "five", -99999999
};

typedef struct sysnod	SYSTAB[];

struct sysnod {
	char *	sysnam;
	int	sysval;
};

SYSTAB reserved={
		{"in",		0412},
};
int errs = 0;

main() 
{
	test1();
	ubyte1();
	ubyte2();
	ubyte3();
	ulong1();
	ulong2();
	ulong3();
	docast();
	misc();
	if(!errs)
		printf("********** Far Freaking Out **********\n");
	else
		printf("Tough Luck\n");
}
	
error(errnum)
int errnum;
{
	printf("error %x\n",errnum);
	errs++;
}

/*
	the following code is a battery of tests directed
	'against' the C compiler.  these tests reflect difficulties
	discovered in prior compiler releases.
*/
test1()
{
	int i = 100;
	register int ri = 1000;
	long l;
	register long rl;
	char *p1, *p2;
	int *pi;

	if ((array[32999] = 'z') != 'z') error(0x0);
	pi = &array[0];
	pi += 0x4000L;
	if (pi != &array[0x8000L]) error(0x1);

	if(s[0].a != 1) error(0x2);
	if(s[1].a != -32768) error(0x3);
	if(s[2].a != 0) error(0x4);
	if(s[3].a != 32767) error(0x5);
	if(s[4].a != -1) error(0x6);

	if(strcmp(s[0].b,"one") != 0) error(0x7);
	if(strcmp(s[1].b,"two") != 0) error(0x8);
	if(strcmp(s[2].b,"three") != 0) error(0x9);
	if(strcmp(s[3].b,"four h") != 0) error(0xa);
	if(strcmp(s[4].b,"five") != 0) error(0xb);
	
	printf("10 decimal = %ld, ", s[0].d);
	printf("10 octal   = %lo, ", s[1].d);
	printf("10 hex     = %lx\n", s[2].d);
	printf("100000000  = %ld, ", s[3].d);
	printf("-99999999  = %ld\n", s[4].d);

	l = i * i;				/* test assembler code (long=int*int) */
	rl = i * i;				/* ditto */

	rl = i * ri / i;		/* test sign extend of 32-bit product */

	i = 4;
	if((-4/i) != -1) error(0xc);
	if((-4/i) != (-4/4)) error(0xd);

	p1 = 0;
	p2 = 4;
	if((p1 - p2) != -4) error(0xe);
}


ubyte1()
{
	unsigned char uc1, uc2, uc3;
	char c;
	long l;
	short i;

	uc1 = 0x8f; 
	uc2 = 0x71;
	uc3 = 0xff;
	if(uc1 != 0x8f) error(0x10);
	if(uc2 != 0x71) error(0x11);
	if(uc3 != 0xff) error(0x12);

	l = uc1;
	c = uc2;
	i = uc3;
	if(l != 0x8f) error(0x13);
	if(c != 0x71) error(0x14);
	if(i != 0xff) error(0x15);
	
	
	uc3 = uc1 / uc2;
	if(uc3 != 0x1) error(0x16);
	uc3 = uc1 * uc2;
	if(uc3 != 0x1f) error(0x17);
	uc3 = uc1 % uc2;
	if(uc3 != 0x1e) error(0x18);
	uc3 = uc1 | uc2;
	if(uc3 != 0xff) error(0x19);
	uc3 = uc1 ^ uc2;
	if(uc3 != 0xfe) error(0x1a);

	i = uc1 / uc2;
	if(i != 0x1) error(0x1b);
	i = uc1 * uc2;
	if(i != 0x3f1f) error(0x1c);
	i = uc1 % uc2;
	if(i != 0x1e) error(0x1d);
	i = uc1 | uc2;
	if(i != 0xff) error(0x1e);
	i = uc1 ^ uc2;
	if(i != 0xfe) error(0x1f);

	c = uc2;
	uc3 = uc1 / c;
	if(uc3 != 0x1) error(0x20); 
	uc3 = uc1 * c;
	if(uc3 != 0x1f) error(0x21);
	uc3 = uc1 % c;
	if(uc3 != 0x1e) error(0x22);
	uc3 = uc1 | c;
	if(uc3 != 0xff) error(0x23);
	uc3 = uc1 ^ c;
	if(uc3 != 0xfe) error(0x24);

	c = 0x7f;
	uc3 = c / uc2;
	if(uc3 != 0x1) error(0x25);
	uc3 = c * uc2;
	if(uc3 != 0xf) error(0x26);
	uc3 = c % uc2;
	if(uc3 != 0xe) error(0x27);
	uc3 = c | uc2;
	if(uc3 != 0x7f) error(0x28);
	uc3 = c ^ uc2;
	if(uc3 != 0xe) error(0x29);

	i = uc2;
	uc3 = uc1 / i;
	if(uc3 != 0x1) error(0x2a);
	uc3 = uc1 * i;
	if(uc3 != 0x1f) error(0x2b);
	uc3 = uc1 % i;
	if(uc3 != 0x1e) error(0x2c);
	uc3 = uc1 | i;
	if(uc3 != 0xff) error(0x2d);
	uc3 = uc1 ^ i;
	if(uc3 != 0xfe) error(0x2e);

	i = uc1;
	uc3 = i / uc2;
	if(uc3 != 0x1) error(0x2f);
	uc3 = i * uc2;
	if(uc3 != 0x1f) error(0x30);
	uc3 = i % uc2;
	if(uc3 != 0x1e) error(0x31);
	uc3 = i | uc2;
	if(uc3 != 0xff) error(0x32);
	uc3 = i ^ uc2;
	if(uc3 != 0xfe) error(0x33);

	l = uc2;
	uc3 = uc1 / l;
	if(uc3 != 0x1) error(0x34);
	uc3 = uc1 * l;
	if(uc3 != 0x1f) error(0x35);
	uc3 = uc1 % l;
	if(uc3 != 0x1e) error(0x36);
	uc3 = uc1 | l;
	if(uc3 != 0xff) error(0x37);
	uc3 = uc1 ^ l;
	if(uc3 != 0xfe) error(0x38);

	l = uc1;
	uc3 = l / uc2;
	if(uc3 != 0x1) error(0x39);
	uc3 = l * uc2;
	if(uc3 != 0x1f) error(0x3a);
	uc3 = l % uc2;
	if(uc3 != 0x1e) error(0x3b);
	uc3 = l | uc2;
	if(uc3 != 0xff) error(0x3c);
	uc3 = l ^ uc2;
	if(uc3 != 0xfe) error(0x3d);
}

ubyte2()
{
	unsigned char uc1, uc2, uc3;
	unsigned char *puc1, *puc2, *puc3;
	char c;
	long l;
	short i;

	puc1 = &uc1;
	puc2 = &uc2;
	puc3 = &uc3;

	*puc1 = 0x8f; 
	*puc2 = 0x71;
	*puc3 = 0xff;
	if(*puc1 != 0x8f) error(0x40);
	if(*puc2 != 0x71) error(0x41);
	if(*puc3 != 0xff) error(0x42);

	l = *puc1;
	c = *puc2;
	i = *puc3;
	if(l != 0x8f) error(0x43);
	if(c != 0x71) error(0x44);
	if(i != 0xff) error(0x45);
	
	*puc3 = *puc1 / *puc2;
	if(*puc3 != 0x1) error(0x46);
	*puc3 = *puc1 * *puc2;
	if(*puc3 != 0x1f) error(0x47);
	*puc3 = *puc1 % *puc2;
	if(*puc3 != 0x1e) error(0x48);
	*puc3 = *puc1 | *puc2;
	if(*puc3 != 0xff) error(0x49);
	*puc3 = *puc1 ^ *puc2;
	if(*puc3 != 0xfe) error(0x4a);

	i = *puc1 / *puc2;
	if(i != 0x1) error(0x4b);
	i = *puc1 * *puc2;
	if(i != 0x3f1f) error(0x4c);
	i = *puc1 % *puc2;
	if(i != 0x1e) error(0x4d);
	i = *puc1 | *puc2;
	if(i != 0xff) error(0x4e);
	i = *puc1 ^ *puc2;
	if(i != 0xfe) error(0x4f);

	c = *puc2;
	*puc3 = *puc1 / c;
	if(*puc3 != 0x1) error(0x50);
	*puc3 = *puc1 * c;
	if(*puc3 != 0x1f) error(0x51);
	*puc3 = *puc1 % c;
	if(*puc3 != 0x1e) error(0x52);
	*puc3 = *puc1 | c;
	if(*puc3 != 0xff) error(0x53);
	*puc3 = *puc1 ^ c;
	if(*puc3 != 0xfe) error(0x54);

	c = 0x7f;
	*puc3 = c / *puc2;
	if(*puc3 != 0x1) error(0x55);
	*puc3 = c * *puc2;
	if(*puc3 != 0xf) error(0x56);
	*puc3 = c % *puc2;
	if(*puc3 != 0xe) error(0x57);
	*puc3 = c | *puc2;
	if(*puc3 != 0x7f) error(0x58);
	*puc3 = c ^ *puc2;
	if(*puc3 != 0xe) error(0x59);

	i = *puc2;
	*puc3 = *puc1 / i;
	if(*puc3 != 0x1) error(0x5a);
	*puc3 = *puc1 * i;
	if(*puc3 != 0x1f) error(0x5b);
	*puc3 = *puc1 % i;
	if(*puc3 != 0x1e) error(0x5c);
	*puc3 = *puc1 | i;
	if(*puc3 != 0xff) error(0x5d);
	*puc3 = *puc1 ^ i;
	if(*puc3 != 0xfe) error(0x5e);

	i = *puc1;
	*puc3 = i / *puc2;
	if(*puc3 != 0x1) error(0x5f);
	*puc3 = i * *puc2;
	if(*puc3 != 0x1f) error(0x50);
	*puc3 = i % *puc2;
	if(*puc3 != 0x1e) error(0x51);
	*puc3 = i | *puc2;
	if(*puc3 != 0xff) error(0x52);
	*puc3 = i ^ *puc2;
	if(*puc3 != 0xfe) error(0x53);

	l = *puc2;
	*puc3 = *puc1 / l;
	if(*puc3 != 0x1) error(0x54);
	*puc3 = *puc1 * l;
	if(*puc3 != 0x1f) error(0x55);
	*puc3 = *puc1 % l;
	if(*puc3 != 0x1e) error(0x56);
	*puc3 = *puc1 | l;
	if(*puc3 != 0xff) error(0x57);
	*puc3 = *puc1 ^ l;
	if(*puc3 != 0xfe) error(0x58);

	l = *puc1;
	*puc3 = l / *puc2;
	if(*puc3 != 0x1) error(0x59);
	*puc3 = l * *puc2;
	if(*puc3 != 0x1f) error(0x5a);
	*puc3 = l % *puc2;
	if(*puc3 != 0x1e) error(0x5b);
	*puc3 = l | *puc2;
	if(*puc3 != 0xff) error(0x5c);
	*puc3 = l ^ *puc2;
	if(*puc3 != 0xfe) error(0x5d);
}

typedef unsigned char UBYTE;
unsigned char uc_ar[] = { 0x80, 0x81, 0x082, 0x83, 0x84 };
unsigned char uchar = 34;
unsigned char fub();

ubyte3()
{
	register unsigned char ruc;
	unsigned char *puc;
	register unsigned char *rpuc;
	UBYTE typub;
	int i;
	long l;
	char c;
	
	if(sizeof(unsigned char) != 1) error(0x60);
	if(sizeof(UBYTE) != 1) error(0x61);
	c = i = l = 34;
	if(uchar != c) error(0x62);
	if(uchar != i) error(0x63);
	if(uchar != l) error(0x64);
	i = l = 0x81;
	if(uc_ar[1] != i) error(0x65);
	if(uc_ar[1] != l) error(0x66);
	rpuc = &uc_ar[2];
	if (*rpuc++ != 0x082) error(0x67);
	if (*rpuc != 0x83) error(0x68);
	puc = &uc_ar[2];
	if (*puc++ != 0x082) error(0x69);
	if (*puc != 0x83) error(0x6a);

	if (fub(0x89) != 0x89) error(0x6b);

	c = 0xff;
	i = (unsigned char)c;
	if(i != 0xff) error(0x6c);
	i = 0x7ff;
	l = (unsigned char)i;
	if(l != 0xff) error(0x6d);
}

unsigned char
fub(i)
int i;
{
	return(i);
}

ulong1()
{
	unsigned long ul1, ul2, ul3;
	char c;
	long l;
	short i;

	ul1 = 0x71717171;
	ul2 = 0x1f8f1f8f; 
	ul3 = 0xfff0fff0;
	if(ul1 != 0x71717171) error(0x71);
	if(ul2 != 0x1f8f1f8f) error(0x70);
	if(ul3 != 0xfff0fff0) error(0x72);

	c = ul1;
	i = ul2;
	l = ul3;
	if(c != 0x71) error(0x73);
	if(i != 0x1f8f) error(0x74);
	if(l != 0xfff0fff0) error(0x75);
	
	ul3 = ul1 / ul2;
	if(ul3 != 0x3) error(0x76);
	ul3 = ul1 * ul2;
	if(ul3 != 0x283a0d1f) error(0x77);
	ul3 = ul1 % ul2;
	if(ul3 != 0x12c412c4) error(0x78);
	ul3 = ul1 | ul2;
	if(ul3 != 0x7fff7fff) error(0x79);
	ul3 = ul1 ^ ul2;
	if(ul3 != 0x6efe6efe) error(0x7a);

	i = ul1 / ul2;
	if(i != 0x3) error(0x7b);
	i = ul1 * ul2;
	if(i != 0x0d1f) error(0x7c);
	i = ul1 % ul2;
	if(i != 0x12c4) error(0x7d);
	i = ul1 | ul2;
	if(i != 0x7fff) error(0x7e);
	i = ul1 ^ ul2;
	if(i != 0x6efe) error(0x7f);

	c = ul2;
	ul3 = ul1 / c;
	if(ul3 != 0x71a3) error(0x80);
	ul3 = ul1 * c;
	if(ul3 != 0x5e5ded1f) error(0x81);
	ul3 = ul1 % c;
	if(ul3 != 0x9a64L) error(0x82);
	ul3 = ul1 | c;
	if(ul3 != 0x7171ffff) error(0x83);
	ul3 = ul1 ^ c;
	if(ul3 != 0x71718efe) error(0x84);

	c = 0x7f;
	ul3 = c / ul2;
	if(ul3 != 0x0) error(0x85);
	ul3 = c * ul2;
	if(ul3 != 0xa800a7f1) error(0x86);
	ul3 = c % ul2;
	if(ul3 != 0x7f) error(0x87);
	ul3 = c | ul2;
	if(ul3 != 0x1f8f1fff) error(0x88);
	ul3 = c ^ ul2;
	if(ul3 != 0x1f8f1ff0) error(0x89);

	i = ul2;
	ul3 = ul1 / i;
	if(ul3 != 0x3983d) error(0x8a);
	ul3 = ul1 * i;
	if(ul3 != 0x1b1b0d1f) error(0x8b);
	ul3 = ul1 % i;
	if(ul3 != 0x45e) error(0x8c);
	ul3 = ul1 | i;
	if(ul3 != 0x71717fff) error(0x8d);
	ul3 = ul1 ^ i;
	if(ul3 != 0x71716efe) error(0x8e);

	i = ul1;
	ul3 = i / ul2;
	if(ul3 != 0x3) error(0x8f);
	ul3 = i * ul2;
	if(ul3 != 0x1b1b0d1f) error(0x90);
	ul3 = i % ul2;
	if(ul3 != 0x12c4) error(0x91);
	ul3 = i | ul2;
	if(ul3 != 0x1f8f7fff) error(0x92);
	ul3 = i ^ ul2;
	if(ul3 != 0x1f8f6efe) error(0x93);

	l = ul2;
	ul3 = ul1 / l;
	if(ul3 != 0x3) error(0x94);
	ul3 = ul1 * l;
	if(ul3 != 0x283a0d1f) error(0x95);
	ul3 = ul1 % l;
	if(ul3 != 0x12c412c4) error(0x96);
	ul3 = ul1 | l;
	if(ul3 != 0x7fff7fff) error(0x97);
	ul3 = ul1 ^ l;
	if(ul3 != 0x6efe6efe) error(0x98);

	l = ul1;
	ul3 = l / ul2;
	if(ul3 != 0x3) error(0x99);
	ul3 = l * ul2;
	if(ul3 != 0x283a0d1f) error(0x9a);
	ul3 = l % ul2;
	if(ul3 != 0x12c412c4) error(0x9b);
	ul3 = l | ul2;
	if(ul3 != 0x7fff7fff) error(0x9c);
	ul3 = l ^ ul2;
	if(ul3 != 0x6efe6efe) error(0x9d);
}

ulong2()
{
	unsigned long ul1, ul2, ul3;
	unsigned long *pul1, *pul2, *pul3;
	char c;
	long l;
	short i;

	pul1 = &ul1;
	pul2 = &ul2;
	pul3 = &ul3;

	*pul1 = 0x71717171; 
	*pul2 = 0x1f8f1f8f;
	*pul3 = 0xfff0fff0;
	if(*pul1 != 0x71717171) error(0xa0);
	if(*pul2 != 0x1f8f1f8f) error(0xa1);
	if(*pul3 != 0xfff0fff0) error(0xa2);

	c = *pul1;
	i = *pul2;
	l = *pul3;
	if(c != 0x71) error(0xa3);
	if(i != 0x1f8f) error(0xa4);
	if(l != 0xfff0fff0) error(0xa5);
	
	*pul3 = *pul1 / *pul2;
	if(*pul3 != 0x3) error(0xa6);
	*pul3 = *pul1 * *pul2;
	if(*pul3 != 0x283a0d1f) error(0xa7);
	*pul3 = *pul1 % *pul2;
	if(*pul3 != 0x12c412c4) error(0xa8);
	*pul3 = *pul1 | *pul2;
	if(*pul3 != 0x7fff7fff) error(0xa9);
	*pul3 = *pul1 ^ *pul2;
	if(*pul3 != 0x6efe6efe) error(0xaa);

	i = *pul1 / *pul2;
	if(i != 0x3) error(0xab);
	i = *pul1 * *pul2;
	if(i != 0x0d1f) error(0xac);
	i = *pul1 % *pul2;
	if(i != 0x12c4) error(0xad);
	i = *pul1 | *pul2;
	if(i != 0x7fff) error(0xae);
	i = *pul1 ^ *pul2;
	if(i != 0x6efe) error(0xaf);

	c = *pul2;
	*pul3 = *pul1 / c;
	if(*pul3 != 0x71a3) error(0xb0);
	*pul3 = *pul1 * c;
	if(*pul3 != 0x5e5ded1f) error(0xb1);
	*pul3 = *pul1 % c;
	if(*pul3 != 0x9a64L) error(0xb2);
	*pul3 = *pul1 | c;
	if(*pul3 != 0x7171ffff) error(0xb3);
	*pul3 = *pul1 ^ c;
	if(*pul3 != 0x71718efe) error(0xb4);

	c = 0x7f;
	*pul3 = c / *pul2;
	if(*pul3 != 0x0) error(0xb5);
	*pul3 = c * *pul2;
	if(*pul3 != 0xa800a7f1) error(0xb6);
	*pul3 = c % *pul2;
	if(*pul3 != 0x7f) error(0xb7);
	*pul3 = c | *pul2;
	if(*pul3 != 0x1f8f1fff) error(0xb8);
	*pul3 = c ^ *pul2;
	if(*pul3 != 0x1f8f1ff0) error(0xb9);

	i = *pul2;
	*pul3 = *pul1 / i;
	if(*pul3 != 0x3983d) error(0xba);
	*pul3 = *pul1 * i;
	if(*pul3 != 0x1b1b0d1f) error(0xbb);
	*pul3 = *pul1 % i;
	if(*pul3 != 0x45e) error(0xbc);
	*pul3 = *pul1 | i;
	if(*pul3 != 0x71717fff) error(0xbd);
	*pul3 = *pul1 ^ i;
	if(*pul3 != 0x71716efe) error(0xbe);

	i = *pul1;
	*pul3 = i / *pul2;
	if(*pul3 != 0x3) error(0xbf);
	*pul3 = i * *pul2;
	if(*pul3 != 0x1b1b0d1f) error(0xc0);
	*pul3 = i % *pul2;
	if(*pul3 != 0x12c4) error(0xc1);
	*pul3 = i | *pul2;
	if(*pul3 != 0x1f8f7fff) error(0xc2);
	*pul3 = i ^ *pul2;
	if(*pul3 != 0x1f8f6efe) error(0xc3);

	l = *pul2;
	*pul3 = *pul1 / l;
	if(*pul3 != 0x3) error(0xc4);
	*pul3 = *pul1 * l;
	if(*pul3 != 0x283a0d1f) error(0xc5);
	*pul3 = *pul1 % l;
	if(*pul3 != 0x12c412c4) error(0xc6);
	*pul3 = *pul1 | l;
	if(*pul3 != 0x7fff7fff) error(0xc7);
	*pul3 = *pul1 ^ l;
	if(*pul3 != 0x6efe6efe) error(0xc8);

	l = *pul1;
	*pul3 = l / *pul2;
	if(*pul3 != 0x3) error(0xc9);
	*pul3 = l * *pul2;
	if(*pul3 != 0x283a0d1f) error(0xca);
	*pul3 = l % *pul2;
	if(*pul3 != 0x12c412c4) error(0xcb);
	*pul3 = l | *pul2;
	if(*pul3 != 0x7fff7fff) error(0xcc);
	*pul3 = l ^ *pul2;
	if(*pul3 != 0x6efe6efe) error(0xcd);
}

typedef unsigned long ULONG;
unsigned long ul_ar[] = { 0x80, 0x81, 0x82, 0x83, 0x84 };
unsigned long ulong = 34;
unsigned long ful();

ulong3()
{
	register unsigned long rul;
	unsigned long *pul;
	register unsigned long *rpul;
	ULONG typul;
	short i;
	long l;
	char c;
	
	if(sizeof(unsigned long) != 4) error(0xd0);
	if(sizeof(ULONG) != 4) error(0xd1);
	c = i = l = 34;
	if(ulong != c) error(0xd2);
	if(ulong != i) error(0xd3);
	if(ulong != l) error(0xd4);
	i = l = 0x81;
	if(ul_ar[1] != i) error(0xd5);
	if(ul_ar[1] != l) error(0xd6);
	rpul = &ul_ar[2];
	if (*rpul++ != 0x82) error(0xd7);
	if (*rpul != 0x83) error(0xd8);
	pul = &ul_ar[2];
	if (*pul++ != 0x82) error(0xd9);
	if (*pul != 0x83) error(0xda);

	if (ful(0x89) != 0x89) error(0xdb);
	
	c = 0xff;
	l = (unsigned long)c;
	if(l != 0xffffL) error(0xdc);
	i = 0xff77;
	l = (unsigned long)i;
	if(l != 0xff77L) error(0xdd);
	l = (unsigned)i;
	if(l != 0xff77L) error(0xde);
}

unsigned long
ful(i)
int i;
{
	return(i);
	(*((int (*)())0))();	/* should not do this, just see if compiles ok ! */
}

docast()
{
	char c;
	long l;
	unsigned long ul;
	int i;

	l = (unsigned char)34;
	if(l != 34) error(0xe0);
	l = (char)0xaaa;
	if(l != -86) error(0xe1);
	l = (unsigned char)-167;
	if(l != 89) error(0xe2);
	l = (char)-167;
	if(l != 89) error(0xe3);
	l = (unsigned char)-27;
	if(l != 0xe5) error(0xe4);
	l = (char)-27;
	if(l != -27) error(0xe5);
	i = 0x7ff;
	l  = (unsigned char)i;
	if(l != 0xff) error(0xe6);
	ul = (unsigned char)i;
	if(ul != 0xff) error(0xe7);
}

unsigned int  uiar[] = { 2, 3, 4 };
unsigned char ucar[] = { 2, 3, 4 };
unsigned long ular[] = { 2, 3, 4 };
static char pre_ar[10] = { 1, 2, 3, 4, 5, 6, 7, 8, 9, 0 };
struct gfref *pgfref;	/* forward ref, never defined */

misc()
{
	struct lfref *plfref;	/* forward ref, never defined */
	char *p;	/* register */
	char *p1;
	unsigned int ui;
	unsigned char uc;
	long l1, l2;
	int i;

/* miscellaneous unsigned tests */
	p1 = 0xff0000;
	ui = 0xaaaa;
	uc = 0xbb;
	p = p1 + ui;
	l1 = 0xff0000;
	l2 = l1 + ui;
	if (p != 0xffaaaa) error(0xf0);
	p = p1 + uc;
	if (p != 0xff00bb) error(0xf1);
	if(uiar[1] != 3) error(0xf2);
	if(ucar[1] != 3) error(0xf3);
	if(ular[1] != 3) error(0xf4);
/* pre/post inc/dec on char array as index into char array */
	i = pre_ar[pre_ar[0]++];	/* pre_ar[0] ==> 2 */
	if (i != 2) error(0xf5);
	if (pre_ar[0] != 2) error(0xf6);
	i = pre_ar[pre_ar[0]--];	/* pre_ar[0] ==> 1 */
	if (i != 3) error(0xf7);
	if (pre_ar[0] != 1) error(0xf8);
	i = pre_ar[++pre_ar[0]];	/* pre_ar[0] ==> 2 */
	if (i != 3) error(0xf9);
	if (pre_ar[0] != 2) error(0xfa);
	i = pre_ar[--pre_ar[0]];	/* pre_ar[0] ==> 1 */
	if (i != 2) error(0xfb);
	if (pre_ar[0] != 1) error(0xfc);

/* large argument list accessing */
	if (!argaccess()) error(0xfd);
}

argaccess()
{
	char buf[256];
	int i;
	long j[3];

	i = 1;
	j[1] = 30;
	j[i] = i + j[i];
	return(j[i] == 31);
}

strcmp(s,t)                             /* returns 0 for equality*/
register char *s, *t;
{
    for ( ; *s == *t; s++, t++)
    if (*s == '\0')
        return(0);
    return (*s - *t);
}
