
/**
 *  Copyright 1984
 *  Alcyon Corporation
 *  8716 Production Ave.
 *  San Diego, Ca.  92121
**/

char *version = "@(#)fptest.c	2.9	1/28/85";

#include <math.h>

typedef struct { double a[6]; } joint;

static joint lower_limit = { 1.1, 2.2, 3.3, 4.4, 5.5, 6.6 };

float *f1();
float f2();
float ret_0();
double d_const();

struct type {
	float ft;
	double dt;
	float *pft;
} fstruc;

char *fstr = "-2.3E-4";
char *astr = "8.6324";
float ar[10] = { 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0 };
float global_f;

int err = 0;

main()
{
	double d1 = 1.0;
	double d2 = 2.0;
	double d3 = 3.0;

	mtest();
	ar_test();
	d_adop(d1,d2,&d3);
	d_args(d1,d2);
	d3 = 3.0;
	d_ass(d1,d2,&d3);
	d3 = d_const();
	fp_conv();
	d3 = 3.0;
	d_div(d1,d2,&d3);
	d_sizeof();
	d3 = 3.0;
	d_uneg(d1,d2,&d3);
	d_ret();
	d3 = 3.0;
	d_sub(d1,d2,&d3);
	eq_op();
	infinity();
	if (err == 0)
		printf("---- Far Freaking Out ----\n");
	else
		printf("---- Tough Luck ----\n");
}

error(errnum)
int errnum;
{
	printf("error: %x\n",errnum);
	err++;
}

mtest()
{
	double d;
	float f, fp2, *fp;
	char *s, buf[20];
	long l;
	int i;
	unsigned long ul;
	unsigned int ui;

		/* Strangeness that people will try */
	1.21>1.20==1;
		/* Unsigned long divide */
	printf("3.2 - 5.5 => %f or %e\n",3.2-5.5,3.2-5.5);
		/* Constant Expressions */
	printf("%e == %e\n",3.2-5.5,-2.3);
		/* functions returning floats */
	if ((fp = f1()) != fstruc.pft) error(0xf1);
	if ((f = f2()) != 2.0) error(0xf2);
	d = f;
	if (d != f) error(0xf3);
	f = atof(fstr);
	s = ftoa(f,buf,6);
	printf("%s => %f => %s\n",fstr,f,s);
	f = 3.4;
	l = f;
	if (l != 3L) error(0xf4);
	i = f;
	if (i != 3) error(0xf5);
	l = 7L;
	f = l;
	if (f < 6.9 || f > 7.1) error(0xf6);
	i = 7;
	f = i;
	if (f < 6.9 || f > 7.1) error(0xf7);
	f = atof(astr);
	printf("%s ==> ~ %f or %e\n",astr,f,f);
	f = 0;
	if (f != 0.0) error(0xf8);
	i = 3;
	ar[i] = 3.0;
	f = 4.0;
	fp2 = 10.0;
	printf("%f += ",ar[i]);
	printf("%f * %f ==> ",f,fp2);
	ar[i] += f * fp2;
	printf("%f\n",ar[i]);
	global_f = 0.0;
	f = 0.0;

		/* Conversions to Float */
	i  = 0x8642;
	ui = 0x8642;
	l  = 0x8fff8fff;
	ul = 0x8fff8fff;
	f = i;
	if (f >= 0.0) error(0xf9);
	f = ui;
	if (f <= 0.0) error(0xfa);
	f = l;
	if (f >= 0.0) error(0xfb);
	f = ul;
	if (f <= 0.0) error(0xfc);
	f = 0.0;
	if_test(f);	/* Expects a zero input. */

		/* Divide by power of two */
	f = 8;
	f /= 2;
	if (f < 3.9 || f > 4.1) error(0xfd);
	f = 4;
	f *= 2;
	if (f < 7.9 || f > 8.1) error(0xfe);

		/* Conversion to int */
	f = 4.6;
	i = f + 0.5;
	if (i != 5) error(0xff);
}

float *
f1()
{
	return(fstruc.pft);
}

float
f2()
{
	return(2.0);
}

float
ret_0()
{
	return(0.0);
}

if_test(pf)
float pf;
{
	float af, *ptr;

	ar[2] = 0.0;
	af = 0.0;
	ptr = &af;
	if (global_f) error(0x100);
	if (ar[2]) error(0x101);
	if (af) error(0x102);
	if (pf) error(0x103);
	if (*ptr) error(0x104);
	if (ret_0()) error(0x105);
}

infinity()
{
	float a, b;

	a = 1.0E+6;
	b = 0.0;

	while(a > b) {
		printf("%e > %e\n",a,b);
		b = a;
		a = a * a;
	}
	printf("%e <= %e\n",a,b);
}

ar_test()
{
	float a[5], b[5], c[5], d[5];
	int i, errnum;

	errnum = 0x110;
	a[0] = 0.0; b[0] = 0.0; c[0] = 0.0; d[0] = 0.0;
	a[1] = 1.0; b[1] = 1.0; c[1] = 1.0; d[1] = 1.0;
	a[2] = 2.0; b[2] = 2.0; c[2] = 2.0; d[2] = 2.0;
	a[3] = 3.0; b[3] = 3.0; c[3] = 3.0; d[3] = 3.0;
	a[4] = 4.0; b[4] = 4.0; c[4] = 4.0; d[4] = 4.0;
	for(i = 0 ; i < 5; i++) {
		a[i] += b[i];
		c[i] = c[i] + d[i];
		if(a[i] != c[i]) {
			printf("%f != %f\n",a[i],c[i]);
			error(errnum);
		}
		errnum++;
	}
}

/*********************************************
	Double tests....
 *********************************************/

/* double adop double */
double x_x;
double x_ar[3];

d_adop(arg,arg2,p2)
double arg, arg2, *p2;
{
	double d, *p, xar[3];

	d = 1.0;
	xar[0] = 2.0;
	xar[1] = 3.0;
	p = &xar[0];
	arg += arg2;
	d += *p;
	if (arg != d) error(0x10);
	*p += d;
	x_x += *p2;
	*p2 += x_x;
	*p += *p2;
	x_ar[0] += x_ar[1];
	xar[0] += xar[1];
}

/* double arguments*/
double x;
double z_ar[3];

d_args(arg,arg2)	/* 1.0, 2.0 */
double arg, arg2;
{
	double d, *p;
	int ret;

	p = &arg2;
	d = 1.0;  x = d;
	if ((ret = rtest(arg,*p)) != 0)
		error((ret==1) ? 0x20 : (ret==2) ? 0x21 : 0x22);
	if ((ret = rtest(arg,arg2)) != 0)
		error((ret==1) ? 0x23 : (ret==2) ? 0x24 : 0x25);
	if ((ret = rtest(d,2.0)) != 0)
		error((ret==1) ? 0x26 : (ret==2) ? 0x27 : 0x28);
	if ((ret = rtest(x,(double)2)) != 0)
		error((ret==1) ? 0x29 : (ret==2) ? 0x2a : 0x2b);
	p = &arg;
	z_ar[1] = arg2;
	if ((ret = rtest(*p,z_ar[1])) != 0)
		error((ret==1) ? 0x2c : (ret==2) ? 0x2d : 0x2e);
	z_ar[0] = 1.0;
	if ((ret = rtest(z_ar[0],arg2)) != 0)
		error((ret==1) ? 0x2f : (ret==2) ? 0x30 : 0x31);
}

rtest(a1,a2)
double a1, a2;
{
	int ret = 0;

	if (a1 != 1.0)
		ret++;
	if (a2 != 2.0)
		ret += 2;
	return(ret);
}

	/* double assignment */
double x;
double as_ar[3];

d_ass(arg,arg2,p2)
double arg, arg2, *p2;
{
	register float *pf;
	float fparray[5], g;
	double d, *p, xar[3];

	p = &xar[1];
	as_ar[0] = -45.26;
	as_ar[1] = -25;
	as_ar[2] = 31.789;
	xar[0] = 45;
	xar[1] = -34;
	xar[2] = 34.789;
	arg = arg2;
	if (arg != arg2) error(0x40);
	d = *p;
	if (d != *p) error(0x41);
	*p = d;
	if (*p != d) error(0x42);
	x = *p2;
	if (x != *p2) error(0x43);
	*p2 = x;
	if (*p2 != x) error(0x44);
	*p = *p2;
	if (*p != *p2) error(0x45);
	as_ar[0] = as_ar[1];
	if (as_ar[0] != as_ar[1]) error(0x46);
	xar[0] = xar[1];
	if (xar[0] != xar[1]) error(0x47);

		/* Transera bug reported 27 Aug 1984 */
	pf = &fparray[0];
	g = 3.0;
	fparray[0] = 1.1;
	fparray[1] = 2.2;
	*pf++ /= g;	/* Increments pf coming and going */
	if (*pf != 2.2) error(0x48);
	if (fparray[0] == 1.1) error(0x48);
}

/* double constant tests */
double
d_const()
{
	double x;

	return(0);
	return(0.0);
	return(1.3);
	return(13);
	return(0xfffff);

	f((float)0);
	f(0.0);
	f(1.3);
	f((float)13);
	f((float)0xfffff);

	x = 0;
	x = 0.0;
	x = 1.3;
	x = 13;
	x = 0xfffff;

	x *= 0;
	x *= 0.0;
	x *= 1.3;
	x *= 13;
	x *= 0xfffff;

	x += 0;
	x += 0.0;
	x += 1.3;
	x += 13;
	x += 0xfffff;

	x -= 0;
	x -= 0.0;

	x /= 1.3;
	x /= 13;
	x /= 0xfffff;
}

f(fp)
double fp;
{
}

/* float and double coversions */
fp_conv()
{
	double d;
	float f;
	long l;
	char c;

	d = f;
	d = l;
	d = c;
	d = 3.0;
	d = 3L;
	d = 3;

	f = d;
	f = l;
	f = c;
	f = 3.0;
	f = 3L;
	f = 3;
}

/* double divide tests */
double x;
double dd_ar[3];
double t();

d_div(arg,arg2,p2)
double arg, arg2, *p2;
{
	double d, *p, xar[3];

	dd_ar[0] = 1.0;
	dd_ar[1] = 2.0;
	p = p2;
	arg = arg2 / t();
	d = *p / t();
	x = t() / dd_ar[0];
	*p = d / t();
	*p = *p2 / t();
	*p2 = x / t();
	*p = t() / *p2;
	dd_ar[0] = dd_ar[1] / t();
	xar[0] = *p / t();
}

double t()
{
	return(1.0);
}

/* double initialization tests */
struct {
	char ch;
	double f, g;
	float t, s;
	int i;
} ftx = {
	1, 2, 3L, 4L, 5, 6
};

float arf[] = { 0, 1L, 2.0, 3.0E0, 4, 5L, 0xfffff, 0xffffff, 0xfffffff };
double ard[] = { 0, 1L, 2.0, 3.0E0, 4, 5L, 0xfffff, 0xffffff, 0xfffffff };
double dpf = 34E12;
float spf = 34E12;

d_sizeof()
{
	int i;

	i = sizeof(arf);
	i = sizeof(ard);
}

/* double unary negative test */
double y_x;
double y_ar[3];

d_uneg(arg,arg2,p2)
double arg, arg2, *p2;
{
	double d, *p, xar[3];

	arg = -arg2;
	d = -*p;
	*p = -d;
	y_x = -*p2;
	*p2 = -y_x;
	*p = -*p2;
	y_ar[0] = -y_ar[1];
	xar[0] = -xar[1];
}

/* doubles returned from functions */

float fl();

double
d_funcret()
{
	double x, *p, ar[3];
	int i;

	switch (i) {
		case 1:  return(x);
		case 2:  return(*p);
		case 3:  return(ar[1]);
		case 4:  return(*p+x);
		case 5:  return(0);
		default: return(x-ar[1]);
	}
}

float
f_funcret()
{
	double x, *p, ar[3];
	int i;

	switch (i) {
		case 1:  return(x);
		case 2:  return(*p);
		case 3:  return(ar[1]);
		case 4:  return(*p+x);
		case 5:  return(0);
		default: return(x-ar[1]);
	}
}

d_ret()
{
	float x;
	double y;

	x = d_funcret();
	y = d_funcret();
	x = f_funcret();
	y = f_funcret();
	if ((x = f_funcret()) != 2.0);
}

/* double subtraction */
double x;
double ds_ar[3];

d_sub(arg,arg2,p2)
double arg, arg2, *p2;
{
	double d, *p, xar[3];
	char ch, *ptr;
	short shrt;

	arg = arg2 - arg;
	d = *p - ds_ar[1];
	*p = d - ds_ar[1];
	x = *p2 - x;
	*p = *p2 - x;
	*p2 = x - *p2;
	*p = *p2 - *p;
	ds_ar[0] = ds_ar[1] - *p;
	xar[0] = *p - xar[1];
}

/*********************************************
	Miscellaneous tests....
 *********************************************/

eq_op()
{
	char c;
	int i;
	float f;

	f = 2.0;

	c = 2;
	c *= f;
	if (c != 4) error(0x01);

	c = 2;
	c += f;
	if (c != 4) error(0x02);

	c = 2;
	c -= f;
	if (c != 0) error(0x03);

	c = 2;
	c /= f;
	if (c != 1) error(0x04);

	i = 20;
	i *= f;
	if (i != 40) error(0x05);

	i = 20;
	i += f;
	if (i != 22) error(0x06);

	i = 20;
	i -= f;
	if (i != 18) error(0x07);
	
	i = 20;
	i /= f;
	if (i != 10) error(0x08);
}
