/*
    Copyright 1984
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)tree.c	2.13	1/23/85
*/

#include "parser.h"
#ifndef NOSYS3
short strassign;
long strsize;   /* [vlh] 4.2 save structure size for assignment */
#endif
extern char cvmap[7][7];

/**
 * maketree - given operator, takes operands and builds up tree
 *      This takes the given operator, allocates a node for it
 *      and links up the subtrees on the operand stack.  A lot of
 *      work is in inserting the proper conversions.
**/
maketree(op)                        /* returns success or failure */
int op;                             /* new root operator*/
{
    register struct tnode *ltp, *rtp, *p;
    register short type, ltype, rtype, lconv, conv, pconv, docast;
    long left, right;

#ifdef DEBUG
    if (treedebug)
        printf("maketree op = %d\n",op);
#endif
    if( BINOP(op) ) {
        if(!(rtp=(struct tnode *)popopd()))
            return(0);
        rtype = (rtp=(struct tnode *)funcref(arrayref(rtp)))->t_type;
        PUTEXPR(treedebug,"maketree r",rtp);
    }
    else
        rtp = 0;
    if(!(ltp=(struct tnode *)popopd()))
        return(0);
    PUTEXPR(treedebug,"maketree l",ltp);
    if (op == ASM)      /* [vlh] 4.2 asm internal function */
        return(1);
    if (op == SIZEOF) { /* [vlh] 4.2 dosizeof */
        pushopd(cnalloc(USHORT,(short)dosizeof(ltp,1)));
        return(1);
    }
#ifndef NOWARN
if (BINOP(op))
    if (BINOP(op) && op!=CAST && rtp->t_op==SUB && ISSHORT((TYPE&ltp->t_type)))
       if (ISPOINTER(rtp->t_left->t_type) && ISPOINTER(rtp->t_right->t_type))
            warning("pointer subtraction yields a long result",0);
#endif
#ifndef NOSYS3
    if (op == FRETURN && ltp->t_type == VOID)   /* [vlh] 4.5 */
        error("void function cannot return a value");
#endif
    if (op != ADDR) {
        ltp = (struct tnode *)arrayref(ltp);
        if (op!=CALL && op!=NACALL)
            ltp = (struct tnode *)funcref(ltp);
    }
    else {  /* [vlh] 4.0 &p->array */
        if (ltp->t_op == ADD)   /* there must be a better way... */
            if (ltp->t_left->t_op==SYMBOL && ltp->t_right->t_op==CINT) {
                pushopd(ltp);
                return(1);
            }
    }
#ifdef DEBUG
    if(treedebug) 
        printf("tree: op %d ltype %d rtype %d\n",op,ltp->t_type,rtype);
#endif
    if( specops(op,ltp,rtp) )
        return( 1 );
    ltype = ltp->t_type;
    if (LINTEGRAL(op))
        integral(ltp,1);    /* integral type or long ok */
    if (RINTEGRAL(op))
        integral(rtp,1);    /* integral type or long ok */
    if (LVALOP(op) && ltp->t_op != SYMBOL && ltp->t_op != INDR &&
            ltp->t_op != BFIELD)
        error("assignable operand required");
    if( UNARYOP(op) ) {
        if(!unopeval(op,ltp))
            pushopd(tnalloc(op,ltype,ltp->t_dp,ltp->t_ssp,ltp,0L));
        return(1);
    }
    if (ltype == STRUCT || rtype == STRUCT) {
#ifndef NOSYS3
        if (op==ASSIGN) { /*[vlh]*/

            if(ltype != STRUCT) {
#ifndef NOWARN
                type = delsp(ltype);
                if (ISPOINTER(ltype) && (SIMPLE_TYP(type) || type==STRUCT))
                    warning("suspect structure assignment");
#endif
                ltp->t_type = rtp->t_type;
                ltp->t_ssp = rtp->t_ssp;
                ltp->t_dp = rtp->t_dp;
                ltype = STRUCT;
            }
            else if (ISCONST(rtp->t_op)) {  /* Struct == Constant */
                ltype = ltp->t_type = rtp->t_type;
                ltp->t_ssp = rtp->t_ssp;
                ltp->t_dp = rtp->t_dp;
                pushopd(ltp);
                pushopd(rtp);
                maketree(ASSIGN);
                return(1);
            }   /* [vlh] 4.8 */
            else if (rtype != STRUCT) {
#ifndef NOWARN
                type = delsp(rtype);
                if (ISPOINTER(rtype) && (SIMPLE_TYP(type) || type==STRUCT))
                    warning("suspect structure assignment");
#endif
                rtp->t_type = ltp->t_type;
                rtp->t_ssp = ltp->t_ssp;
                rtp->t_dp = ltp->t_dp;
                rtype = STRUCT;
            }
            left = dosizeof(ltp,0);             /* [vlh] 4.2 */
            if (rtp->t_op == NACALL || rtp->t_op == CALL) { /* [vlh] 4.6 */
                op = rtp->t_op;
                outexpr(rtp);
                rtp = enalloc(ltp);
                rtp->t_sc = REGISTER;
                rtp->t_type = POINTER|STRUCT;
                rtp->t_offset = 0;      /* register d0 */
                strsize = right = left;
            }
            else {
                strsize = right = dosizeof(rtp,0);  /* [vlh] 4.2 */
                if (left < right) { /* [vlh], 4.2 lhs smaller than rhs */
#ifndef NOWARN
                    warning("lhs of structure assignment smaller than rhs",0);
#endif
                    strsize = left;
                }
            }
            pushopd(ltp);
            maketree(ADDR);
            pushopd(rtp);
            if (op != NACALL && op != CALL) /* [vlh] 4.6 */
                maketree(ADDR);
            maketree(STRASS);
            strassign = 1;
            return(1);
        }
        else if (op == FRETURN) {   /* [vlh] 4.6 */
            strsize = dosizeof(frp,0);
            ltp = enalloc(rtp);
            ltp->t_offset = frp->t_offset;
            ltp->t_sc = STATIC;
            if (ISCONST(rtp->t_op)) {   /* [vlh] 4.8 */
                ltp->t_type = rtp->t_type;
                pushopd(ltp);
                pushopd(rtp);
                maketree(ASSIGN);
            }
            else {
                pushopd(ltp);
                maketree(ADDR);
                pushopd(rtp);
                maketree(ADDR);
                maketree(STRASS);
                strassign = 1;
            }
            return(1);
        }
        else
#endif
        {
            ltype = rtype = INT;
            error("illegal structure operation");
        }
    }
    type = ltype;
    if( rtype == TYPELESS ) {
        rtp->t_type = rtype = INT;
        lconv = conv = 0;
    }
    else {
        lconv = ttoconv(ltype);
        conv = ttoconv(rtype);
        if (ASGNOP(op) || lconv >= conv) {
            conv = cvmap[lconv][conv];
            lconv = 0;
        }
        else {
            conv = cvmap[conv][lconv];
            lconv = 1;
            type = rtype;
        }
    }
    if (!hfpflag && (conv==DB_FL||conv==FL_DB)) /* [vlh] 4.7 */
        conv = 0;
    if (ASGNOP(op)) {
        if (op == ASSIGN || op == FRETURN) {
            if (rtp->t_op != CINT && (conv == SI_PT || conv == UI_PT)) {
                conv = SI_SL;   /* [vlh] 4.3 */
#ifndef NOWARN
                warning("short assigned to pointer",0);
#endif
            }
#ifndef NOWARN
            else if (conv == PT_SI) /* [vlh] 4.7 */
                warning("pointer assigned to short",0);
#endif
        }
        if (op == ASSIGN || op == CAST)
            switch (conv) {

                case SI_PT: /* signed int => pointer */
                case UI_PT: /* unsigned int => pointer */
                case PT_PT: /* pointer => pointer */
                case PT_SL: /* pointer => signed int */
                case SL_PT: /* signed long => pointer */
                    conv = 0;
                    break;
            }
    }
    else if ((op == COLON && SUPTYPE(ltype) != 0 && ltype==rtype) ||
            (RELOP(op) && (conv==PT_PT || conv==SL_PT || conv==PT_SL)) ||
            (BINOP(op) && (ltp->t_op==CINT || ltp->t_op==CLONG) &&
                (rtp->t_op == CINT || rtp->t_op == CLONG)))
        conv = 0;
    pconv = 0;
    if (RELOP(op) && (conv == SI_PT || conv == SL_PT) && /* [vlh] 3.4 */
            (ISALLTYPE(ltype) == (STRUCT|POINTER) || 
                ISALLTYPE(ltype) == (FRSTRUCT|POINTER)))
        conv = 0;   /* short compare to struct pointer, no conversion */
    if (op==FRETURN && conv == SL_PT)
        conv = 0;
    if (conv == PT_PT) {
        conv = 0;
        if (op == SUB) {
            type = LONG;
            pconv++;
        }
#ifndef NOWARN
        else if(op != FRETURN && ( (ISALLTYPE(ltype) != ISALLTYPE(rtype) ||
                    ISALLTYPE(ltype) != (POINTER|CHAR)) ) )
            warning("suspect conversion operation",0);
#endif
    }
    if (op == CAST)
        docast = ((ISCHAR(ltp->t_type)) && !(ISCHAR(rtp->t_type)));
    if( conv ) {
        if( conv == BADCV )
            error("illegal type conversion");
        else if( lconv )
            ltp = (struct tnode *)cvopgen(ltp,type,conv,psize(rtp),op);
        else
            rtp = (struct tnode *)cvopgen(rtp,type,conv,psize(ltp),op);
    }
    if (op == CAST) {   /* [vlh] 4.0 */
        if (docast) /* predefined to handle conv/cast ops */
#ifndef NOSYS3
            rtp = tnalloc((ltp->t_type!=UCHAR)?TOCHAR:TOUCHAR,CHAR,0,0,rtp,0L);
#else
            rtp = tnalloc(TOCHAR,CHAR,0,0,rtp,0L);
#endif
        else if ((((ltype&~TYPE)>>SUTYPLEN)!=(FUNCTION|(POINTER>>SUTYPLEN))) &&
                    (ltype&POINTER) && rtype==INT) {
            rtp = cvopgen(rtp,type,SI_SL,psize(ltp),op);
        }   /* [vlh] 4.5, test against FUNCTION-POINTER conversion */
        else if (!conv) {
            if (!(ISCHAR(rtp->t_type))) {
                rtp->t_type = ltp->t_type;
                rtp->t_ssp = ltp->t_ssp;    /* [vlh] 3.4 */
                if(rtp->t_op != BFIELD)     /* [vlh] 4.3, bitfield condition */
                    rtp->t_dp = ltp->t_dp;  /* [vlh] 3.4 */
            }
#ifndef NOSYS3
            else if(UNSIGN(ltp->t_type))
                rtp->t_type = UCHAR;
#endif
        }
        pushopd(rtp);
    }
    if( RELOP(op) )
        type = INT;
    if(op != CAST && !binopeval(op,ltp,rtp)) {
        if (ISSTRUCT(ltype) || !(ISSTRUCT(rtype)))
            p = ltp;
        else
            p = rtp;
        p = (struct tnode *)tnalloc(op,type,p->t_dp,p->t_ssp,ltp,rtp);
        pushopd(p);
    }
    if( pconv && ltype != (POINTER|CHAR) ) {
        if(!(ltp=(struct tnode *)popopd()))
            return(0);
        pushopd(cvopgen(ltp,LONG,PT_SL,psize(ltp->t_left),op));
    }
    return(1);
}

/* specops - handle special operators in building tree*/
specops(op,ltp,rtp)             /* returns 1 if op special, 0 otherwise*/
int op;                         /* operator*/
struct tnode *ltp;              /* left subtree pointer*/
struct tnode *rtp;              /* right subtree pointer*/
{
    register short type;

    type = ltp->t_type;
#ifdef DEBUG
    if (treedebug)
        printf("specops: op = %d type = %d\n",op,type);
    if (ltp)
        PUTEXPR(treedebug,"specops ltp",ltp);
    if (rtp)
        PUTEXPR(treedebug,"specops rtp",rtp);
#endif
    switch (op) {

    case 0:
        break;

    default:
        return(0);

    case APTR:                          /*expr -> name*/
        /*integral(ltp,1);              /*we need to turn expr into a*/
        ltp->t_type = POINTER|STRUCT;   /*pointer to a struct, then use*/
        pushopd(ltp);                   /*expr . name stuff*/
        maketree(INDR);
        ltp = (struct tnode *)popopd(); /*ltp cannot be 0*/
    case PERIOD:                        /*expr . name*/
        if (!(ISSTEL(rtp)))
            error("invalid structure member name");
        type = rtp->t_type;
        if( ISARRAY(type) ) {
            type = delspchk(type);
            rtp->t_dp++;
        }
#ifndef NOSYS3
        if (ltp->t_type == STRUCT && (ltp->t_op == CALL ||
                ltp->t_op == NACALL)) { /* [vlh] 4.6 */
                outexpr(ltp);
                ltp = snalloc(POINTER|STRUCT,REGISTER,0,ltp->t_dp,ltp->t_ssp);
                tadjust(ltp,type,rtp->t_dp,rtp->t_ssp);
                ltp->t_type = addsp(ltp->t_type,POINTER);
                pushopd(ltp);
        }   /* register d0... */
        else {
#endif
            tadjust(ltp,type,rtp->t_dp,rtp->t_ssp);
            pushopd(ltp);
            maketree(ADDR);
#ifndef NOSYS3
        }
#endif
        pushopd(cnalloc(TYPELESS,rtp->t_offset));
        maketree(ADD);
        if( NOTARRAY(rtp->t_type) )
            maketree(INDR);
        ltp = (struct tnode *)popopd();
        if( rtp->t_sc == BFIELDCL )     /*ltp cannot be 0*/
            ltp = tnalloc(BFIELD,type,rtp->t_dp,rtp->t_ssp,ltp,0L);
        break;

    case QMARK:
        if( rtp->t_op != COLON )
            error("invalid ?: operator syntax");
        else if( ltp->t_op == CINT && rtp->t_left->t_op == CINT &&
                rtp->t_right->t_op == CINT )
            ltp->t_value = ltp->t_value ? rtp->t_left->t_value :
                    rtp->t_right->t_value;
        else
            ltp = (struct tnode *)tnalloc(op,rtp->t_type,0,0,ltp,rtp);
        break;

#ifndef NOSYS3
    case STRASS:    /* [vlh] */
        ltp = (struct tnode *)tnalloc(op,(int)strsize,0,0,ltp,rtp);
        break;
#endif
    
    case LRCOMMA:   /* [vlh] 4.7, type of right instead of INT !!! */
    case COMMA:     /* [vlh] 4.5, type of right instead of INT !!! */
        ltp = (struct tnode *)tnalloc(op,rtp->t_type,0,0,ltp,rtp);
        break;

    case LAND:                          /* don't need conversion here */
    case LOR:
        ltp = (struct tnode *)tnalloc(op,INT,0,0,ltp,rtp);
        break;

    case INDR:
        if (ltp->t_op == ADDR) {        /**& is null op*/
            if (BTYPE(ltp->t_type)!=BTYPE(ltp->t_left->t_type)) { /*[vlh] 4.5*/
                ltp->t_left->t_type = 
                    (ltp->t_left->t_type & ~TYPE) | BTYPE(ltp->t_type);
                ltp->t_left->t_dp = ltp->t_dp;
                ltp->t_left->t_ssp = ltp->t_ssp;
            }
            ltp = ltp->t_left;
        }
        else {
            if( ISFUNCTION(type) )
                error("indirection on function invalid");
            ltp = (struct tnode *)tnalloc(INDR,delspchk(type),ltp->t_dp,
                                                       ltp->t_ssp,ltp,0L);
        }
        break;

    case NACALL:
    case CALL:
        if (NOTFUNCTION(type))
            error("illegal call");
#ifdef DEBUG
    if(treedebug)
    printf("FCALL: op %d ltp type %d rtp type %d\n",op,ltp->t_type,rtp->t_type);
#endif
        ltp = (struct tnode *)tnalloc(op,delspchk(type),ltp->t_dp,ltp->t_ssp,
                                                 ltp,rtp);
        break;

    case ADDR:
        if (ltp->t_op == INDR) {    /*&* is null op*/
            if (BTYPE(ltp->t_type)!=BTYPE(ltp->t_left->t_type)) { /*[vlh] 4.5*/
                ltp->t_left->t_type = 
                    (ltp->t_left->t_type & ~TYPE) | BTYPE(ltp->t_type);
                ltp->t_left->t_dp = ltp->t_dp;
                ltp->t_left->t_ssp = ltp->t_ssp;
            }
            ltp = ltp->t_left;
        }
        else if( ltp->t_op == SYMBOL ) {
            if( ((struct symnode *)ltp)->t_sc == REGISTER )
                error("address of register");
            ltp = (struct tnode *)tnalloc(ADDR,addsp(type,POINTER),ltp->t_dp,
                                                    ltp->t_ssp, ltp,0L);
        }
        else
            error("& operator illegal");
        break;
    }
    pushopd(ltp);
    return(1);
}

/* cvopgen - generate a conversion operator*/
/*      Generates conversions necessary for integers, pointers and longs.*/
char *
cvopgen(tp,type,conv,len,op)        /* returns pointer to conv node*/
struct tnode *tp;                   /* pointer to node to do conversion*/
int type;                           /* type to convert to*/
int conv;                           /* specified conversion*/
long len;                           /* object length [vlh] 3.4 i=>l */
int op;                             /* for cast operator*/
{
    register struct tnode *rtp;
    register short cop;
    double dtmp;
#ifdef DEBUG
    if (treedebug) {
        printf("cvopgen: type=%d conv=%d op=%d ",type,conv,op);
        printf("- type=%d op=%d\n",tp->t_type,tp->t_op);
    }
#endif

    if (len==0 && ((type & 0220)==0220)) {  /* [vlh] 4.4 */
#ifndef NOWARN
        if(op != CAST && op != FRETURN)
            warning("coercion to function pointer",0);
#endif
        len = 1;
        type = POINTER|CHAR;
    }

    switch(conv) {

    case SI_PT: /* signed int => pointer */
    case UI_PT: /* unsigned int => pointer */
        if ((type == (POINTER|CHAR) || ISALLTYPE(type) == (POINTER|STRUCT)) &&
            (op == CAST || op == FRETURN)) {    
            cop = INT2L;    /* [vlh] 4.0 */
            break;
        }
        else
            if( op == CAST || op == FRETURN || op == COLON) { /*[vlh]4.4COLON*/
                cop = INT2L;        /*of the ptd to objects length plus*/
                if( len != 1L ) {   /*an integer to long conversion*/
                    rtp = (struct tnode *)cnalloc(INT,(int)len);
                    if(binopeval(MULT,tp,rtp))  /* [vlh] 4.3 */
                        tp = popopd();
                    else
                        tp = (struct tnode *)tnalloc(MULT,type,0,0,tp,rtp);
                }
                break;
            }
    case PT_SL: /*need to generate mult or div*/
    case SL_PT: /*of the ptd to objects length*/
        if (len == 1 || RELOP(op))	/* [vlh] 4.9 RELOP check */
            return((char *)tp);
        cop = (conv == PT_SL ? DIV : MULT);
        rtp = (struct tnode *)cnalloc(INT,(int)len);
        if (binopeval(cop,tp,rtp))  /* [vlh] 4.3 */
            return( popopd() );
        break;

    case SI_SL: /*signed short => signed long*/
        if (tp->t_op == CINT) /* [vlh] 4.1 constant conversion */
            return(lcnalloc(type,(long)((struct conode *)tp)->t_value));
    case UL_SL: /*unsigned int => signed long*/
        cop = INT2L;
        break;
    
    case SI_UL: /*signed short => unsigned long, [vlh] 4.4*/
    case UI_SL: /*unsigned short => signed long*/
        if (tp->t_op == CINT) /* [vlh] 4.1 constant conversion */
            return(lcnalloc(type,(long)(unsigned short)tp->t_value));
        cop = INT2UL;
        break;

    case SI_FL: /*signed int => float, [vlh] 3.4*/
    case UI_FL: /*unsigned int => float*/
        if (tp->t_op != CINT) {
            cop = INT2F;
            break;
        }
    case SL_FL: /*signed long => float, [vlh] 3.4*/
        if (conv==SL_FL && tp->t_op != CLONG) {
            cop = LONG2F;
            break;
        }
        dtmp = (tp->t_op == CINT) ? tp->t_value : tp->t_lvalue;
        if (fflag) {    /* constant conversion */
            toffp(dtmp);
            return(fpcnalloc());
        }
        else {          /* constant coercion */
            toieee(dtmp,eflag);
            tp = fpcnalloc();
            if (eflag)
                return(tp);
            cop = DTOF;
        }
        break;

    case FL_SL: /*double => signed long, [vlh] 3.4*/
    case DB_SL: /*float => signed long, [vlh] 3.4*/
        cop = FLOAT2L;
        break;

    case DB_SI: /*double => signed/unsigned int, [vlh] 3.4*/
    case FL_SI: /*float => signed/unsigned int, [vlh] 3.4*/
        cop = FLOAT2I;
        break;

    case SL_SI: /*signed long => signed int*/
    case SL_UI: /*signed long => unsigned int*/
    case PT_SI: /*pointer => signed/unsigned int*/
        cop = LONG2I;
        break;

    case FL_DB: /*float => double, [vlh] 4.7*/
        cop = FTOD;
        break;

    case DB_FL: /*double => float, [vlh] 4.7*/
        cop = DTOF;
        break;

    default:
        error("invalid conversion %d",conv);
        return((char *)tp);
    }
    return( tnalloc(cop,type,0,0,tp,rtp) );
}

/* tadjust - expression tree type adjustment*/
/*      Adjusts the types of subtrees to agree with the top of the tree.*/
tadjust(tp,type,dp,ssp)             /* returns - none*/
struct tnode *tp;                   /* pointer to tree*/
int type;                           /* type to adjust to*/
int dp;                             /* dimension pointer or info*/
int ssp;                            /* structure pointer*/
{
    register short op;

    tp->t_type = type;
    if( dp >= 0 ) {
        tp->t_dp = dp;
        tp->t_ssp = ssp;
    }
    if( (op=tp->t_op) == ADDR )
        type = delspchk(type);
    else if( op == INDR )
        type = addsp(type,POINTER);
    else if( op != ADD && op != SUB )
        return;
    tadjust(tp->t_left,type,dp,ssp);
}

/**
 * funcref - handle tree function reference
 *      Turns a reference to a function into the address of the function.
**/
char *
funcref(tp)                         /* returns pointer to node*/
struct tnode *tp;                   /* pointer to old node*/
{
    if (ISFUNCTION(tp->t_type) )
        tp = (struct tnode *)tnalloc(ADDR,addsp(tp->t_type,POINTER),tp->t_dp,
            tp->t_ssp,tp,0L);
    return((char *)tp);
}

/* arrayref - handle tree array reference*/
/*      Turns a reference to an array into the address of the array.*/
char *
arrayref(tp)                    /* returns pointer to tree node*/
struct tnode *tp;                   /* tree node pointer*/
{
    register short dp;

    if( ISARRAY(tp->t_type) && !(ISSTEL(tp)) ) {
        tp->t_dp++;
        dp = tp->t_dp;
        pushopd(tp);
        tadjust(tp,delspchk(tp->t_type),-1,0);
        maketree(ADDR);
        tp = (struct tnode *)popopd();              /*tp cannot be 0*/
        tp->t_dp = dp;  /* 4.1 [vlh] get proper dp !!!! */
    }
    return((char *)tp);
}

/* ttoconv - maps normal type into conversion table type*/
ttoconv(type)                       /* returns conversion type*/
int type;                           /* type to convert*/
{
    switch(type) {

        case CHAR:
        case SHORT: /* same as INT */
            return(0);

#ifndef NOSYS3
        case UCHAR:
#endif
        case USHORT:    /* same as UNSIGNED */
            return(1);

        case LONG:
            return(2);
#ifndef NOSYS3
        case ULONG:     /* [vlh] 4.4 */
            return(3);
#endif
#ifndef NOFP
        case FLOAT:
            return(5);

        case DOUBLE:    /* [vlh] 4.7 */
            return(6);
#endif

        default:
            return(4);
    }
}
