/*
    Copyright 1982, 1983, 1984
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)init.c	2.15 1/29/85
*/

#include "parser.h"

#define NULL    (char *)0

short inittype;

short bfield_ty;    /* [vlh] 4.2 type of bit field currently initializing */
long  bits_init;    /* [vlh] 4.2 current bit field init value */
short in_bitinit;   /* [vlh] 4.2 initializing a bit field ?? */
short lst_boffset;  /* [vlh] 4.2 new bit field entity ?? */

#define BCHK(plus) {plus = out_bfield(CHAR); nbout += plus; nbleft -= plus;}

/*
 * doinit - do external definition initialization
 *      Handles following C syntax:
 *          initializer:
 *                  = constant_expression
 *                  = { initializer_list }
 *                  = { initializer_list , }
 *          initializer_list:
 *                  constant_expression
 *                  initializer_list , initializer_list
 *                  { initializer_list }
 */
#ifndef SYM_TO_DSK
doinit(sp)                          /* returns number of elements init'ed*/
#else
doinit(sp,sp_addr)                  /* returns number of elements init'ed*/
long sp_addr;
#endif
struct symbol *sp;                  /* pointer to symbol to init*/
{
    register short type;
    long isize, datasize;
    struct symbol *sdp;
#ifdef SYM_TO_DSK
    struct symbol sdp_entry;
    long save_addr;
#endif

    type = sp->s_type;
    datasize = dsize(type,sp->s_dp,sp->s_ssp);
    if( PEEK(COMMA) || PEEK(LRCOMMA) || PEEK(SEMI) ) {   /*no initialization*/
        isize = WALIGN(datasize);
#ifdef DEBUG
    if(initdebug) 
        printf("%s sc %x attrib %x\n",sp->s_symbol,sp->s_sc,sp->s_attrib);
#endif
        if( sp->s_sc == EXTERNAL )
            OUTCOMMON(sp->s_symbol,isize);
        else if (sp->s_sc == DEXTERN) { /* explicitly EXTERN */
            sp->s_sc = EXTERNAL;
#ifdef VERSADOS
            if (!vdosrom)   /* [vlh] 4.7, generate an xref instead of a */
                OUTCOMMON(sp->s_symbol,isize);      /* named section */
#endif
#ifdef SYM_TO_DSK
            write_st(sp,sp_addr);
#endif
        }
        else {
            OUTBSS();               /*bss segment*/
            OUTLAB(sp->s_offset);
            OUTRESMEM(isize);
            OUTTEXT();              /*resume text segment*/
        }
    }
    else {
#ifdef SYM_TO_DSK
        ASSG(save_addr,tdp_addr,sdp_entry,tdp_entry,sdp);
#else
        sdp = tdp;
#endif
        tdp = 0L;
#ifndef NOWARN
        if (!(next(ASSIGN)))               /*ignore '=' if there*/
             warning("old fashion initialization",0);
#endif
        if( type == LONG || ISPOINTER(type) )
            outldata();
#ifndef NOFP
        else if (type == DOUBLE)    /*[vlh] 4.7*/
            outdfpdata();
        else if (type == FLOAT)    /*[vlh] 3.4*/
            outfpdata();
#endif
        else
            outdata();
        if( sp->s_sc == EXTERNAL )
            OUTDLAB(sp->s_symbol);
        else
            OUTLAB(sp->s_offset);
        isize = initlist(sp, sp->s_type, sp->s_dp, sp->s_ssp);
        if( isize < datasize ) {
            OUTRESMEM(datasize-isize);
            isize = datasize;
        }
        if( WALIGN(isize) != isize )
            OUTPAD();
        if( isize > datasize ) {
            if( ISARRAY(sp->s_type) ) {
                for( type = sp->s_type; ISARRAY(type); type = delsp(type) )
                    ;
                dtab[sp->s_dp] = (isize / dsize(type,sp->s_dp,sp->s_ssp));
            }
            else
                error("too many initializers (%d)",(int)(isize-datasize));
        }
        if( sp->s_sc == STATIC )
            OUTTEXT();
#ifdef SYM_TO_DSK
        ASSG(tdp_addr,sdp_addr,tdp_entry,save_entry,tdp);
#else
        tdp = sdp;
#endif
    }
}

/*
 * initlist - handles initializer lists
 *      This handles multi-level braces, and a character pointer pointing
 *      to a string.  Most of the work is in keeping track of how many
 *      bytes are left on the current "row", and outputting padding if
 *      necessary.
 */
long
initlist(sp,type,dp,ssp)            /* returns size of initializers in bytes*/
struct symbol *sp;                  /* [vlh] 4.2 for use in struct init */
int type, dp, ssp;
{
    register short onetype, plus, atype, odp;
    long datasize, i, j, elsize, nbleft, nbout;    /* [vlh] 3.4 int=>long */
#ifdef SYM_TO_DSK
    struct symbol par_str;      /* parent structure.... */
#endif

    i = (next(LCURBR));
    odp = dp;   /* [vlh] 4.9 added odp */
    for( onetype = type; ISARRAY(onetype); onetype = delsp(onetype) )
        odp--;  /* [vlh] 4.9 added odp */
#ifdef DEBUG
    if (initdebug)  {
        printf("type: %d BTYPE %d ISARRAY %d ",type,BTYPE(type),ISARRAY(type));
        printf("POINTER %d\n",ISPOINTER(type));
        printf("onetype: %d BTYPE %d ",onetype,BTYPE(onetype));
        printf("ISARRAY %d POINTER %d\n",ISARRAY(onetype),ISPOINTER(onetype));
    }
#endif
    nbout = 0;
    datasize = dsize(type,dp,ssp);
    nbleft = 0;                     /*keep track of no. of bytes left*/
    atype = (ISARRAY(type)) ? delsp(type) : type; /*[vlh]4.2 multi dimens */
    if(ISARRAY(type) && SIMPLE_TYP((type & ~SUPTYP)))
        nbout = str_init(datasize,type);    
    else if(ISARRAY(atype) && SIMPLE_TYP((atype & ~SUPTYP))) {
        datasize = dsize(atype,dp,ssp);
        elsize = dsize(atype,dp+1,ssp);
        if( !i )
            error("missing { in initialization");
        do {
            j = (next(LCURBR));
            nbout += str_init(elsize,atype);
            if (j && !(next(RCURBR)))
                error("missing } in initialization");
            next(COMMA);        /* skip over comma... */
        } while(!PEEK(RCURBR) && !PEEK(SEMI));
        nbleft = datasize - nbout;
        if ((elsize==SHORTSIZE && ISSHORT(onetype)) ||
                    (elsize==CHARSIZE && (ISCHAR(onetype))) || 
                    (elsize==LONGSIZE && (ISLONG(onetype))) || 
                    (datasize==elsize)) /*undimensioned array*/
            nbleft = 0; 
        if (nbleft < 0) {
            error("initializer list too long");
            nbleft = 0;
        }
    }   /* multi-dimensional array */
    else if (BTYPE(type)==STRUCT && NOTPOINTER(type) && ISPOINTER(onetype)) {
        nbleft = elsize = PTRSIZE;  /* [vlh] 4.2.f */
        if( !i )
            error("missing { in initialization");
        do {
            nbleft = s_or_a(POINTER|CHAR,elsize,&nbout,nbleft,NULL,NULL);
            next(COMMA);        /* skip over comma... */
        } while(!PEEK(RCURBR) && !PEEK(SEMI));
    }
    else if (ISARRAY(type) || (BTYPE(type)==STRUCT && NOTPOINTER(type))) {
        if (ISARRAY(type))
            nbleft = elsize = dsize(delsp(type),dp,ssp);
        else
            nbleft = elsize = dsize(onetype,odp,ssp);   /* was dp+1 */
            /* [vlh] 4.2, added proper handling of structure init... */
        if( !i && BTYPE(type)==STRUCT )
            error("missing { in initialization");
        do {
#ifdef DEBUG
    if (initdebug) printf("s_or_a call #2\n");
#endif
#ifndef SYM_TO_DSK
            nbleft = s_or_a(onetype,elsize,&nbout,nbleft,sp->s_par,NULL);
#else
            read_st(&par_str,sp->s_par);
            nbleft = s_or_a(onetype,elsize,&nbout,nbleft,&par_str,NULL);
#endif
            next(COMMA);        /* skip over comma... */
        } while(!PEEK(RCURBR) && !PEEK(SEMI));
    }
    else {
        indecl = 0;                 /* [vlh] 4.2 */ 
        nbout = oneinit(onetype,dp,(int)sp->s_sc);
    }
    if (in_bitinit) 
        BCHK(plus)  /* [vlh] 4.2 bit field initialization */
    if( nbleft && (nbleft != elsize)) {  /*pad current row*/
        OUTRESMEM(nbleft);
        nbout += nbleft;
    }
    if (i) {
        next(COMMA);        /* [vlh] 4.2 skip over extra comma */
        if (!(next(RCURBR)))
            error("missing } in initialization");
    }
    return(nbout);
}

#ifndef SYM_TO_DSK
#   define COPY(c,s) c = s
#   define HCOPY(c,s) c = s
#else
#   define COPY(c,s) c_addr = s; c = &child_str; read_st(c,c_addr)
#   define HCOPY(c,s) c_addr = s; c = &hold_str; read_st(c,c_addr)
#endif
#ifndef NOSYS3
#   define BASIC_AR(x) (x==(ARRAY|CHAR)||x==(ARRAY|INT)||x==(ARRAY|LONG)|| \
                       x==(ARRAY|UCHAR)||x==(ARRAY|USHORT)||x==(ARRAY|ULONG))
#else
#   define BASIC_AR(x) (x==(ARRAY|CHAR)||x==(ARRAY|INT)||x==(ARRAY|LONG))
#endif
#define DOCHILD(c,s,o) if(!c) { if (!s->s_child) break; \
        else { COPY(c,s->s_child); } } o = c->s_type
/**
 * s_or_a - initialize structure or array
 *      routine to deal with initializing structures and arrays and
 *      assure that structures are aligned properly.  Checks initializers
 *      with the expected type.
 *      Attempts to match structure initializations against the 
 *      elements of the structure.
 *      sp -- pointer to structure symbol table entry
**/
long
s_or_a(original,elsize,pnbout,bleft,sp,child) /* returns nbleft */
int original;       /* [vlh] original type... */
long elsize, bleft, *pnbout;
struct symbol *sp;                  /* [vlh] 4.2 for use in struct init */
struct symbol *child;               /* [vlh] 4.2 for use in struct init */
{
    register long nbleft, nbout;
    register short onetype, plus;
    long i, temp, datasize, addup, x;
    short nest, anest;  /* [vlh] 4.2 nest <= number of LCURBR */
    struct symbol *hold;
#ifdef SYM_TO_DSK
    long c_addr;
    struct symbol child_str;        /* child structure */
    struct symbol hold_str;         /* hold structure */
#endif

#ifdef DEBUG
    if (initdebug) 
        printf("s_or_a: [%s] elsize %ld\n",(sp) ? sp->s_symbol : "",elsize);
#endif
    nbleft = bleft; nbout = *pnbout; onetype = original; nest = i = 0;
    do {                        /*in current row.*/
restart:
        if (BTYPE(original) == STRUCT) {    /* [vlh] 4.3 */
            DOCHILD(child,sp,onetype);
        }
        if (PEEK(SEMI) || PEEK(EOF) || PEEK(RCURBR))
            break;
        anest = (next(LCURBR));     /* [vlh] 4.4, nested? struct? array? */
        if ((nbleft & 1) && !ISBTCHAR(onetype)) {   /* [vlh] 4.7 */
            nbleft--;
            nbout++;
            OUTEVEN();
        }   /* char followed by struct.... */
        if (child && onetype == STRUCT) {   /* [vlh] 4.3 */
            temp = nbout;
#ifdef DEBUG
            if (initdebug) {
                printf("child is [%s], ",child->s_symbol);
                if (child->s_par) 
                    printf("child parent [%s], ",child->s_par->s_symbol);
                else
                    printf("parentless child, ");
                if (child->s_child) 
                    printf("child child [%s]\n",child->s_child->s_symbol);
                else
                    printf("childless child\n");
            }
#endif
            HCOPY(hold,child->s_child); /* was s_child => s_par => s_child */
            i = dsize(onetype,(hold->s_dp)+1,hold->s_ssp);
#ifdef DEBUG
            if (initdebug)
                printf("s_or_a recursing child onetype is STRUCT\n");
#endif
            s_or_a(onetype,i,&temp,i,hold,NULL);
            if (!anest && !peektok)
                peektok = COMMA;    /* [vlh] 4.2 put it back.... */
            goto past;
        }
        else if (anest && original==STRUCT && ISCARR(onetype) && PEEK(STRING)) {
            peektok = STRING;
            goto dorecurse;
        }
        else if (BASIC_AR(original)) {  /* [vlh]4.2 simple arrays */
#ifdef DEBUG
    if (initdebug) printf("BASIC_AR original %d\n",(int)elsize);
#endif
            i = str_init(elsize, original); /* 4.9 */
        }
        else if (BASIC_AR(onetype)) {   /* [vlh]4.2 simple arrays */
            datasize = dsize(onetype,child->s_dp,child->s_ssp);
            i = str_init(datasize, onetype);
        }
        else if (ISARRAY(onetype)) {    /* [vlh] 4.2 */
            addup = 0;      /* array of structures or arrays */
            temp = nbout;
            i = dsize(onetype,child->s_dp,child->s_ssp);
            onetype = delsp(onetype);
            datasize = dsize(onetype,child->s_dp+1,child->s_ssp);
            if (child->s_child != 0)
                HCOPY(hold,child->s_child);
            else 
                HCOPY(hold,child);
            x = onetype & ~POINTER;     /* [vlh] 4.3, simple pointer */
            if( SIMPLE_TYP(x) ) {
                for(addup=0; addup != i; addup += datasize) {
                    if (PEEK(RCURBR) || PEEK(SEMI)) {
                        OUTRESMEM(i);
                        break;
                    }   /*[vlh] 4.3, no more initializers */
                    oneinit(onetype,hold->s_dp,(int)hold->s_sc);
                    next(COMMA);
                }
                if (!peektok && !anest)
                    peektok = COMMA;    /* [vlh] 4.2 put it back.... */
            }       /* simple array */
            else    /* not a simple array type... */
                for(addup=0; addup != i; addup += datasize) {
#ifdef DEBUG
            if (initdebug) printf("s_or_a recurse ! simple array 0%o $%lx\n",
                                      onetype,hold);
#endif
                    x = s_or_a(onetype,datasize,&temp,datasize,hold,NULL);
                    if (x) {    /*[vlh] 4.3, no init for current item*/
#ifdef DEBUG
    if (initdebug) printf("!simple left %d\n",(int)x);
#endif
                        OUTRESMEM(i - (addup + datasize - x));
                        break;
                    }
                }
        }   /* complicated array type */
        else if (anest) {   /* main loop recursing */
dorecurse:
#ifdef DEBUG
    if(initdebug) printf("structure curly brace nesting.....\n");
#endif
            nest++;
            if (in_bitinit) 
                BCHK(plus) /* [vlh] 4.2 bit field initialization */
            if( nbout && nbleft && (nbleft<elsize)) {
                OUTRESMEM(nbleft);  /*pad rest of current row*/
                nbout += nbleft;
                nbleft = 0;
            }
            if (!nbout && !nbleft)
                goto restart;
            if( i > elsize )
                error("initializer list too long");
            child = 0;  /* force restart of structure match up */
            goto restart;
        }
        else {  /* simple type....... not array or struct or nested... */
            if ((nbleft & 1) && !(ISCHAR(onetype))) {
                nbleft--;
                nbout++;
                OUTEVEN();
            }
            if (!child)     /* mra/vlh4.2+ don't access off of zero !!! */
                i = oneinit(onetype,0,0);
            else
                i = oneinit(onetype,child->s_dp,(int)child->s_sc);
        }
past:
            /* force release of matched curbr */
        if (anest && !next(RCURBR))
            error("mismatched curly braces");   /* [vlh] 4.4 */
        nbout += i;
        if ( !nbleft && !SIMPLE_TYP(original) )
            nbleft = elsize;
        if( i > nbleft )
            error("initializer alignment");
        nbleft = (i >= nbleft) ? 0 : nbleft - i;
        if (BTYPE(original)==STRUCT) {  /* [vlh] 4.2, get next child */
            if (!child->s_sib) {    /* [vlh] 4.2 at end... */
                plus = (in_bitinit) ? out_bfield(CHAR) : 0;
                nbout += nbleft;
                nbleft -= plus;
                if ( nbleft ) { /* was checking against elsize */
                    OUTRESMEM(nbleft);
                    nbleft = 0;
                }
                if (SUPTYPE(original) != ARRAY)
                    break;
            }
            else {
                COPY(child,child->s_sib);
            }
#ifdef DEBUG
    if(initdebug) 
    printf("Basetype is STRUCT child [%s]\n",child ? child->s_symbol : "");
#endif
        }
#ifdef DEBUG
    if (initdebug) printf("COMMA while nbleft %ld nbout %ld\n",nbleft,nbout);
#endif
    } while (next(COMMA) && (nbleft>0));    /* [vlh] 4.9 nbleft test */
    if (BTYPE(original)==STRUCT) {  /* [vlh] 4.2, ensure padding... */
        plus = (in_bitinit) ? out_bfield(CHAR) : 0;
        nbout += nbleft;
        if ( nbleft ) { /* was checking against elsize */
            OUTRESMEM(nbleft);
            nbleft = 0;
        }
    }
    *pnbout = nbout;
    while(nest--) {
        next(COMMA);        /* comma's may separate.... */
        if (!next(RCURBR))  /* force release of matched curbr */
            error("mismatched curly braces");
    }
    next(COMMA);        /* comma's may separate.... */
#ifdef DEBUG
    if(initdebug) printf("s_or_a exit: peektok %d\n",peektok);
#endif
    return(nbleft);
}

#define UNDIMC(btype,s) (s==CHARSIZE && ISCHAR(btype))
#define UNDIMI(btype,s) (s==SHORTSIZE && ISSHORT(btype))
#define UNDIML(btype,s) (s==LONGSIZE && ISLONG(btype))
#ifndef NOFP
#   define UNDIMF(btype,s) (s==LONGSIZE && btype==FLOAT)
#   define UNDIMD(btype,s) (s==DOUBSIZE && btype==DOUBLE)
#else
#   define UNDIMF(btype,s) 0
#   define UNDIMD(btype,s) 0
#endif
/**
 * str_init - string (array) initialization         [vlh] 4.2
 *      initialize a character array, truncating or padding as required
**/
long
str_init(datasize,type)
long datasize;
int type;       /* should not get a bit field here..... */
{
    register long maxsize, output;
    register short btype;

#ifdef DEBUG
    if (initdebug) printf("str_init: type %d, datasize %ld\n",type,datasize);
    if (initdebug) printf("str_init: SUPTYPE %d, ",SUPTYPE(type));
    if (initdebug) printf("BTYPE %d ",BTYPE(type));
#endif
    output = 0L;
    btype = BTYPE(type);
    if (UNDIMC(btype,datasize) ||       /* undimensioned char array */
              UNDIMI(btype,datasize) || /* undimensioned int array */
              UNDIML(btype,datasize) || /* undimensioned long array */
              UNDIMF(btype,datasize) || /* undimensioned float array */
              UNDIMD(btype,datasize)) { /* undimensioned double array */
#ifdef DEBUG
    if(initdebug) printf("undimensioned\n");
#endif
        datasize = 0;
        maxsize = 0x7fff;   /* max 32 bit positive value */
    }
    else {
        maxsize = datasize;
#ifdef DEBUG
    if(initdebug) printf("dimensioned %ld\n",maxsize);
#endif
    }
    do {
        if (next(STRING)) {
            output += (!datasize) ? outstr((long)cstrsize,(long)cstrsize) :
                                outstr(maxsize-output,(long)cstrsize);
            return(output);
        }
        output += oneinit(BTYPE(type)|ARRAY,0,0);
        if (maxsize <= output) {
            if (maxsize < output)
                error("character array initializer alignment");
            return(output);
        }
    } while (next(COMMA) && !PEEK(SEMI) && !PEEK(RCURBR));
    if (datasize) {
        OUTRESMEM(maxsize-output);
        return(maxsize);
    }
    return(output);
}

/**
 * oneinit - get one initializer expression or constant
 *      This checks the type of the data item expected against the
 *      type obtained from expr.  
**/
oneinit(type,dp,sc)                 /* returns size of initializer*/
int type;                           /* type of initializer*/
int dp, sc;                         /* [vlh] 4.2.c add for bit field init */
{
    register short op, plus;
    register struct tnode *tp;
    register long value;
	unsigned char tempuc;

    commastop++;
#ifdef DEBUG
    if (initdebug) printf("oneinit: type = %d\n",type);
#endif
    if ((tp = (struct tnode *)expr(0)) == 0) {
        error("invalid initializer");
        commastop--;
        return(0);
    }
    commastop--;
    if (sc == DEXTERN) {        /* [vlh] 4.6 */
        error("illegal initialization of external variables");
        return(0);
    }
#ifdef DEBUG
    if (initdebug) printf("oneinit: op %d\n",tp->t_op);
#endif

    if ((op = tp->t_op) == CINT)
        clvalue = ((struct conode *)tp)->t_value; 
    else if (op == CLONG)
        clvalue = ((struct lconode *)tp)->t_lvalue; 
    if (BTYPE(type)==FLOAT||BTYPE(type)==DOUBLE) {
        if (op == CINT || op == CLONG) {
            if (fflag)
                toffp((double)clvalue);
            else
                toieee((double)clvalue,(BTYPE(type)==FLOAT)||eflag);
        }
    }
    value = clvalue; 

    if (sc == BFIELDCL)
        return(one_binit(type,dp,value));

    plus = (in_bitinit) ? out_bfield(type) : 0;

    switch( ISALLTYPE(type) ) {

#ifndef NOSYS3
        case UCHAR:
            ccbytes = 0;    /* [vlh] 4.4, assure treatement as single char */
        case ARRAY|UCHAR:   /* [vlh] 4.4, added */
            if (op == CINT || op == CLONG) {    /* [vlh] 4.2, added CLONG */
                if (ccbytes < 2) {
                    tempuc = value;
					outc(CHAR,tempuc);
                    if ((value >= 512) || (value < 0))
                        warning("initializer truncated",0);
                    return(CHARSIZE+plus);
                }
                else {  /* 2 character  charconst eg. 'ab' */
                    outc(INT,(short)value);
                    return(SHORTSIZE+plus);
                }
            }
            if (op == ADDR) {   /* [vlh] 4.2, STRING.... */
                outc(CHAR,((short)(*cstr&0xff)));
                warning("string used to initialize character value",0);
                return(CHARSIZE+plus);
            }
            break;
#endif

        case CHAR:
            ccbytes = 0;    /* [vlh] 4.4, assure treatement as single char */
        case ARRAY|CHAR:
            if (op == CINT || op == CLONG) {    /* [vlh] 4.2, added CLONG */
                if (ccbytes < 2) {
                    tempuc = value;
                    outc(CHAR,tempuc);
#ifndef NOWARN
                    if ((value>255) || (value<-128))
                        warning("initializer truncated",0);
#endif
                    return(CHARSIZE+plus);
                }
                else {  /* 2 character  charconst eg. 'ab' */
                    outc(INT,(short)value);
                    return(SHORTSIZE+plus);
                }
            }
            if (op == ADDR) {   /* [vlh] 4.2, STRING.... */
                outc(CHAR,((short)*cstr)&0xff);
                return(CHARSIZE+plus);
            }
            break;
    
        case SHORT:
        case ARRAY|SHORT:
            if (op == ADDR || op == SYMBOL)
                break;
            if( op == CINT || op == CLONG ) { /* [vlh] 4.2, added CLONG */
                outc(INT,(short)value);
#ifndef NOWARN
                if ((value&0xffff0000) && ((value&0xffff0000) != 0xffff0000))
                    warning("initializer truncated",0);
#endif
            }
            else
                outinit(tp,inittype);
            return(SHORTSIZE+plus);
    
        case USHORT:    /* [vlh] 4.2 added... */
        case ARRAY|USHORT:
            if (op == ADDR || op == SYMBOL)
                break;
            if( op == CLONG || op == CINT ) {   /* [vlh] 4.2, rewrote */
#ifndef NOWARN
                if ((value&0xffff0000) && ((value&0xffff0000) != 0xffff0000))
                    warning("initializer truncated",0);
#endif
                value = value & 0xffff;
                outc(INT,(short)value);
            }
            else
                outinit(tp,inittype);
            return(SHORTSIZE+plus);
    
#ifndef NOFP
        case DOUBLE:        /* [vlh] 4.7 */
        case ARRAY|DOUBLE:  /* [vlh] 4.7 */
            outfp_or_l(value);
            if (hfpflag) {
                outfp_or_l(cl2value);
                return(DOUBSIZE+plus);
            }
            return(LONGSIZE+plus);
#endif

#ifndef NOSYS3
        case ULONG:
        case ARRAY|ULONG:
        case POINTER|UCHAR:
        case POINTER|ULONG:
#endif
        case LONG:
        case ARRAY|LONG:
        case POINTER|CHAR:
        case POINTER|INT:
        case POINTER|LONG:
        case POINTER|STRUCT:
        case POINTER|USHORT:
#ifndef NOFP
        case POINTER|DOUBLE:    /* [vlh] 4.2 */
        case POINTER|FLOAT:     /* [vlh] 4.2 */
#endif
            if( op!=CINT && op!=CLONG ) {
                outinit(tp,inittype);
                return(PTRSIZE+plus);
            }
#ifndef NOFP
        case ARRAY|FLOAT:   /* [vlh] 4.4 */
        case FLOAT:
#endif
            outfp_or_l(value);
            return(LONGSIZE+plus);
    }
#ifdef DEBUG
    error("invalid initializer type=0%o, op=%d",type,op);
#else
    error("invalid initializer");
#endif
    return(plus);
}

/**
 *  one_binit - individual element bit field initialization. [vlh] 4.2
 *      returns the number of bytes actually initialize 0, 1, 2 or 4
**/
one_binit(type,dp,value)
int type,dp;
long value;
{
    register short plus, mask, op;

    op = (ISBTCHAR(type))? BITSPCHAR: (ISBTSHORT(type))? BITSPWORD : BITSPLONG;
    op = (dp>>8)%op;
    if (in_bitinit && ((bfield_ty != BTYPE(type)) || (op < lst_boffset)))
        plus = out_bfield(type);
    else
        plus = 0;
    lst_boffset = op;
    bfield_ty = BTYPE(type);
    mask = (1 << (dp & 0xff)) - 1;
    bits_init |= ((value & mask) << op);
    in_bitinit++;
    return(plus);
}

/* out_bfield - last item was a bit field output it [vlh] 4.2 */
out_bfield(type)    /* return number of bytes output */
int type;
{
    in_bitinit = 0;
    if (ISCHAR(bfield_ty)) {    /* char bit field type */
        outc(CHAR,(int)bits_init);
        bits_init = 0;
        type = ISALLTYPE(type);
        if (!ISCHAR(type))
            OUTEVEN();  /* returns 2 */
        else
            return(CHARSIZE);
    }
    else if (ISSHORT(bfield_ty)) {  /* short/ushort bit field type */
        defwdata();
		printf("$%x\n",bits_init);
		bits_init = 0;
	}
    else {              			/* long/ulong bit field type */
        defldata();
		printf("$%lx\n",bits_init);
		bits_init = 0;
		return(LONGSIZE);
    }
	return(SHORTSIZE);
}
