/*
    Copyright 1982, 1983
    Alcyon Corporation
    8716 Production Ave.
    San Diego, Ca.  92121

    @(#)expr.c	2.14 2/5/85
*/

#include "parser.h"
#ifndef NOSYS3
short strassign;
#endif
short qcolon;       /* [vlh] 4.5 differentiate qmark colon and switch colon */

int paren_level = 0;    /* [vlh] 4.7 */
int in_func = -1;       /* [vlh] 4.7 */

#ifndef LNG_NMS
#   define USYM_MSG "undefined symbol: %.8s"
#else
#   define USYM_MSG "undefined symbol: %s"
#endif

#define IS_ERROR    0
#define IS_TERMINAL 1
#define IS_OTHER    2

/**
 * expr - expression evaluator
 *      This handles all the expression syntax in C.  This is a 
 *      straigt forward operator-stack/oppri scheme for translating 
 *      infix into a binary expression tree.
**/
char *
expr(preset)                        /* returns 0 or ptr to node*/
int preset;                         /* [vlh] 4.2, stack setup ?? */
{
    register char *p;
    register short op, oppri;
    short token;

    if (!preset)
        expr_setup();

    while( (token=gettok(0)) != EOF ) {

        switch( is_terminal(&token) ) {
            case IS_ERROR:      /* error condition */
exprerr:
                if( token == SEMI || token == RCURBR )
                    pbtok(token);
                error("invalid expression");
                opdp = (char **)opdsave;
                opp = (struct ops *)oprsave;
                opdontop = opdotsave;
                return(0);

            case IS_TERMINAL:   /* terminal node */
                continue;

            default:            /* IS_OTHER operator node... */
                break;
        }   /* switch is_terminal() */

    /**
     * we have seen an operator, get its info and then check the operator
     * stack.
    **/
        if( BINOP(token) ) {
    /**
     * handle special binary operators, such as CAST and post-inc and
     * post-dec.
    **/
            if(!opdontop)
                if( token != PREDEC && token != PREINC && token != CAST)
                    goto exprerr;
            if( token != POSTDEC && token != POSTINC && token != MPARENS )
                opdontop = 0;               /*this fixes x++ op problem.*/
        }
        oppri = OPPRIORITY(token);
        if(qcolon && token == COLON)    /* [vlh] 4.5, not switch colon !!! */
            qcolon = 0;
        else if((commastop && (token==COMMA || token==LRCOMMA)) ||
           (colonstop && token==COLON))   /* stop at comma(init), colon(case)*/
            oppri = COLPRI;
        while( 1 ) {
            if (oppri>opp->o_pri || (oppri==opp->o_pri && RASOP(token))) {
    /**
     * we have encountered a higher priority (or right-associative)
     * operator, hence we need to stack it.
    **/
                if( ++opp >= &opstack[OPSSIZE] )
                    ferror("expression too complex");
                if( token == POSTINC || token == POSTDEC )
                    oppri = PSTPRI;
                else if( token==LPAREN || token==LBRACK || token==CALL )
                    oppri = CALPRI;
                opp->o_op = token;
                opp->o_pri = oppri;
                break;
            }
    /**
     * we have encountered a lower priority operator, hence we need to
     * do a reduction.
    **/
            op = opp->o_op;
            opp--;
            switch( op ) {
        
                case STACKEND:          /*we accept the expression...*/
                    pbtok(token);
                    if (
#ifndef NOSYS3
                        !strassign && 
#endif
                            !maketree(0))
                        goto exprerr;
                    if (!(p=popopd()))
                        goto exprerr;
                    opdp = (char **)opdsave;
                    opp = (struct ops *)oprsave;
                    opdontop = opdotsave;
                    return(p);
            
                case LPAREN:            /*assure these have matching )*/
                case CALL:
                    if (token != RPAREN)
                        goto exprerr;
                    break;

                case MPARENS:
                    if( !maketree(NACALL) ) {
#ifndef NOWARN
                        warning("null expression encountered",0);
#endif
                        return(0);
                    }
                    continue;
            
                case LBRACK:
                    if (token != RBRACK)
                        goto exprerr;
                    if (!maketree(ADD)) /*array[index]->*(array+index)*/
                        goto exprerr;
                    op = INDR;
                    break;
            
                case PREINC:            /*turn these into binary operators*/
                case POSTINC:           /*which in reality they are...*/
                case PREDEC:
                case POSTDEC:
                    pushopd(cnalloc(INT,1));
                default:
                    if(!maketree(op))
                        goto exprerr;
                    continue;           /*see if we can reduce some more...*/

            }   /* switch on op */
            if( op != LPAREN && !maketree(op) )
                goto exprerr;
            break;
        }   /* while (1) */
    }
    error("unexpected EOF");
    return(0);
}

/* expr_setup - setup op stack for expression evaluation */
expr_setup()
{
    opdsave = (char *)opdp;
#ifndef NOSYS3
    strassign = 0;
#endif
    oprsave = (char *)opp;
    opdotsave = opdontop;
    if( !opp || !opdp ) {
        opp = opstack;
        opdp = opdstack;
    }
    else
        opp++;
    opp->o_op = STACKEND;
    opp->o_pri = STKPRI;
    opap = exprp;
    opdontop = 0;
}

/**
 * is_terminal - token switch for expr()
 * the following are the terminal nodes of the expression tree,
 * note that when we see a terminal node, we push it and then go
 * and get the next token.  When we see an operator, we need to
 * check the operator stack to see if we can do a reduction.
**/
is_terminal(token)      /* returns 0 for error, 1 for terminal, 2 for other */
short *token;
{
    register struct tnode *p;
    struct symbol *stdp;
    short type, sc;
    long size;
#ifdef SYM_TO_DSK
    long stdp_addr;
    struct symbol stdp_entry;
#endif

    switch( *token ) {
        case CINT:
            if( doopd(cnalloc(INT,cvalue)) )
                return(IS_ERROR);
            return(IS_TERMINAL);
#ifndef NOFP    
        case CDOUBLE:   /*[vlh] 3.4*/
            if (doopd(fpcnalloc()))
                return(IS_ERROR);
            return(IS_TERMINAL);
#endif  
        case CLONG:
            if (doopd(lcnalloc(LONG,clvalue)))
                return(IS_ERROR);
            return(IS_TERMINAL);
    
        case SYMBOL:
            p = (struct tnode *)get_symbol();
            if( doopd(p) )
                return(IS_ERROR);
            return(IS_TERMINAL);
    
        case STRING:
            outtstr(cvalue);
            if( doopd(snalloc(ARRAY|CHAR,STATIC,cvalue,0,0)) )
                return(IS_ERROR);
            return(IS_TERMINAL);
    /**
     * do special checking for unary ops and operators that can be
     * either unary or binary operators, such as -, &, *, etc.
    **/
        case RESWORD:
            if(cvalue == R_SIZEOF)
                *token = SIZEOF;
            else if (cvalue == R_ASM)
                *token = ASM;
            else
                return(IS_ERROR);
        case COMPL:
        case NOT:
            if( opdontop )      /*can't have: operand unary-op*/
                return(IS_ERROR);
            break;

        case LBRACK:
            opdontop = 0;
            break;
    
        case RPAREN:            /* [vlh] 4.2.f, was with RBRACK */
            if (!opdontop) {
                *token = MPARENS;
                opdontop = 1;   /* fake out expr for null expression... */
            }
            break;

        case RBRACK:
            if (!opdontop)      /*can't be: operator )*/
                return(IS_ERROR);
            break;
    
        case PREINC:
            if (opdontop)       /*assume its lvalue++*/
                *token = POSTINC;
            break;

        case PREDEC:
            if (opdontop)       /*assume its lvalue--*/
                *token = POSTDEC;
            break;
    
        case SUB:
            if (!opdontop) {    /*if no operand, assume unary*/
                if (PEEK(CINT)) {
                    cvalue = -cvalue;
                    return(IS_TERMINAL);
                }
                if (PEEK(CLONG)) {
                    clvalue = -clvalue;
                    return(IS_TERMINAL);
                }
#ifndef NOFP
                if (PEEK(CDOUBLE)) {    /*[vlh] 3.4*/
                    if (!fflag) {       /* IEEE (hardware/software) format */
                        if (clvalue & 0x80000000)
                            clvalue &= 0x7fffffff;
                        else
                            clvalue |= 0x80000000;
                    }
                    else                /* FFP (software) format */
                        if (clvalue & 0x80)
                            clvalue &= 0xffffff7f;
                        else
                            clvalue |= 0x80;
                    return(IS_TERMINAL);
                }
#endif
                *token = UMINUS;
            }
            break;
    
        case AND:
            if(!opdontop)
                *token = ADDR;
            break;

        case MULT:
            if( !opdontop )
                *token = INDR;
            break;

        case LPAREN:
            if( !opdontop ) {   /*see if casting or abstract declarator*/
                sc = type = 0;
#ifdef SYM_TO_DSK
                ASSG(stdp_addr,tdp_addr,stdp_entry,tdp_entry,stdp); /*[vlh]4.7*/
#else
                stdp = tdp; /* [vlh] 4.7 */
#endif
                tdp = 0;    /* [vlh] 4.7 */
                if( gettype(&sc,&type,&size,0) ) {
                    sc = (type == STRUCT) ? dalloc(size) : cdp;
                    p = (struct tnode *)snalloc(type,STATIC,0,sc,sc);
                    p->t_type |= declarator(1);
                    if (!next(RPAREN))
                        return(IS_ERROR);
                    if (tdp)
                        p->t_type=addtdtype(tdp,p->t_type,p->t_dp,&(p->t_ssp));
                    else    /* [vlh] 4.7 */
#ifdef SYM_TO_DSK
                        ASSG(tdp_addr,stdp_addr,tdp_entry,stdp_entry,tdp);
#else
                        tdp = stdp;
#endif
                    pushopd(p);
                    *token = CAST;
                    if (ISSTRUCT(p->t_type)) {      /* [vlh] 4.7 */
#ifdef SYM_TO_DSK
                        struc_parent[stk_struct] = csp_addr;
#else
                        struc_parent[stk_struct] = csp;
#endif
#ifdef DEBUG
                        if (debug)
                            printf("Setpar1 %d [%.8s]\n",csp->s_sc,
                                        struc_parent[stk_struct]->s_symbol);
#endif
                        eff_parent[stk_struct] = 1;
                    }
                    if( opp->o_op == SIZEOF ) {
                        opdontop++;
                        return(IS_TERMINAL);
                    }
                }
            }
            else  /*we've seen (), look for NACALL*/
                *token = (next(RPAREN)) ? MPARENS : CALL;
            break;
    
        case PERIOD:
        case APTR:
            smember++;          /*next token needs to be struct membr*/
            if (!eff_parent[stk_struct]) {  /* Don't overwrite cast */
                if (csp->s_sc == STELCL || csp->s_sc == UNELCL)
                    struc_parent[stk_struct] = csp->s_child;
                else
                    struc_parent[stk_struct] = csp->s_par;
#ifdef DEBUG
                if (debug)
                    printf("Setpar2 %d [%s]\n",csp->s_sc,
                                struc_parent[stk_struct]->s_symbol);
#endif
            }
            eff_parent[stk_struct] = 0;     /* [vlh] 4.7 */
            break;

        case QMARK: /* [vlh] 4.5, differentiate qmark colon and switch colon */
            qcolon = 1;
            break;
    
    }   /* switch on token */
    return(IS_OTHER);
}


/* get_symbol - handle symbol element for expr() */
char *
get_symbol()
{
    register struct symnode *p;
#ifdef SYM_TO_DSK
    long p_addr;
    struct symbol p_entry;

    p_entry = csp_entry;
    p_addr = csp_addr;
    p = &p_entry;
#else
    p = (struct symnode *)csp;
#endif
    if( !(p->s_attrib&SDEFINED) ) {
        if( PEEK(LPAREN) ) {    /*assume function call*/
            in_func = paren_level - 1;  /* [vlh] 4.7 */
            p->s_sc = EXTERNAL;
#ifndef NO32BIT
            p->s_type = FUNCTION;
            p->s_type |= INTTYPE;
#else
            p->s_type = FUNCTION|INT;
#endif
            p->s_scope = GLOB_SCOPE;    /* [vlh] 4.2 */
        }
        else if (commastop) /*in initialization?*/
            p->s_sc = EXTERNAL;
        else    /* Undefined symbol */
           error(USYM_MSG,p->s_symbol);
        p->s_attrib |= SDEFINED;
        TO_DSK(p,p_addr);
    }
    else if (ISFUNCTION(p->t_type)) /* [vlh] 4.7 */
        in_func = paren_level;
    if (p->s_sc==EXTERNAL || ISFUNCTION(p->t_type)) {
        if (!reducep || p->s_sc==EXTERNAL || PEEK(LPAREN)) {
            p = (struct symnode *)enalloc(p);
            p->t_sc = EXTERNAL;
        }
        else    /* [vlh] 3.4 if (main).... */
            p = (struct symnode *)cnalloc(CINT,1);  /* eval function name */
    }
    else
        p = (struct symnode *)snalloc(p->s_type,p->s_sc,p->s_offset,
                                p->s_dp,p->s_ssp);  
        if (!eff_parent[stk_struct] && ISSTRUCT(p->t_type)) {   /* [vlh] 4.7 */
            if (csp->s_sc == STELCL || csp->s_sc == UNELCL)
                struc_parent[stk_struct] = csp->s_child;
            else /* Not a structure member */
                struc_parent[stk_struct] = csp->s_par;
#ifdef DEBUG
            if (debug) {
                printf("Setpar3 [%.8s] %d [%s]\n",csp->s_symbol,csp->s_sc,
                                struc_parent[stk_struct]->s_symbol);
                if (csp->s_par)
                    printf("par %s, ",csp->s_par->s_symbol);
                else printf("no par, ");
                if (csp->s_child)
                    printf("child %s\n",csp->s_child->s_symbol);
                else printf("no child\n");
            }
#endif
            eff_parent[stk_struct] = 1;
        }
        
    READ_ST(csp,csp_addr);
    return((char *)p);
}

#define LONG_RES(lval,rval) ((lval>0) && (rval>0) && (lval>0x7fff))
long sign_op();
#ifndef NOSYS3
unsigned long usign_op();
#endif
/**
 * binopeval - does binary operator constant expression evaluation
 *      Does the constant expression evaluation for binary operators.
**/
binopeval(op,ltp,rtp)               /* returns 1 if done, 0 if not*/
int op;                             /* operator to evaluate*/
struct lconode *ltp;                /* pointer to left subtree*/
struct lconode *rtp;                /* pointer to right subtree*/
{
    register long lvalue, rvalue;   /* [vlh] 4.1 short -> long */
    register short ltype, rtype;
    short islong, isunsign, size;

    PUTEXPR(treedebug,"binopeval l",ltp);
    PUTEXPR(treedebug,"binopeval r",rtp);
    islong = 0;
    ltype = ltp->t_type;
    rtype = rtp->t_type;

    if (rtp->t_op == CINT)
        rvalue = (UNSIGN(rtype)) ? (unsigned short)rtp->t_value : rtp->t_value;
    else if (rtp->t_op == CLONG) {  /* [vlh] 4.1 added CLONG */
        rvalue = rtp->t_lvalue;
        islong++;
    }
    else
        return(0);

    if (ltp->t_op == CINT) {
        /*lvalue=(UNSIGN(ltype))?(unsigned short)ltp->t_value:ltp->t_value;*/
        if (UNSIGN(ltype)) 
			lvalue = (unsigned short)ltp->t_value;
		else
			lvalue = ltp->t_value;
	}
    else if (ltp->t_op == CLONG) {  /* [vlh] 4.1 added CLONG */
        if ((ltype & POINTER) && op==ADD) { /* [vlh]4.3 array coercion */
				/* [vlh] 4.9, if not structure pointer coercion */
			if (!ISPSTRUCT(ltype) && ltp->t_ssp) {
                size = dsize(delsp(ltype),ltp->t_dp,ltp->t_ssp);
                rvalue *= size;
            }
        }
        lvalue = ltp->t_lvalue;
        islong++;
    }
    else
        return(0);

    isunsign = (ltype==ULONG || rtype==ULONG);

#ifdef DEBUG
    if (treedebug)
        printf("binopeval: $%lx op[%d] $%lx\n",lvalue,op,rvalue);
#endif
    if (op>LESSEQ || !BINOP(op))
        return(0);
    else if (!isunsign)
        lvalue = sign_op(op,lvalue,rvalue);
#ifndef NOSYS3
    else
        lvalue = usign_op(op,lvalue,rvalue);
#endif

#ifdef DEBUG
    if (treedebug)
        printf("result %ld\n",lvalue);
#endif
        /* [vlh] 4.7, relop expressions evaluate to integer returns */
    if (!longint && islong && (RELOP(op))) {
        ltp->t_type = INT;
        ltp->t_op = CINT;
        ltp->t_value = lvalue;
    }
    else if (islong || LONG_RES(lvalue,rvalue)) {
        ltp->t_op = CLONG;
        ltp->t_lvalue = lvalue;
        if(isunsign)
            ltp->t_type = ULONG;    /* 4.9 */
        else if(ltype==INT)
            ltp->t_type = LONG;     /* 4.2+ */
    }   /* [vlh] 4.3, turn int into long if necessary */
    else
        ltp->t_value = lvalue;
    pushopd(ltp);
    PUTEXPR(treedebug,"result binop",ltp);
    return(1);
}

/**
 * sign_op - Computes signed binary operation and returns long
 *      result.
**/
long sign_op(op,lvalue,rvalue)
int op;
long lvalue, rvalue;
{
    switch (op) {

        case ADD:
            return(lvalue + rvalue);

        case SUB:
            return(lvalue - rvalue);

        case MULT:
            return(lvalue * rvalue);

        case DIV:
            return(lvalue / rvalue);

        case MOD:
            return(lvalue % rvalue);

        case AND:
            return(lvalue & rvalue);

        case OR:
            return(lvalue | rvalue);

        case XOR:
            return(lvalue ^ rvalue);

        case LSH:
            return(lvalue << rvalue);

        case RSH:
            return(lvalue >> rvalue);

        case EQUALS:
            return(lvalue == rvalue);

        case NEQUALS:
            return(lvalue != rvalue);

        case GREAT:
            return(lvalue > rvalue);

        case LESS:
            return(lvalue < rvalue);

        case GREATEQ:
            return(lvalue >= rvalue);

        case LESSEQ:
            return(lvalue <= rvalue);

        default:
            warning("bad constant binary operation",0);
            return(0);
    }
}

#ifndef NOSYS3
/**
 * usign_op - Computes signed binary operation and returns long
 *      result.
**/
unsigned long usign_op(op,lvalue,rvalue)
int op;
unsigned long lvalue, rvalue;
{
    switch (op) {

        case ADD:
            return(lvalue + rvalue);

        case SUB:
            return(lvalue - rvalue);

        case MULT:
            return(lvalue * rvalue);

        case DIV:
            return(lvalue / rvalue);

        case MOD:
            return(lvalue % rvalue);

        case AND:
            return(lvalue & rvalue);

        case OR:
            return(lvalue | rvalue);

        case XOR:
            return(lvalue ^ rvalue);

        case LSH:
            return(lvalue << rvalue);

        case RSH:
            return(lvalue >> rvalue);

        case EQUALS:
            return(lvalue == rvalue);

        case NEQUALS:
            return(lvalue != rvalue);

        case GREAT:
            return(lvalue > rvalue);

        case LESS:
            return(lvalue < rvalue);

        case GREATEQ:
            return(lvalue >= rvalue);

        case LESSEQ:
            return(lvalue <= rvalue);

        default:
            warning("bad constant binary operation",0);
            return(0);
    }
}
#endif

/**
 * unopeval - unary operator constant expression evaluation
 *      Does constant expression evaluation for unary operators.
**/
unopeval(op,tp)                     /* returns 1 if done, 0 otherwise*/
int op;                             /* operator to evaluate*/
struct lconode *tp;                 /* pointer to subexpression*/
{
    register long value;

    if( tp->t_op == CINT )
        value = ((struct conode *)tp)->t_value;
    else if( tp->t_op == CLONG) /* [vlh] 4.1 added clong.... */
        value = tp->t_lvalue;
    else
        return(0);
    switch( op ) {

        case COMPL:
            value = ~ value;
            break;

        case UMINUS:
            value = - value;
            break;

        case NOT:
            value = ! value;
            break;

        default:
            return(0);
    }
    if (tp->t_op == CINT && !longint)
        ((struct conode *)tp)->t_value = value;
    else                        /* [vlh] 4.1 added clong.... */
        tp->t_lvalue = value;
    pushopd(tp);
    return(1);
}

/* cexpr - evaluate a constant integer expression*/
/*      Used in evaluating array bounds, bit field numbers, etc.*/
long
cexpr()                     /* returns the constant value */
{
    register struct lconode *tp;
    register char *savep;
    register short op;

    savep = exprp;
    exprp = opap;
    commastop++;
    tp = (struct lconode *)expr(0);
    op = tp->t_op;
    if (op != CINT && op != CLONG)
        error("constant required"); /* [vlh] 4.1 added CLONG... */
    commastop--;
    exprp = savep;
    return((op==CLONG) ? tp->t_lvalue : (long)((struct conode *)tp)->t_value);
}

