/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)symbols.c	2.3    1/15/85
*/

#include "loader.h"
#include "lx68.h"

symtinit()
{
	register struct symtbl *sp;
	register short i;

	sp = &symtab;
	for(i = HASHVAL; --i != -1; )
		sp->hashcol[i] = ALLOC(HSYMSIZ);	/* Get a hash table element */
	sp->f_lptr = ALLOC(LFILSIZ);	/* Init libe file list */
	sp->f_bptr = ALLOC(BSSEL);	/* Assign first BSS list ptr */
	sp->f_aptr = ALLOC(ALIASIZ);	/* Assign alias list pointer */
	sp->s_text = sp->s_data = sp->s_bss = 0;
}

struct hashel *
addsym(symptr)
register struct nlist *symptr;
{
	register struct hashel *elptr;
	register struct aliases *aptr;
	register short sym_type, def_type;

	elptr = scancol(symptr->n_name,hash(symptr->n_name));	/* Scan for match */
	sym_type = symptr->n_type;
	def_type = elptr->h_sym.n_type;
	if( *elptr->h_sym.n_name == 0 ) {	/* If an empty entry */
		cpsym(symptr,&elptr->h_sym);	/* Copy the symbol */
		elptr->n_hptr = ALLOC(HSYMSIZ);		/* Link to next element */
		if( GLOBAL(sym_type) ) {
			if( sym_type & S_TEXT )
				elptr->h_sym.n_value += symtab.s_text;
			else if( sym_type & S_DATA )
				elptr->h_sym.n_value += symtab.s_data;
			else if( sym_type & S_BSS ) {
				elptr->h_sym.n_value += symtab.s_bss;
				addcom(&elptr->h_sym);
			}
			goto ckalias;
		}
	}
	else if( GLOBAL(sym_type) && GLOBAL(def_type) ) {
		if( sym_type == def_type ) {
			if( sym_type & S_TEXT )
				symptr->n_value += symtab.s_text;
			else if( sym_type & S_DATA )
				symptr->n_value += symtab.s_data;
			else if( sym_type & S_BSS )
				symptr->n_value += symtab.s_bss;
			if( symptr->n_value != elptr->h_sym.n_value )
				return(0L);	/* this is a warning */
		}
	}
	else if( GLOBAL(sym_type) || (COMMON(sym_type) && !GLOBAL(def_type)) ) {
		if( COMMON(sym_type) && COMMON(def_type) ) {
			if( symptr->n_value >= elptr->h_sym.n_value )
				cpsym(symptr,&elptr->h_sym);	/* Copy the definition */
		}
		else
			cpsym(symptr,&elptr->h_sym);	/* Copy the definition */
		if( sym_type & S_DATA )
			elptr->h_sym.n_value += symtab.s_data;
		else if( sym_type & S_TEXT )
			elptr->h_sym.n_value += symtab.s_text;
		else if( sym_type & S_BSS ) {
			elptr->h_sym.n_value += symtab.s_bss;
			addcom(&elptr->h_sym);
		}
ckalias:
		if( aflag ) {
			for( aptr = symtab.f_aptr; aptr != 0; aptr = aptr->n_aptr ) {
				if( symcmp(elptr->h_sym.n_name,aptr->symname) != 0 )
					continue;
				aptr->link->h_sym.n_value = elptr->h_sym.n_value;
				if( cflag )
					aptr->link->h_sym.n_type = S_DEFINED|S_EXTERNAL|S_ALIAS0;
				else
					aptr->link->h_sym.n_type = elptr->h_sym.n_type;
				break;
			}
		}
	}
	return(elptr);
}

addcom(element)
struct hashel *element;
{
	register struct bssel *bptr;

	for( bptr = symtab.f_bptr; bptr->n_bptr != 0; bptr = bptr->n_bptr )
		;
	bptr->b_hptr = element;
	bptr->n_bptr = ALLOC(BSSEL);
}

cpsym(fptr,tptr)
register struct nlist *fptr,*tptr;
{
	SYMALLOC(tptr->n_name,strlen(fptr->n_name)+1);
	symcpy(tptr->n_name,fptr->n_name);
	tptr->n_type = fptr->n_type;
	tptr->n_value = fptr->n_value;
}

struct hashel *
scancol(sym,index)
char *sym;
short index;
{
	register struct hashel *eptr;

	eptr = symtab.hashcol[index];
	for( ; *eptr->h_sym.n_name != 0; eptr = eptr->n_hptr )
		if( symcmp(eptr->h_sym.n_name,sym) == 0 )
			break;

	return(eptr);
}

hash(sname)
register char *sname;
{
	register short index,i;

	for(index = 0, i = S_SYMLEN; --i != -1; ) {
		if( *sname == 0 )
			break;
		index += *sname++;
	}
	index = index % HASHVAL;
	return(index);
}

struct hashel *
makexref(sname)
char *sname;
{
	SYMALLOC(csym.n_name,strlen(sname)+1);
	symcpy(csym.n_name,sname);
	csym.n_type = S_DEFINED|S_EXTERNAL;
	csym.n_value = 0L;
	return(addsym(&csym));
}

aliasym(sname,salias)
char *sname;
char *salias;
{
	register struct aliases *aptr;
	register struct hashel *lptr;

	lptr = makexref(sname);
	for( aptr = symtab.f_aptr; aptr->n_aptr != 0; aptr = aptr->n_aptr )
		;
	symcpy(aptr,salias);
	aptr->link = lptr;
	aptr->n_aptr = ALLOC(ALIASIZ);
}

/* put file name into symbol table */
addfn(fname,off)
char *fname;
long off;
{
	register char *p,*q;
	register struct nlist *sp;
	register int i;
	struct nlist sym;

	p = q = fname;
	while( *p ) {
		if( *p++ == FILESEP )	/* directory delimiter */
			q = p;
	}
	sp = &sym;
	SYMALLOC(sp->n_name,strlen(q)+1);
	symcpy(sp->n_name,q);
	sp->n_type = S_FILE|S_GLOBAL|S_TEXT;	/* file name bit */
	sp->n_value = off;
	PUTSYM(sp,seofd,snofd);
	mstcnt++;
}

/**
 * symcmp - symbol comparison
 *      Compares two strings for equality, less or greater.
**/
symcmp(s,t)
register char *s, *t;
{
	register int n;

    for (n = S_SYMLEN; *s == *t && n; s++, t++, n--)
		if( *s == '\0' )
			return(0);
    return((n) ?  *s - *t : 0);
}

/**
 * symcopy - symbol copy			[vlh] 4.9
 *      Copies symbol q to symbol p, NAMELEN if not LNG_NMS other-
 *      wise till a null.
**/
symcpy(p,q)
register char *p, *q;
{
#ifndef LNG_NMS
	register int i;

	for (i=0; i < S_SYMLEN; i++)
		*p++ = (*q) ? *q++ : '\0';
#else
	while (*p++ = *q++)
		;
#endif
}

#ifdef LNG_NMS
/* symalloc - allocate symbol space */
char *
symalloc(size)
int size;
{
	register char *p;

	if ((p = MALLOC(size)) == MAFAIL) {
		printf(":symbol table overflow\n");
		ldexit(1);
	}
	return(p);
}
#endif
