/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)resolve.c	2.6    1/15/85
*/

#include "loader.h"
#include "lx68.h"

char shrtexit[];

resolve()
{
	register struct symtbl *sptr;
	register struct hashel *eptr;
	register long common;
	register short index,i, sym_type;

	sptr = &symtab;
	eptr = scancol("_exit",hash("_exit"));
	if( *eptr->h_sym.n_name && EXTERNAL(eptr->h_sym.n_type) ) {
		passone(shrtexit,NULL,"short exit","short exit");	/* exit referenced */
		xitflg++;
	}
	otsize = sptr->s_text;
	odsize = sptr->s_data;
	obsize = sptr->s_bss;
	sptr->s_text = tbase;	/* Set up relocation bases */

	if( dflag ) {
		if( dbase < tbase + otsize )
			printf(":warning, DATA starting before end of text\n");
		sptr->s_data = dbase;
	}
	else
		sptr->s_data = tbase + otsize;

	if( nflag ) {	/* Put data on 4K bounds */
#ifdef ALLSHTEXT
		if( nflag == 2 ) {
			sptr->s_data &= ST2MASK;
			sptr->s_data += TWOK;
		}
		else {
#endif
			sptr->s_data &= STMASK;
			sptr->s_data += FOURK;
	}

	if( bflag ) {
		if( bbase < sptr->s_data + odsize )
			printf(":warning, BSS starting before end of data\n");
		sptr->s_bss = bbase;
	}
	else
		sptr->s_bss = sptr->s_data + odsize;

	for( i = 0; i < HASHVAL; i++ ) {
		for( eptr = sptr->hashcol[i]; eptr->n_hptr != 0L; eptr = eptr->n_hptr ) {
			sym_type = eptr->h_sym.n_type;
			if( GLOBAL(sym_type) || LOCAL(sym_type) ) {
global:
				if( cflag )
					continue;
				if( sym_type & S_TEXT )	/* Relocate text */
					eptr->h_sym.n_value += sptr->s_text;
				else if( sym_type & S_DATA )	/* Relocate data */
					eptr->h_sym.n_value += sptr->s_data;
				else if( sym_type & S_BSS ) {	/* Relocate BSS */
					if( eptr->h_sym.n_value == 0 )
						printf(":warning, '%s' zero BSS value\n",eptr->h_sym.n_name);
					eptr->h_sym.n_value += sptr->s_bss;
				}
			}
			else if( symcmp("_etext",eptr->h_sym.n_name) == 0 ) {
				if( cflag == 0 ) {
					eptr->h_sym.n_value += sptr->s_text + otsize;
					eptr->h_sym.n_type = (S_DEFINED|S_GLOBAL|S_END|S_ABS);
				}
			}
			else if( symcmp("_edata",eptr->h_sym.n_name) == 0 ) {
				if( cflag == 0 ) {
					eptr->h_sym.n_value += sptr->s_data + odsize;
					eptr->h_sym.n_type = (S_DEFINED|S_GLOBAL|S_END|S_ABS);
				}
			}
			else if( symcmp("_end",eptr->h_sym.n_name) == 0 ) {
				if( cflag == 0 )
					eflag++;
			}
			else if( COMMON(sym_type) ) {
				if( cflag == 0 ) {
					if( (sym_type&S_ABS) == 0 ) {
						if( (common = eptr->h_sym.n_value) == 0 )
							printf(":undefined common symbol '%.8s'\n",
								eptr->h_sym.n_name,errcnt++);
						else {
							eptr->h_sym.n_value = sptr->s_bss + obsize;
							obsize += common;
							eptr->h_sym.n_type = S_DEFINED|S_GLOBAL|S_BSS;
							addcom(&eptr->h_sym);	/* Add to BSS list */
						}
					}
				}
			}
			else if( sym_type & S_ALIAS1 ) {
				sym_type = eptr->h_sym.n_type = S_DEFINED|S_GLOBAL|S_TEXT;
				goto global;
			}
			else if( sym_type & S_ALIAS0 ) {
				eptr->h_sym.n_type &= ~S_ALIAS0;
				eptr->h_sym.n_type |= S_ALIAS1;
			}
			else {
IFDEBUG(printf("eptr %lx name %s %x type %o i %d sym_type %o\n",eptr,eptr->h_sym.n_name,*eptr->h_sym.n_name,(eptr->h_sym.n_type&0xffff),i,(sym_type&0xffff));)
				if( eptr != 0 && eptr->h_sym.n_name != 0 &&
					*eptr->h_sym.n_name != 0 )
				printf(":undefined %.8s\n",eptr->h_sym.n_name,errcnt++);
			}
		}
	}
	if( eflag ) {
		index = hash("_end");
		for( eptr = sptr->hashcol[index]; eptr != 0 ; eptr = eptr->n_hptr )
			if( symcmp(eptr->h_sym.n_name,"_end") == 0 )
				break;
		eptr->h_sym.n_value += sptr->s_bss + obsize;
		eptr->h_sym.n_type = (S_DEFINED|S_GLOBAL|S_END|S_ABS);
	}
}
