/*
	Copyright 1983
	Alcyon Corp.
	8716 Production Ave.
	San Diego, Ca.  92121

	@(#)relocate.c	2.7    1/15/85
*/

#include "loader.h"
#include "lx68.h"

short ftflag = 0;
long tbuf;
#ifndef HP
	struct relbits relbuf;

#	define RELTYPE 		relbuf.rtype
#	define RELSNUM 		relbuf.symnum
#	define RELASGN(val) relbuf.rtype = val; relbuf.symnum = 0
#	define RELSASG(val) relbuf.symnum = val
#else
	short relbuf;

#	define RELTYPE 		(relbuf&0x7)
#	define RELSNUM 		(relbuf>>3)
#	define RELASGN(val) relbuf = val 
#	define RELSASG(val) relbuf &= 0x7; relbuf |= ((val << 3)&0xfff8)
#endif

#ifdef SELFBOOT
	char rfname[] = "/mnt/tmp/LRAXXXXX";
	char sefname[] = "/mnt/tmp/LSAXXXXX";
#	ifdef LNG_NMS
		char snfname[] = "/mnt/tmp/LNAXXXXX";
#	endif
#else
	char rfname[] = "/tmp/LRAXXXXX";
	char sefname[] = "/tmp/LSAXXXXX";
#	ifdef LNG_NMS
	char snfname[] = "/tmp/LNAXXXXX";
#	endif
#endif

relocate(fname,fp,rfp,sfp,offset,lname,symfp)
char *fname;
FILE *fp, *rfp, *sfp;
register long offset;
char *lname;
FILE *symfp;		/* [vlh] 4.9 */
{
	register struct symtbl *sptr;
	register struct hashel *eptr;
	register long tpc;
	register short magic, islong, sym_type;
	long tmp, stesize;
	struct nlist syms;

	if( fp == NULL ) {
		if( (tfd = fopen(fname,"r")) == NULL ) {
			printf(":can't re-open '%s'\n",fname);
			ldexit(1);
		}
#ifdef FCNTL
		fcntl(fileno(tfd),F_SETFL,O_RANDOM);
#endif
	}
	else
		tfd = fp;

	if( (magic = getsizes(tfd,lname)) != 0 ) {
		if( fp == NULL )
			fclose(tfd);
		return(magic);
	}

	if( fp == NULL ) {
#ifdef OPENFD
		rfp = newopen(tfd);
		sfp = newopen(tfd);
#else
		rfp = fopen(fname,"r");	/* input buffer for relocation bits */
		sfp = fopen(fname,"r");	/* input buffer for symbols */
# ifdef FCNTL
		fcntl(fileno(rfp),F_SETFL,O_RANDOM);
		fcntl(fileno(sfp),F_SETFL,O_RANDOM);
# endif
#endif
		if( rfp == NULL || sfp == NULL ) {
			printf(":insufficient input streams for %s\n",fname);
			ldexit(1);
		}
#ifdef LNG_NMS
		if ((symfp = fopen(fname,"r")) == NULL) {
			printf(":insufficient input streams for %s\n",fname);
			ldexit(1);
		}
#endif
	}

	if( ftflag++ == 0 ) {
		otsize++;
		otsize &= 0xfffffffe;
		if( bflag + dflag + tflag )
			hdrsiz = HDSIZ2;
		else
			hdrsiz = HDSIZE;
		newtext = hdrsiz;
		textoff = 0L;
		dataoff = 0L;
		bssoff = 0L;

		lseek(fileno(ofd),hdrsiz+otsize,0);	/* stretch this file */
		write(fileno(ofd),"",0);
		fseek(ofd,hdrsiz,0);	/* Skip header for now */
		if( cflag || rflag ) {
			mktemp(rfname);
			rofd = fopen(rfname,"w+");
			lseek(fileno(rofd),otsize,0);	/* extend file to end of text */
			write(fileno(rofd),"",0);
			fseek(rofd,0L,0);
		}
		if( sflag == 0 ) {
			mktemp(sefname);
			seofd = fopen(sefname,"w+");
#ifdef LNG_NMS
			mktemp(snfname);
			snofd = fopen(snfname,"w+");
			symindex = 0;
#endif
		}
	}
	sptr = &symtab;
	if( sflag == 0 )
		addfn(lname,textoff+sptr->s_text);
	sstart = offset+HDSIZE+tsize+dsize;
	fseek(rfp,sstart+ssize,0);
#ifdef LNG_NMS
	fseek(symfp,HDSIZE+tsize+dsize,0);
	islngnms = 1;
	GETSYM(&syms,symfp,NULL,0);    /* Get a symbol */
	if (syms.n_name != -1 || syms.n_type != 0)
		islngnms = 0;
	else {    /* Adjust sym space pointer */
		sssize = syms.n_value;
		ssize = syms.n_value - S_LSYMSIZ;
		fseek(symfp,HDSIZE+tsize+dsize+sssize,0);
	}
#endif
	stesize = STE_SIZE;		/* [vlh] 4.9 */
	lastsym = 0;
	tpc = textoff + tbase;
	for( magic = 0,bounds = tsize; magic < 2; bounds = dsize,magic++ ) {
		islong = 0;
		for( ; bounds > 0; bounds -= sizeof(short) ) {
			tbuf = 0L;
			lgetw(&tbuf.loword,tfd);	/* read a word of text/data */
			lgetw(&relbuf,rfp);
			tpc += 2;	/* keep track of pc within this file */
			if (RELTYPE == R_UPPER) {
				if( rflag )
					lputw(&relbuf,rofd);
				islong = 1;
				lgetw(&relbuf,rfp);
				tbuf.hiword = tbuf.loword;
				lgetw(&tbuf.loword,tfd);
				tpc += 2;
			}
			switch (RELTYPE) {
				case R_UPPER:
					printf(":relocation bits error,LONG on low word\n");
					continue;
				case R_ISTART:
				case R_ABS:
					break;
				case R_TEXT:
					if( cflag == 0 )
						tbuf += sptr->s_text;
					tbuf += textoff;
					break;
				case R_DATA:
					if( cflag == 0 )
						tbuf += sptr->s_data;
					tbuf += dataoff;
					break;
				case R_BSS:
					if( cflag == 0 )
						tbuf += sptr->s_bss;
					tbuf += bssoff;
					break;
				case R_UNDEF:
				case R_EXTREL:
					if( (lastsym == 0) || (RELSNUM + 1 > lastsym) ) {
						eptr = getlocal(RELSNUM+1,sfp,symfp);
					}
					else {
						fseek(sfp,((long)RELSNUM * stesize)+sstart,0);
						GETSYM(&syms,sfp,symfp,HDSIZE+tsize+dsize+sssize);
						if ((eptr=scancol(syms.n_name,hash(syms.n_name)))==0) {
							printf(":undefined symbol '%.8s' not scanned\n",
								syms.n_name,errcnt++);
							break;
						}
					}
					sym_type = eptr->h_sym.n_type;
					if( sym_type&S_END ) {	/* If an end var */
						tbuf += eptr->h_sym.n_value;
						RELASGN(R_ABS);
					}
					else if( GLOBAL(sym_type) || (sym_type&S_ABS) ) {
						tbuf += eptr->h_sym.n_value;
						if (RELTYPE == R_EXTREL) {
							tbuf -= (tpc - 2);
							if( tbuf < 0xffff8000 || tbuf > 0x7fff )
						printf(":relative address overflow in '%s' at %lx\n",
							  lname,tpc,errcnt++);
							tbuf &= 0xffffL;
						}
						switch(sym_type&(S_TEXT|S_DATA|S_BSS)) {
							case S_TEXT:
								RELASGN(R_TEXT);
								break;
							case S_DATA:
								RELASGN(R_DATA);
								break;
							case S_BSS:
								RELASGN(R_BSS);
								break;
							case S_ABS:
							default:
								RELASGN(R_ABS);
								break;
						}
					}
					else {	/* Still an external */
						RELSASG((short)eptr->symval);	/* New n# */
					}
					break;
				default:
					printf(":warning, invalid relocation bits %x\n",RELTYPE);
			}
			if( islong ) {
				islong = 0;
				bounds -= 2;
				lputw(&tbuf.hiword,ofd);
			}
			else if( ignore == 0 && tbuf.hiword )
				printf(":short address overflow in '%s' value %lx\n",lname,tbuf,errcnt++);
			lputw(&tbuf.loword,ofd);
			if( rflag )
				lputw(&relbuf,rofd);
		}
		if( (lastsym*stesize) < ssize ) {
			getlocal((int)(ssize/stesize),sfp,symfp);
		}
		if( magic == 0 ) {
			tmp = otsize+dataoff;	/* get to end of data now */
			fseek(ofd,tmp+hdrsiz,0);
			if( rflag )
				fseek(rofd,tmp,0);
		}
	}
	newtext += tsize;
	textoff += tsize;
	dataoff += dsize;
	bssoff += bsize;
	fseek(ofd,newtext,0);	/* Reposition to end of text */
	if( rflag )
		fseek(rofd,(long)(newtext - hdrsiz),0);
	if( fp == NULL ) {
		fclose(tfd);
		fclose(rfp);
		fclose(sfp);
#ifdef LNG_NMS
		fclose(symfp);
#endif
	}
	return(0);
}

struct hashel *
getlocal(snumber,fp,symfp)
short snumber;
register FILE *fp, *symfp;
{
	register struct hashel *eptr;
	register struct nlist *sym;
	register long size, stesize;
	struct nlist syms;

	sym = &syms;
	stesize = STE_SIZE;
	fseek(fp,((long)lastsym * stesize)+sstart,0);
#ifdef LNG_NMS
	if (lastsym == 0) {
		fseek(symfp,sstart,0);
		islngnms = 1;
		GETSYM(&syms,symfp,NULL,0);    /* Get a symbol */
		if (syms.n_name != -1 || syms.n_type != 0)
			islngnms = 0;
		else {    /* Adjust sym space pointer */
			fseek(symfp,HDSIZE+tsize+dsize+sssize,0);
			GETSYM(&syms,fp,NULL,0);    /* Get a symbol */
		}
	}
#endif
	for (size = (snumber-lastsym)*stesize; size > 0; size -= stesize) {
		if (GETSYM(sym,fp,symfp,(long)(sstart+sssize)) == ERROR)
			return(0);
		if (*sym->n_name == 0) {
			printf(":warning, null local symbol\n");
			continue;
		}
		if ((eptr = scancol(sym->n_name,hash(sym->n_name))) == 0)
			printf(":local symbol '%.8s' not scanned\n",sym->n_name,errcnt++);
		else if (EXTERNAL(sym->n_type) || COMMON(sym->n_type)) {
			if (EXTERNAL(eptr->h_sym.n_type) || COMMON(eptr->h_sym.n_type)) {
				if ((eptr->h_sym.n_type&S_USED) == 0) {		/* If unused */
					if (sflag == 0)
						PUTSYM(&eptr->h_sym,seofd,snofd);
					eptr->h_sym.n_type |= S_USED;
					eptr->symval = (long)mstcnt++;
				}
			}
		}
		else if( GLOBAL(sym->n_type) && (sym->n_type&(S_TEXT|S_DATA)) ) {
			if( (sym->n_type&S_FILE) != 0 ) {
				PUTSYM(sym,seofd,snofd);
				mstcnt++;
			}
			else if( (eptr->h_sym.n_type&S_USED) == 0 ) {
				if( sflag == 0 )
					PUTSYM(&eptr->h_sym,seofd,snofd);
				eptr->h_sym.n_type |= S_USED;
				if( aflag )
					dumpalias(eptr->h_sym.n_name);
				mstcnt++;
			}
		}
		else if( (*sym->n_name != 'L') &&
				!(COMMON(sym->n_type) || GLOBAL(sym->n_type)) ) {
			if( sym->n_type & S_TEXT ) {
				sym->n_value += textoff;
				sym->n_value += symtab.s_text;
			}
			else if( sym->n_type & S_DATA ) {
				sym->n_value += dataoff;
				sym->n_value += symtab.s_data;
			}
			else if( sym->n_type & S_BSS ) {
				sym->n_value += bssoff;
				sym->n_value += symtab.s_bss;
			}
			if( xflag ) {
				if (sflag == 0) 
					PUTSYM(sym,seofd,snofd);
				mstcnt++;
			}
		}
		lastsym++;
	}
	return(eptr);
}

dumpalias(sym)
register char *sym;
{
	register struct aliases *aptr;

	for( aptr = symtab.f_aptr; aptr->n_aptr != 0; aptr = aptr->n_aptr ) {
		if( symcmp(sym,aptr->symname) == 0 ) {
			PUTSYM(&aptr->link->h_sym,seofd,snofd);
			mstcnt++;
			return;
		}
	}
}
